<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Filtrar Pedidos</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f7f7f7;
        }
        .container {
            background: #fff;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .btn-voltar {
            background-color: #000;
            color: #ffffff;
            border-radius: 0;
            padding: 10px 20px;
            margin: 10px 0;
            display: block;
            width: 100%;
        }
        .total-vendas {
            background-color: #4CAF50;
            color: white;
            padding: 20px;
            margin-bottom: 20px;
            font-size: 20px;
            text-align: center;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #333;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        @media screen and (max-width: 768px) {
            .btn-voltar {
                width: auto;
            }
        }
    </style>
</head>
<body>
<br>


<div class="container">
<a href="<?php echo home_url("/tela-vendedor/?chave=") . urlencode($_GET['chave']); ?>" class="btn" style="margin-bottom: 20px; margin: 10px; background-color: #000; color: #ffffff; border-radius: 0; padding: 10px 20px;">VOLTAR</a>


<h2  style='text-align: center' >Relatorio</h2> <br>
 <form method="get" action="">
        <div class="form-group">
            <label for="dataInicial">Data Inicial:</label>
            <input type="date" class="form-control" id="dataInicial" name="data_inicial" value="<?php echo date('Y-m-d'); ?>">
        </div>
        <div class="form-group">
            <label for="dataFinal">Data Final:</label>
            <input type="date" class="form-control" id="dataFinal" name="data_final" value="<?php echo date('Y-m-d'); ?>">
        </div>
        <button type="submit" class="btn btn-primary" style="width: 100%;">Filtrar</button>


 <input type="hidden" class="form-control" id="dataFinal" name="chave" value="<?php echo $_GET['chave']; ?>">


    </form>
    <!-- Rest of your PHP and HTML code -->
    </div>
<?php
// Verifica se as datas foram fornecidas
if (isset($_GET['data_inicial']) && isset($_GET['data_final'])) {
    $data_inicial = $_GET['data_inicial'];
    $data_final = $_GET['data_final'];
    $categoria_id = 4; // ID da categoria desejada
	$chave = $_GET['chave'];

    // Argumentos para a consulta
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => -1, // Considerar todos os posts
        'cat' => $categoria_id,
        'meta_query' => array(
            array(
                'key' => 'chave',
                'value' => $chave,
                'compare' => '=',
            ),
        ),
        'date_query' => array(
            array(
                'after' => $data_inicial,
                'before' => $data_final,
                'inclusive' => true,
            ),
        ),
        'order' => 'DESC',
        'orderby' => 'date',
    );

    $query = new WP_Query($args);
    $total_vendas = 0;

    // Primeiro, percorre os posts para calcular o total de vendas
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $tempovalor = get_post_meta(get_the_ID(), 'tempovalor', true);
            $total_vendas += floatval($tempovalor);
        }

        // Mostra o total de vendas acima da tabela
        echo "<div class='container'>";
        echo "<div class='total-vendas'>Total de Vendas: R$ " . number_format($total_vendas, 2, ',', '.') . "</div>";
        echo "<table><thead><tr><th>Vendedor</th><th>Data</th><th>Valor</th></tr></thead><tbody>";

        // Reinicia a consulta para percorrer novamente os posts
        $query->rewind_posts();

        // Agora, percorre novamente os posts para exibir os detalhes na tabela
        while ($query->have_posts()) {
            $query->the_post();
            $tempovalor = get_post_meta(get_the_ID(), 'tempovalor', true);
            echo "<tr><td>" . get_the_title() . "</td><td>" . get_the_date('d/m/Y') . "</td><td>R$ " . number_format(floatval($tempovalor), 2, ',', '.') . "</td></tr>";
        }
        echo "</tbody></table></div>";
    } else {
        echo "<p>Nenhum post encontrado.</p>";
    }

    wp_reset_postdata();
} else {
   // echo "<p>Por favor, selecione um intervalo de datas e tente novamente.</p>";
}
?>


</body>
</html>




 