import{defineAsyncComponent}from"../../../libs/vue-esm.js";import{parseGradient}from"../libs/gradient-parser.min.js";export default{components:{contextmenu:defineAsyncComponent(()=>import("../utility/contextmenu.min.js?ver=3.3.1"))},props:{value:String,returnData:Function},data(){return{grad:this.value,dragging:null,mouseDown:!1,gradientHover:!1,controlhover:!1,controlNewx:0,strings:{colour:__("Colour","uipress-lite"),deleteStop:__("Delete stop","uipress-lite")},gradTypes:{"linear-gradient":{value:"linear-gradient",label:__("Linear","uipress-lite")},"radial-gradient":{value:"radial-gradient",label:__("Radial","uipress-lite")}},radialTypes:{circle:{value:"circle",label:__("Circle","uipress-lite")},ellipse:{value:"ellipse",label:__("Ellipse","uipress-lite")}},gradient:{shape:"circle",type:"linear-gradient",orientation:{type:"angular",value:"0"},colorStops:[{length:{type:"%",value:"0"},type:"hex",value:"#92FE9D"},{length:{type:"%",value:"100"},type:"hex",value:"#00C9FF"}]}}},watch:{gradient:{handler(){this.grad=this.returnGradAsString,this.returnData(this.grad)},deep:!0},"gradient.colorStops":{handler(){this.gradient.colorStops=this.gradient.colorStops.sort((t,e)=>t.length.value-e.length.value)},deep:!0}},created:function(){this.parseGradient()},computed:{returnGradAsString(){let t=this.gradient.type;return this.gradient.colorStops.length<1?"":"linear-gradient"==t?this.returnLinearGradient():"radial-gradient"==t?this.returnRadialGradient():void 0},returnGradAsLinear(){return this.gradient.colorStops.length<1?"":this.returnLinearGradient(!0)},lineAngle(){let t=(90-this.gradient.orientation.value)*(Math.PI/180);return{x:120+48*Math.cos(t),y:65-48*Math.sin(t)}}},methods:{returnRadialGradient(){let t="circle";this.gradient.shape&&(t=this.gradient.shape);let e=[];for(let t of this.gradient.colorStops){let n=t.value;t.length&&(n+=" "+t.length.value+t.length.type),e.push(n)}return`radial-gradient(${t},${e.join(",")})`},returnLinearGradient(t){let e;"directional"==this.gradient.orientation.type?e="to "+this.gradient.orientation.value:(this.gradient.orientation.value||(this.gradient.orientation.value=0),e=this.gradient.orientation.value+"deg"),t&&(e="90deg");let n=[];for(let t of this.gradient.colorStops){let e=t.value;t.length&&(e+=" "+t.length.value+t.length.type),n.push(e)}return`linear-gradient(${e},${n.join(",")})`},parseGradient(){if(!this.grad)return;if(!this.grad.includes("gradient"))return;let t;try{t=parseGradient.parse(this.grad)}catch(t){return}this.gradient={...this.gradient,...structuredClone(t[0])}},addStop(){this.gradient.colorStops.push({type:"heax",value:"#00c9ff",length:{type:"%",value:"50"}})},setGradType(t){this.gradient.type=t},returnDynamicColorScreen(t){return{component:"ColorPicker",label:this.strings.colour,value:t.value,returnData:e=>{if(e.startsWith("--"))return t.value=`var(${e})`;t.value=e}}},startPointDrag(t,e){2!==e.button&&(2!==e.detail?(this.dragging=t,this.mouseDown=!0,document.addEventListener("mousemove",this.onMoveColor),document.addEventListener("mouseup",this.endDragColor),setTimeout(()=>{this.mouseDown=!1},500)):this.loadColorPicker(t))},onMoveColor(t){if(!this.dragging||!this.$refs.gradientcontrol)return;const e=this.$refs.gradientcontrol.getBoundingClientRect(),n=(t.clientX-e.left)/e.width*100;this.dragging.length.value=Math.min(Math.max(0,n),100)},endDragColor(){this.dragging=null,document.removeEventListener("mousemove",this.onMoveColor),document.removeEventListener("mouseup",this.endDragColor)},loadColorPicker(t){this.$emit("request-screen",this.returnDynamicColorScreen(t))},pushNewColorAtLocation(t){if(2===t.detail)return;let e={type:"heax",value:"#00c9ff",length:{type:"%",value:this.getRelativeCoordinates(t).x}};this.gradient.colorStops.push(e)},getRelativeCoordinates(t){const e=this.$refs.gradientcontrol.getBoundingClientRect();let n=t.clientX-e.left,r=t.clientY-e.top,i=n/e.width*100,o=r/e.height*100;return{x:i.toFixed(2),y:o.toFixed(2)}},startRotate(){this.dragging=!0,document.addEventListener("mousemove",this.performRotate),document.addEventListener("mouseup",this.stopRotate)},performRotate(t){if(!this.dragging)return;const e=this.$refs.anglecenter.getBoundingClientRect(),n=e.left+e.width/2,r=e.top+e.height/2,i=t.clientX-n,o=r-t.clientY;let a=Math.atan2(o,i);if(t.shiftKey){let t=(a*(180/Math.PI)+90)%360;a=((t=45*Math.round(t/45))-90)*(Math.PI/180)}this.gradient.orientation.value=(90-a*(180/Math.PI))%360},stopRotate(){this.dragging=!1,document.removeEventListener("mousemove",this.performRotate),document.removeEventListener("mouseup",this.stopRotate)},setNewControlPos(t){this.controlhover=!0;let e=t.offsetX;e>240&&(e=240),this.controlNewx=parseFloat(e).toFixed(0)}},template:'\n  \n\t  <div class="uip-flex uip-flex-column uip-row-gap-s">\n\t\t\n\t\t\n\t\t<toggle-switch :activeValue="gradient.type" :options="gradTypes" :small="true" :returnValue="(d) => {gradient.type = d}" class="uip-text-s"/>\n\t\t\n\t\t<div class="" @mouseleave="controlhover = false" @mousemove="setNewControlPos" >\n\t\t\n\t\t  \x3c!--Catches overdrag and prevents dropdowns from closing--\x3e\n\t\t  <div v-if="dragging" @click.stop.prevent="dragging = false;" @mouseup.stop.prevent="dragging = false" style="position:fixed;left:0;right:0;top:0;bottom:0"></div>\n\t\t\n\t\t  \x3c!--Gradient line / stop manager--\x3e\n\t\t  <svg ref="gradientcontrol" xmlns=\'http://www.w3.org/2000/svg\' @click="pushNewColorAtLocation($event)" \n\t\t  class="uip-h-8 uip-border-rounder uip-overflow-visible uip-background-checkered uip-w-100p" :style="\'background:\' + returnGradAsLinear">\n\t\t  \n\t\t\t\x3c!--Controls--\x3e\n\t\t\t<g>\n\t\t\t  \n\t\t\t  \x3c!--New point marker--\x3e\n\t\t\t  <ellipse v-if="controlhover"\n\t\t\t  :cx="controlNewx" cy="50%" rx="2" ry="2" fill="#fff" stroke="#fff" stroke-width="2" style="filter:drop-shadow(0px 0px 1px grey);"/>\n\t\t\t  \n\t\t\t  <template v-for="(color, index) in gradient.colorStops">\n\t\t\t\t\n\t\t\t\t<ellipse @mousedown.prevent.stop="startPointDrag(color, $event)"\n\t\t\t\t@contextmenu.prevent.stop="$refs[\'stopcontext\' + index][0].show($event)"\n\t\t\t\t:cx="color.length.value + \'%\'" cy="50%" rx="6" ry="6" :fill="color.value" stroke="#fff" stroke-width="2" style="cursor:grab;filter:drop-shadow(0px 0px 1px grey);"/>\n\t\t\t\t\n\t\t\t  </template>\n\t\t\t  \n\t\t\t</g>\n\t\t\t\n\t\t\t\n\t\t  </svg>\n\t\t\n\t\t</div>\n\t\t\n\t\t\x3c!--Contex menus for stops--\x3e\n\t\t<template v-for="(color, index) in gradient.colorStops">\n\t\t  <contextmenu :ref="\'stopcontext\' + index" :disableTeleport="true">\n\t\t\t\n\t\t\t<div class="uip-padding-xs uip-flex uip-flex-column uip-text-weight-normal uip-text-s">\n\t\t\t  \n\t\t\t\n\t\t\t  <a class="uip-link-danger uip-flex uip-flex-center uip-flex-between"\n\t\t\t  @click.prevent="gradient.colorStops.splice(index, 1)">\n\t\t\t\t<span class="">{{strings.deleteStop}}</span>\n\t\t\t\t<span class="uip-icon">delete</span>\n\t\t\t  </a>\n\t\t\t\n\t\t\t</div>\n\t\t\t\n\t\t  </contextmenu>\n\t\t</template>\n\t\t\n\t\t<svg ref="gradientanglecontrol" xmlns=\'http://www.w3.org/2000/svg\' @mouseenter="gradientHover = true" @mouseleave="gradientHover = false"\n\t\tclass="uip-border-rounder uip-w-100p uip-h-130 uip-background-checkered" :style="\'background:\' + returnGradAsString" viewBox="0 0 240 130">\n\t\t\n\t\t\t<g v-show="gradient.type == \'linear-gradient\' && (gradientHover || dragging)">\n\t\t\t  \n\t\t\t  <line ref="angleLine" x1="120" y1="65" :x2="lineAngle.x" :y2="lineAngle.y" stroke-width="2" stroke="rgba(1,1,1,0.2)" />\n\t\t\t  \n\t\t\t  <ellipse ref="anglecenter"\n\t\t\t  cx="50%" cy="50%" rx="4" ry="4" fill="transparent" stroke="#fff" stroke-width="2" style="filter:drop-shadow(0px 0px 1px grey);"/>\n\t\t\t  \n\t\t\t  <ellipse :cx="lineAngle.x" :cy="lineAngle.y" rx="4" ry="4" fill="rgba(255, 255, 255, 0.4)" stroke="#fff" stroke-width="2" \n\t\t\t  @mousedown.stop.prevent="startRotate"\n\t\t\t  style="cursor:grab;filter:drop-shadow(0px 0px 1px grey);"/>\n\t\t\t  \n\t\t\t  \n\t\t\t\n\t\t\t</g>\n\t\t\n\t\t</svg>\n\t\t\n\t\t\n\t\t\n\t\t<toggle-switch \n\t\tv-if="gradient.type == \'radial-gradient\'"\n\t\t:activeValue="gradient.shape" :options="radialTypes" :small="true" :returnValue="(d) => {gradient.shape = d}" class="uip-text-s"/>\n\t\t\n\t\t\n\t  </div>\n\t\t'};