<?php
namespace UipressPro\Classes\Blocks;
use UipressLite\Classes\Utils\Ajax;
use UipressLite\Classes\Utils\Sanitize;

!defined('ABSPATH') ? exit() : '';

class ShortCode
{
  /**
   * Runs and returns given shortcode
   *
   * @since 3.0.96
   */
  public static function get_shortcode()
  {
    // Check security nonce and 'DOING_AJAX' global
    Ajax::check_referer();

    $shortCode = stripslashes(sanitize_text_field($_POST['shortCode']));

    if (!$shortCode) {
      $message = __('Unable to run shortcode', 'uipress-pro');
      $returndata['error'] = true;
      $returndata['message'] = $message;
      wp_send_json($returndata);
    }

    ob_start();

    echo do_shortcode($shortCode);

    $code = ob_get_clean();

    $returndata = [];
    $returndata['shortCode'] = $code;
    $returndata['success'] = true;
    wp_send_json($returndata);
  }
}
