<?php
/**
 * Twenty Twenty-Two functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_Two
 * @since Twenty Twenty-Two 1.0
 */


if ( ! function_exists( 'twentytwentytwo_support' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since Twenty Twenty-Two 1.0
	 *
	 * @return void
	 */
	function twentytwentytwo_support() {

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style.css' );
	}

endif;

add_action( 'after_setup_theme', 'twentytwentytwo_support' );

if ( ! function_exists( 'twentytwentytwo_styles' ) ) :

	/**
	 * Enqueue styles.
	 *
	 * @since Twenty Twenty-Two 1.0
	 *
	 * @return void
	 */
	function twentytwentytwo_styles() {
		// Register theme stylesheet.
		$theme_version = wp_get_theme()->get( 'Version' );

		$version_string = is_string( $theme_version ) ? $theme_version : false;
		wp_register_style(
			'twentytwentytwo-style',
			get_template_directory_uri() . '/style.css',
			array(),
			$version_string
		);

		// Enqueue theme stylesheet.
		wp_enqueue_style( 'twentytwentytwo-style' );
	}

endif;

add_action( 'wp_enqueue_scripts', 'twentytwentytwo_styles' );

// Add block patterns
require get_template_directory() . '/inc/block-patterns.php';



/////////////
 







/////////////////////////////////////

add_filter( 'woocommerce_checkout_fields' , 'customize_checkout_fields' );

function customize_checkout_fields( $fields ) {
    $only_virtual = true;
    foreach( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
        // Verifica se h produtos no virtuais
        if ( ! $cart_item['data']->is_virtual() ) $only_virtual = false;
    }

    if( $only_virtual ) {
        unset($fields['billing']['billing_company']);
        unset($fields['billing']['billing_address_1']);
        unset($fields['billing']['billing_address_2']);
        unset($fields['billing']['billing_city']);
        unset($fields['billing']['billing_postcode']);
        unset($fields['billing']['billing_country']);
        unset($fields['billing']['billing_state']);
        unset($fields['billing']['billing_phone']);
        // Desativa o campo de notas do pedido
        add_filter( 'woocommerce_enable_order_notes_field', '__return_false' );
    }
    return $fields;
}



add_action('woocommerce_product_query', 'filtrar_produtos_por_categoria');
function filtrar_produtos_por_categoria($query) {
    if (!empty($_GET['categoria_produto'])) {
        $categoria = sanitize_text_field($_GET['categoria_produto']);
        $tax_query = (array) $query->get('tax_query');

        $tax_query[] = array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => $categoria,
                'operator' => 'IN',
        );

        $query->set('tax_query', $tax_query);
    }
}

















add_action( 'template_redirect', 'redirecionar_apos_finalizar_pedido' );

function redirecionar_apos_finalizar_pedido() {
    // Verificar se estamos na pgina de finalizao de pedido do WooCommerce
    if ( ! is_wc_endpoint_url( 'order-received' ) ) {
        return;
    }

    // Verificar se o parmetro "wcf-order" est presente na URL
    if ( isset( $_GET['wcf-order'] ) ) {
        // Obter o ID do pedido a partir do parmetro "wcf-order"
        $order_id = sanitize_text_field( $_GET['wcf-order'] );

        // Verificar se o pedido est pago
        $order = wc_get_order( $order_id );
        if ( $order && $order->is_paid() ) {
            // Construir a URL de redirecionamento com o ID do pedido
            $url_redirecionamento = home_url( '/impressao/?impressao=' . $order_id );

            // Redirecionar para a URL de redirecionamento
            wp_redirect( $url_redirecionamento );
            exit;
        }
    }
}



 




 















add_action('wp_footer', 'custom_delete_cart_script');
function custom_delete_cart_script() {
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var deleteOrdersBtn = document.getElementById('limpar');
            if (deleteOrdersBtn) {
                deleteOrdersBtn.addEventListener('click', function(event) {
                    event.preventDefault(); // Previne o comportamento padro do link
                    var data = {
                        'action': 'custom_delete_cart'
                    };
                    // Envia uma solicitao AJAX para limpar o carrinho
                    jQuery.post('<?php echo admin_url('admin-ajax.php'); ?>', data, function(response) {
                        // Redireciona para a pgina inicial aps limpar o carrinho
                        window.location.href = '<?php echo home_url(); ?>';
                    });
                });
            }
        });
    </script>
    <?php
}

// Manipulador de AJAX para limpar o carrinho
add_action('wp_ajax_custom_delete_cart', 'custom_delete_cart');
add_action('wp_ajax_nopriv_custom_delete_cart', 'custom_delete_cart');
function custom_delete_cart() {
    WC()->cart->empty_cart();
    die();
}





// Defina uma funo para lidar com a verificao e redirecionamento
function verificar_pedido_e_redirecionar() {
    // Obtm o ID do pedido da URL
    $order_id = isset($_GET['wcf-order']) ? intval($_GET['wcf-order']) : 0;

    // Verifica se o ID do pedido  vlido
    if ($order_id > 0) {
        // Obtm o status do pedido
        $order = wc_get_order($order_id);
        $order_status = $order->get_status();

        // Se o status do pedido for 'completed', redireciona para a pgina de impresso
        if ($order_status === 'completed') {
            $url_redirecionamento = home_url('/impressao/?impressao=' . $order_id);
            wp_redirect($url_redirecionamento);
            exit;
        }
    }
}

// Engatilhe a funo acima no gancho 'template_redirect'
add_action('template_redirect', 'verificar_pedido_e_redirecionar');




function custom_logout() {
    wp_logout();
    wp_safe_redirect(home_url());
    exit();
}
add_action('wp_ajax_custom_logout', 'custom_logout');
add_action('wp_ajax_nopriv_custom_logout', 'custom_logout'); // For logged-out users.









function redirecionar_admin_para_produtos( $redirect_to, $request, $user ) {
    // Verifica se o usurio est logando e  um administrador
    if ( isset( $user->roles ) && is_array( $user->roles ) ) {
        if ( in_array( 'administrator', $user->roles ) ) {
            // Define o URL de redirecionamento para a pgina de produtos do WooCommerce
            return admin_url( 'edit.php?post_type=product' );
        } else {
            // Para outros papis, mantm o redirecionamento padro
            return $redirect_to;
        }
    } else {
        return $redirect_to;
    }
}
add_filter( 'login_redirect', 'redirecionar_admin_para_produtos', 10, 3 );












add_action('init', function() {
    remove_post_type_support('product', 'editor');
}, 99);




function custom_remove_product_permalink($return, $post_id, $new_title, $new_slug, $post){
    if($post->post_type === 'product'){
        // Retorna vazio para remover o link permanente
        return '';
    }
    return $return;
}
add_filter('get_sample_permalink_html', 'custom_remove_product_permalink', 10, 5);








