 




<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Filtro de Pedidos</title>
  <!-- Bootstrap CSS -->
  <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>

<div id="primary" class="content-area">
    <main id="main" class="site-main">
<a href="<?php echo home_url(); ?>" class="btn btn-success" style="margin-bottom: 20px; margin: 10px; background-color: #000; border-radius: 0; padding: 10px 20px;">VOLTAR</a>

        <div class="container">





            <h2>Filtro de Pedidos</h2>

           <form method="get" action="">
    <div class="form-group">
        <select class="form-control" id="usuarioSelect" name="usuario">
            <option value="">Todos os clientes</option>
            <?php
            $users = get_users();
            foreach ($users as $user) {
                echo '<option value="' . esc_attr($user->ID) . '">' . esc_html($user->display_name) . '</option>';
            }
            ?>
        </select>
    </div>

    <div class="form-group">
        <select class="form-control" id="tipoPagamentoSelect" name="tipo_pagamento">
            <option value="">Todos os tipos de pagamento</option>
            <?php
            $payment_gateways = WC()->payment_gateways->get_available_payment_gateways();
            foreach ($payment_gateways as $id => $payment_gateway) {
                if ($payment_gateway->enabled == 'yes') {
                    echo '<option value="' . esc_attr($id) . '">' . esc_html($payment_gateway->title) . '</option>';
                }
            }
            ?>
        </select>
    </div>

    <div class="form-group">
        <label for="categoriaProdutoSelect">Categoria do Produto:</label>
        <select class="form-control" id="categoriaProdutoSelect" name="categoria_produto">
            <option value="">Todas as categorias de produto</option>
            <?php
            $product_categories = get_terms(array(
                'taxonomy' => 'product_cat',
                'hide_empty' => true, // Mude para true para listar apenas categorias com produtos
            ));
            foreach ($product_categories as $category) {
                echo '<option value="' . esc_attr($category->term_id) . '">' . esc_html($category->name) . '</option>';
            }
            ?>
        </select>
    </div>

    <div class="form-group">
        <label for="dataInicial">Data Inicial:</label>
        <input type="date" class="form-control" id="dataInicial" name="data_inicial" value="<?php echo date('Y-m-d'); ?>">
    </div>

    <div class="form-group">
        <label for="dataFinal">Data Final:</label>
        <input type="date" class="form-control" id="dataFinal" name="data_final" value="<?php echo date('Y-m-d'); ?>">
    </div>

    <button type="submit" class="btn btn-primary">Filtrar</button>
</form>



<?php the_content();?>

            <?php

// Obtendo os parmetros do formulrio
$usuario_id = isset($_GET['usuario']) ? intval($_GET['usuario']) : '';
$tipo_pagamento = isset($_GET['tipo_pagamento']) ? sanitize_text_field($_GET['tipo_pagamento']) : '';
$categoria_produto = isset($_GET['categoria_produto']) ? intval($_GET['categoria_produto']) : '';
$data_inicial = isset($_GET['data_inicial']) ? sanitize_text_field($_GET['data_inicial']) : '';
$data_final = isset($_GET['data_final']) ? sanitize_text_field($_GET['data_final']) : '';

// Construindo os argumentos para a consulta de pedidos
$args = array(
    'status' => array('completed', 'processing'),
    'limit'  => -1,
    'date_query' => array(),
);

if (!empty($usuario_id)) {
    $args['customer'] = $usuario_id;
}

if (!empty($tipo_pagamento)) {
    $args['payment_method'] = $tipo_pagamento;
}

if (!empty($categoria_produto)) {
    $products_in_category = get_posts(array(
        'post_type' => 'product',
        'numberposts' => -1,
        'post_status' => 'publish',
        'fields' => 'ids',
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $categoria_produto,
            ),
        ),
    ));

    if (!empty($products_in_category)) {
        $args['meta_query'][] = array(
            'key' => '_product_id',
            'value' => $products_in_category,
            'compare' => 'IN',
        );
    }
}

if (!empty($data_inicial) && !empty($data_final)) {
    $data_inicial = date('Y-m-d', strtotime($data_inicial));
    $data_final = date('Y-m-d', strtotime($data_final));

    $args['date_query'] = array(
        'after' => $data_inicial,
        'before' => $data_final,
        'inclusive' => true,
    );
}

$pedidos = wc_get_orders($args);
echo '<pre>';
print_r($pedidos);
echo '</pre>';


// Exibindo os resultados
echo '<div class="container">';
echo '<h3>Resultados:</h3>';

if (!empty($pedidos)) {
    echo '<table class="table">';
    echo '<thead>';
    echo '<tr>';
    echo '<th>Nmero do Pedido</th>';
    echo '<th>Nome do Produto</th>';
    echo '<th>Categoria</th>';
    echo '<th>Valor</th>';
    echo '<th>Nome do Cliente</th>'; // Adicionado o cabealho para o nome do cliente
    echo '<th>Total</th>';
    echo '<th>Forma de Pagamento</th>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $total_vendas = 0;

    foreach ($pedidos as $pedido) {
        $numero_pedido = $pedido->get_order_number();
        $forma_pagamento = $pedido->get_payment_method();

        if ($forma_pagamento === 'woo-mercado-pago-pix') {
            $forma_pagamento = 'Pix';
        } elseif ($forma_pagamento === 'cod') {
            $forma_pagamento = 'Dinheiro';
        }

        $nome_cliente = $pedido->get_billing_first_name() . ' ' . $pedido->get_billing_last_name();

        $itens = $pedido->get_items();
        foreach ($itens as $item) {
            $produto = $item->get_product();
            echo '<tr>';
            echo '<td>' . ($item === reset($itens) ? $numero_pedido : '') . '</td>';
            echo '<td>' . $produto->get_name() . '</td>';
            echo '<td>' . implode(', ', wp_get_post_terms($produto->get_id(), 'product_cat', array('fields' => 'names'))) . '</td>';
            echo '<td>' . wc_price($produto->get_price()) . '</td>';
            echo '<td>' . $nome_cliente . '</td>'; // Exibindo o nome do cliente
            echo '<td>' . wc_price($item->get_total()) . '</td>';
            echo '<td>' . $forma_pagamento . '</td>';
            echo '</tr>';
            $total_vendas += $item->get_total();
        }
    }

    echo '</tbody>';
    echo '</table>';
    echo '<div>Total de Vendas: ' . wc_price($total_vendas) . '</div>';
} else {
    echo '<p>Nenhum produto vendido encontrado com os filtros aplicados.</p>';
}

echo '</div>';
?>


        </div><!-- .container -->
    </main><!-- #main -->
</div><!-- #primary -->

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<?php
// Adicione aqui o rodap  do WordPress
get_footer();
?>
