<!DOCTYPE html>
<html lang="pt-BR">
<head>

 

    <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>



<style>

.sumir{

display:none;

}


 
</style>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Filtrar Pedidos</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
 
<div class="container mt-3">


<h2  style='text-align: center' >Relatorio</h2> <br>




    <form method="get" action="">
        <div class="form-group sumir">



<select class="form-control " id="usuarioSelect" name="usuario">
 
    <?php
    // Verifica se o usurio est logado
    if (is_user_logged_in()) {
        // Obtm o ID do usurio atualmente logado
        $current_user_id = get_current_user_id();
        
        // Obtm as informaes do usurio atualmente logado
        $current_user = get_userdata($current_user_id);
        
        // Exibe a opo com o nome do usurio atualmente logado selecionado
        echo '<option value="' . esc_attr($current_user->ID) . '" selected>' . esc_html($current_user->display_name) . '</option>';
    } else {
        // Se o usurio no estiver logado, exibe uma mensagem padro
        echo '<option value="" disabled>Nenhum cliente disponvel (voc no est logado)</option>';
    }
    ?>
</select>


        </div>

        <div class="form-group sumir">
            <select class="form-control" id="tipoPagamentoSelect" name="tipo_pagamento">
                <option value="">Todos os tipos de pagamento</option>
                <?php
                $payment_gateways = WC()->payment_gateways->get_available_payment_gateways();
                foreach ($payment_gateways as $id => $payment_gateway) {
                    if ($payment_gateway->enabled == 'yes') {
                        echo '<option value="' . esc_attr($id) . '">' . esc_html($payment_gateway->title) . '</option>';
                    }
                }
                ?>
            </select>
        </div>

       

        <div class="form-group">
            <label for="dataInicial">Data Inicial:</label>
            <input type="date" class="form-control" id="dataInicial" name="data_inicial" value="<?php echo date('Y-m-d'); ?>">
        </div>

        <div class="form-group">
            <label for="dataFinal">Data Final:</label>
            <input type="date" class="form-control" id="dataFinal" name="data_final" value="<?php echo date('Y-m-d'); ?>">
        </div>



 <div class="form-group  ">
 
            <select class="form-control" id="categoriaProdutoSelect" name="categoria_produto">
                <option value="">Todas as categorias de produto</option>
                <?php
                $product_categories = get_terms(array(
                    'taxonomy' => 'product_cat',
                    'hide_empty' => false,
                ));
                foreach ($product_categories as $category) {
                    echo '<option value="' . esc_attr($category->term_id) . '">' . esc_html($category->name) . '</option>';
                }
                ?>
            </select>
        </div>



<button type="submit" class="btn btn-primary" style="
    width: 100%;
">Filtrar</button>


 


    </form>



<div id="pre_print">

   <?php
// Verifica se todas as informaes necessrias foram fornecidas
if (!isset($_GET['usuario'], $_GET['tipo_pagamento'], $_GET['data_inicial'], $_GET['data_final'])) {
    echo " ";
} else {
    $usuario = $_GET['usuario'];
    $tipo_pagamento = $_GET['tipo_pagamento'];
    // Verifica se a categoria do produto foi especificada, caso contrrio, considera todas
    $categoria_produto = isset($_GET['categoria_produto']) && !empty($_GET['categoria_produto']) ? $_GET['categoria_produto'] : 'todas';
    $data_inicial = $_GET['data_inicial'];
    $data_final = $_GET['data_final'];

// Exibe os parmetros fornecidos
echo "<br><h2 style='text-align: center; font-size: 30px;'>Detalhes das Vendas:</h2>"; // Ajusta o tamanho da fonte do ttulo
echo "<b style='font-size: 23px;'>Vendedor:</b> <span style='font-size: 23px;'>" . ($usuario ? get_userdata($usuario)->display_name : "Todos os clientes") . "</span><br>"; // Aplica estilo ao valor da varivel
echo "<b style='font-size: 23px;'>Datas:</b> <span style='font-size: 23px;'>" . date('d/m/y', strtotime($data_inicial)) . " e " . date('d/m/y', strtotime($data_final)) . "</span><br>"; // Aplica estilo ao valor da varivel
echo "<b style='font-size: 23px;'>Categoria:</b> <span style='font-size: 23px;'>" . ($categoria_produto !== 'todas' ? get_term($categoria_produto, 'product_cat')->name : "Todas as categorias") . "</span><br><br>"; // Aplica estilo ao valor da varivel

    $args = [
        'limit' => -1,
        'date_created' => $data_inicial . '...' . $data_final,
    ];

    if (!empty($usuario)) {
        $args['customer'] = $usuario;
    }
    if (!empty($tipo_pagamento)) {
        $args['payment_method'] = $tipo_pagamento;
    }

    $orders = wc_get_orders($args);

    // Estruturas para agregao e totalizao
    $products_aggregated = [];
    $totals_by_payment_method = [];

    foreach ($orders as $order) {
        foreach ($order->get_items() as $item) {
            $product_id = $item->get_product_id();
            $product = wc_get_product($product_id);
            $product_name = $product->get_name();
            $payment_method = $order->get_payment_method_title();
            $aggregate_key = $product_name . '|' . $payment_method;

            if ($categoria_produto !== 'todas') {
                $product_categories = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'ids'));
                if (!in_array($categoria_produto, $product_categories)) {
                    continue;
                }
            }

            if (!isset($products_aggregated[$aggregate_key])) {
                $products_aggregated[$aggregate_key] = [
                    'quantity' => 0,
                    'price' => $product->get_price(),
                    'subtotal' => 0,
                ];
            }

            $products_aggregated[$aggregate_key]['quantity'] += $item->get_quantity();
            $products_aggregated[$aggregate_key]['subtotal'] += $item->get_total();

            if (!isset($totals_by_payment_method[$payment_method])) {
                $totals_by_payment_method[$payment_method] = 0;
            }
            $totals_by_payment_method[$payment_method] += $item->get_total();
        }
    }

    if (empty($products_aggregated)) {
        echo "<h2 style='text-align: center;'>Nenhum dado encontrado.</h2>";
    } else {
        $tamanho_fonte = '16px';

        echo "<table style='border-collapse: collapse; width: 100%; font-size: $tamanho_fonte; text-align: center;'>";
        echo "<thead>";
        echo "<tr>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Produto </th>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Qty/Pag</th>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Valor</th>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Total</th>";
        echo "</tr>";
        echo "</thead>";
        echo "<tbody>";

        foreach ($products_aggregated as $key => $value) {
            list($product_name, $payment_method) = explode('|', $key);
            echo "<tr>";
            echo "<td style='border: 1px solid #000; padding: 8px;'>(" . esc_html($value['quantity']) .  ")<br>" . esc_html($product_name) . "</td>";
            echo "<td style='border: 1px solid #000; padding: 8px;'>" . esc_html($payment_method) . "</td>";
            echo "<td style='border: 1px solid #000; padding: 8px;'>" . wc_price($value['price']) . "</td>";
            echo "<td style='border: 1px solid #000; padding: 8px;'>" . wc_price($value['subtotal']) . "</td>";
            echo "</tr>";
        }

        echo "</tbody>";
        echo "</table>";

        // Exibio dos totais por mtodo de pagamento
        echo "<br><h3 style='text-align: center;'>Formas de Pagamento</h3><br>";
        echo "<table table style='border-collapse: collapse; width: 100%; font-size: $tamanho_fonte; text-align: center;'>";
        echo "<thead>";
        echo "<tr>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Mtodo de Pagamento</th>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Total</th>";
        echo "</tr>";
        echo "</thead>";
        echo "<tbody>";

        foreach ($totals_by_payment_method as $method => $total) {
            echo "<tr>";
            echo "<td style='border: 1px solid #000; padding: 8px;'>" . esc_html($method) . "</td>";
            echo "<td table  style='border: 1px solid #000; padding: 8px;'>" . wc_price($total) . "</td>";
            echo "</tr>";
        }

        echo "</tbody>";
        echo "</table>";
    }
}
?>




<script>
    var dataURL = '';

    html2canvas(document.getElementById('pre_print')).then(function(canvas) {
        // Obtm a imagem em base64
        dataURL = canvas.toDataURL('image/png');
        // console.log(dataURL);  // Aqui voc pode usar ou enviar a imagem em base64 conforme necessrio

        window.AppInventor.setWebViewString(dataURL);
    });
</script>



</div>



</div>





<style>
 

table td {
    font-size: 16px; /* Ajuste o valor conforme necessrio */
}


</style>



<style>

.minhaTabelaEspecifica {
  width: 100% !important; /* Faz com que a tabela ocupe toda a largura do continer pai */
  border-collapse: collapse !important; /* Remove o espao entre as bordas das clulas */
  table-layout: auto !important; /* Permite que a largura das colunas se ajuste ao contedo */
}

.minhaTabelaEspecifica th, .minhaTabelaEspecifica td {
  border: 1px solid #ddd !important; /* Adiciona borda s clulas */
  padding: 8px !important; /* Adiciona um pouco de espao dentro das clulas */
  text-align: left !important; /* Alinha o texto  esquerda */
}

 



</style>





<!-- Bootstrap JS and dependencies -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
 
