const{__:__,_x:_x,_n:_n,_nx:_nx}=wp.i18n;import{defineAsyncComponent,nextTick}from"../../libs/vue-esm.js";const EditPreset={emits:["update","go-back"],components:{Confirm:defineAsyncComponent(()=>import("../v3.5/utility/confirm.min.js?ver=3.3.1"))},props:{preset:[String,Boolean],block:Object,activePart:String,presetID:String},data:()=>({presetName:"",strings:{presetName:__("Preset name","uipress-lite"),update:__("Update","uipress-lite"),delete:__("Delete","uipress-lite"),explanation:__("Create a new style preset from the current block style. Style presets can be used on any block and updating in one place will update across all your templates.","uipress-lite")}}),mounted(){this.setName()},methods:{setName(){"root"==this.activePart||this.activePart;const e=this.uipApp.data.options.block_preset_styles;if(!this.presetID)return!1;this.isObject(e)&&this.presetID in e&&(this.presetName=e[this.presetID].name)},async deletePreset(){if(await this.$refs.confirm.show({title:__("Delete preset","uipress-lite"),message:__("Are you sure you want to delete this custom preset?","uipress-lite"),okButton:__("Delete preset","uipress-lite"),disableTeleport:!0})){if(!this.uipApp.data.options.block_preset_styles)return;delete this.uipApp.data.options.block_preset_styles[this.presetID],this.$emit("go-back")}},updatePreset(){this.uipApp.data.options.block_preset_styles&&(this.uipApp.data.options.block_preset_styles[this.presetID].name=this.presetName,this.$emit("go-back"))}},template:'\n  \n  <div class="uip-flex uip-flex-column uip-padding-left-xs uip-gap-s">\n  \n    <input class="uip-input" type="text" v-model="presetName" :placeholder="strings.presetName">\n    \n    <div class="uip-flex uip-flex-between uip-gap-xs">\n    \n      <button @click="deletePreset()" class="uip-button-danger uip-flex-grow">\n        {{ strings.delete }}\n      </button>\n      \n      <button @click="updatePreset" class="uip-button-default uip-flex-grow" :disabled="!presetName">\n        {{ strings.update }}\n      </button>\n      \n    </div>\n    \n    <Confirm ref="confirm"/>\n    \n  </div>  \n  \n\n\n'},NewPreset={emits:["update","go-back"],components:{},props:{preset:[String,Boolean],block:Object,activePart:String},data:()=>({newName:"",strings:{createPreset:__("Create preset","uipress-lite"),presetName:__("Preset name","uipress-lite"),explanation:__("Create a new style preset from the current block style. Style presets can be used on any block and updating in one place will update across all your templates.","uipress-lite")}}),watch:{},computed:{},methods:{newPreset(){const e=this.uipApp.data.options.block_preset_styles;let t=this.isObject(e)?e:{};const n="root"==this.activePart?"style":this.activePart;this.ensureNestedObject(this.block,"settings",n);const i=this.deepClone(this.block.settings[n]);t[this.createUID()]={preset:i,name:this.newName},this.uipApp.data.options.block_preset_styles={...t},this.newName="",this.$emit("go-back")}},template:'\n  \n  <div class="uip-flex uip-flex-column uip-padding-left-xs uip-gap-s">\n  \n    <div class="uip-text-s">{{strings.explanation}}</div>\n  \n    <input class="uip-input" type="text" v-model="newName" :placeholder="strings.presetName">\n    \n    <button @click="newPreset" class="uip-button-default" :disabled="!newName">\n      {{ strings.createPreset }}\n    </button>\n    \n  </div>  \n  \n\n\n'},PresetList={emits:["update","request-screen"],components:{},props:{preset:[String,Boolean],block:Object,activePart:String},data:()=>({open:!0,strings:{searchPresets:__("Search presets","uipress-lite"),newPreset:__("New preset","uipress-lite"),noPresets:__("No presets yet","uipress-lite"),editPreset:__("Edit preset","uipress-lite")},search:""}),computed:{returnPresets(){const e=this.uipApp.data.options.block_preset_styles,t=this.search.toLowerCase();let n=this.isObject(e)?e:{},i={};for(let e in n){n[e].name.toLowerCase().includes(t)&&(i[e]=n[e])}return i},returnCurrentPreset(){const e="root"==this.activePart?"style":this.activePart;return this.hasNestedPath(this.block,"settings",e,"preset")}},methods:{requestNewPreset(){const e={component:"NewPreset",label:this.strings.newPreset};this.$emit("request-screen",e)},choosePreset(e){const t="root"==this.activePart?"style":this.activePart;this.ensureNestedObject(this.block,"settings",t,"preset"),this.block.settings[t].preset=e},editPreset(e){const t={component:"EditPreset",presetID:e,label:this.strings.editPreset};this.$emit("request-screen",t)}},template:'\n  \n  <div class="uip-flex uip-flex-column">\n  \n    <div class="uip-flex uip-flex-center uip-gap-xs uip-margin-bottom-s">\n    \n      <div class="uip-flex uip-gap-xs uip-flex-center uip-padding-xxs uip-padding-left-xs uip-background-muted uip-border-rounder uip-flex-grow">\n        <span class="uip-icon">search</span>\n        <input class="uip-blank-input uip-text-s" type="text" v-model="search" :placeholder="strings.searchPresets">\n      </div>\n      \n      <a @click="requestNewPreset" class="uip-link-muted uip-background-muted uip-border-rounder uip-icon uip-padding-xxs">add</a>\n    </div>\n    \n    <div class="uip-text-s" v-if="!Object.keys(returnPresets).length">{{strings.noPresets}}</div>\n    \n    <div class="uip-flex uip-flex-column uip-row-gap-xxs">\n      <template v-for="(preset, key) in returnPresets"> \n      \n        <a @click="choosePreset(key)"\n        :class=" returnCurrentPreset == key ? \'uip-background-muted uip-link-emphasis\' : \'hover:uip-background-muted uip-link-muted\'"\n        class="uip-padding-xxs uip-border-rounder uip-no-wrap uip-flex uip-flex-center uip-flex-between uip-gap-s uip-border-rounder">\n        \n          <span class="">{{ preset.name }}</span>\n          \n          <span @click.prevent.stop="editPreset(key)" class="uip-icon">edit</span>\n        \n        </a>\n      \n      </template>  \n    </div>\n    \n  </div>  \n  \n\n\n'},StylePresets={emits:["update"],components:{screenControl:defineAsyncComponent(()=>import("../v3.5/utility/screen-control.min.js?ver=3.3.1")),PresetList:PresetList,NewPreset:NewPreset,EditPreset:EditPreset},props:{block:Object,activePart:String},data:()=>({open:!1,preset:!0,strings:{presets:__("Preset","uipress-lite"),usePreset:__("Use preset","uipress-lite"),add:__("Add","uipress-lite")}}),watch:{"uipApp.data.options.block_preset_styles":{handler(){this.saveStylePresets()},deep:!0}},mounted(){this.returnCurrentPresetName&&(this.open=!0)},computed:{returnVisibilityIcon(){return this.open?"expand_more":this.open?void 0:"chevron_left"},returnPresetScreen(){return{component:"PresetList",preset:this.preset,label:this.strings.presets}},returnCurrentPresetName(){const e="root"==this.activePart?"style":this.activePart,t=this.hasNestedPath(this.block,"settings",e,"preset"),n=this.uipApp.data.options.block_preset_styles;return!!t&&(this.isObject(n)&&t in n?n[t].name:void 0)}},methods:{toggleVisibility(){this.open=!this.open},async saveStylePresets(){const e=this.prepareJSON(this.uipApp.data.options.block_preset_styles);let t=new FormData;t.append("action","uip_save_site_option"),t.append("security",uip_ajax.security),t.append("option",e),t.append("optionName","block_preset_styles");await this.sendServerRequest(uip_ajax.ajax_url,t)},removePreset(){const e="root"==this.activePart?"style":this.activePart;this.hasNestedPath(this.block,"settings",e,"preset")&&delete this.block.settings[e].preset}},template:'\n  \n      <div class="uip-flex uip-flex-column uip-row-gap-s">\n      \n        \x3c!-- Title --\x3e\n        <div class="uip-flex uip-gap-s uip-flex-center uip-flex-between">\n          \n         \n          <div class="uip-flex uip-gap-xs uip-flex-center uip-cursor-pointer uip-flex-between uip-flex-grow"\n          @click="toggleVisibility()">\n            \n            \n            <span class="uip-text-bold uip-text-emphasis">{{ strings.presets }}</span> \n            \n            <div v-if="returnCurrentPresetName"  class="uip-flex-grow">\n              <div class="uip-w-6 uip-ratio-1-1 uip-border-circle uip-background-secondary"></div>\n            </div>\n            \n            <a class="uip-link-muted uip-icon">{{ returnVisibilityIcon }}</a>\n            \n            \n          </div>\n          \n        \n        </div>\n        \n        <div v-if="open" class="uip-padding-left-s uip-grid-col-1-3">\n        \n          <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>{{strings.usePreset}}</span></div>\n          \n          \x3c!-- Select presets --\x3e\n          <dropdown pos="left top" :snapX="[\'#uip-block-settings\']" ref="presetsSwitcher">\n          \n            <template #trigger>\n              <div class="uip-background-muted uip-border-rounder uip-padding-xxxs uip-padding-right-xxs uip-flex uip-flex-between uip-flex-center uip-link-default">\n                \n                <div v-if="!returnCurrentPresetName" \n                class="uip-flex-grow uip-padding-xs uip-padding-top-xxxs uip-padding-bottom-xxxs uip-flex uip-gap-xxs uip-flex-center uip-link-default uip-text-s">\n                  {{strings.add}}...\n                </div>\n                \n                <div v-else \n                class="uip-padding-xs uip-padding-top-xxxs uip-padding-bottom-xxxs uip-background-highlight uip-border-rounder uip-border uip-flex uip-gap-xxs uip-flex-center uip-link-default uip-text-s">\n                  {{returnCurrentPresetName}}\n                </div>\n                \n                <div v-if="returnCurrentPresetName" @click.prevent.stop="removePreset()" class="uip-icon">close</div>\n                \n              </div>\n            </template>\n            \n            <template #content>\n            \n              <div class="uip-padding-s uip-w-240">\n                <screenControl :startScreen="returnPresetScreen" :homeScreen="returnPresetScreen.component"\n                :closer="$refs.presetsSwitcher.close" :showNavigation="true">\n                  \n                  <template #componenthandler="{ processScreen, currentScreen, goBack }">\n                    <KeepAlive>\n                      <component @request-screen="(d)=>{processScreen(d)}" @go-back="goBack()"\n                      :block="block"\n                      :preset="currentScreen.preset"\n                      :presetID="currentScreen.presetID"\n                      :activePart="activePart"\n                      :is="currentScreen.component"/>\n                    </KeepAlive>\n                  </template>\n                  \n                </screenControl>\n              </div>  \n            \n            </template>\n          </dropdown>\n          \n        </div>\n        \n      </div>  \n  \n  \n  '},BlockParts={emits:["update"],components:{},props:{block:Object,activePart:String},data:()=>({part:null,strings:{blockPart:__("Block part","uipress-lite"),blockParts:__("Block parts","uipress-lite"),root:__("Root","uipress-lite")}}),watch:{part:{handler(){this.$emit("update",this.part)}},activePart:{handler(){this.part=this.activePart},immediate:!0}},computed:{returnActivePart(){if("root"==this.part)return this.strings.root;const e=this.returnBlockParts,t=e.findIndex(e=>e.name==this.part);return t<0?void 0:e[t].label},returnBlockPartsLength(){return this.returnBlockParts.length},returnBlockParts(){const e=this.block.moduleName,t=this.uipApp.data.blocks,n=[...t[t.findIndex(t=>t.moduleName==e)].optionsEnabled];return["advanced","style","block"].forEach(e=>{const t=n.findIndex(t=>t.name==e);t>=0&&n.splice(t,1)}),n}},methods:{selectPart(e){this.part=e,this.$refs.blockPartSwitcher.close()}},template:'\n  \n    <dropdown pos="left top" :snapX="[\'#uip-block-settings\']" v-if="returnBlockPartsLength" ref="blockPartSwitcher" class="uip-position-sticky uip-top-16 uip-z-index-2">\n      \n      <template #trigger>\n        <div class="uip-background-muted uip-border-rounder uip-padding-xs uip-flex uip-flex-between uip-flex-center uip-link-default">\n          \n          <div class=""><span class="uip-text-muted">{{strings.blockPart}}:</span> {{returnActivePart}}</div>\n          <div class="uip-icon">expand_more</div>\n          \n        </div>\n      </template>\n      \n      <template #content>\n        \n        <div class="uip-padding-s uip-flex uip-flex-column uip-text-weight-normal uip-w-240 uip-row-gap-xs">\n        \n          <div class="uip-flex uip-flex-between uip-flex-center">\n            \n            <div class="uip-text-emphasis uip-text-bold uip-text-s">{{ strings.blockParts }}</div>\n            \n            <div @click="$refs.blockPartSwitcher.close()" \n            class="uip-flex uip-flex-center uip-flex-middle uip-padding-xxs uip-link-muted hover:uip-background-muted uip-border-rounder">\n              <span class="uip-icon">close</span>\n            </div>\n          \n          </div>  \n          \n          <div class="uip-flex uip-flex-column">\n          \n            <a @click="selectPart(\'root\')"\n            :class="\'root\' == part ? \'uip-background-muted uip-link-emphasis\' : \'hover:uip-background-muted uip-link-default\'"\n            class="uip-padding-xxs uip-border-rounder uip-no-wrap uip-flex uip-flex-center uip-flex-between uip-gap-s uip-border-rounder">\n            \n              <span>root</span>\n            \n            </a>\n          \n            <template v-for="blockPart in returnBlockParts"> \n            \n              <a @click="selectPart(blockPart.name)"\n              :class="blockPart.name == part ? \'uip-background-muted uip-link-emphasis\' : \'hover:uip-background-muted uip-link-default\'"\n              class="uip-padding-xxs uip-border-rounder uip-no-wrap uip-flex uip-flex-center uip-flex-between uip-gap-s uip-border-rounder">\n              \n                <div class="uip-flex uip-flex-column">\n                  <span class="">{{ blockPart.label }}</span>\n                  <span class="uip-text-muted uip-text-s">{{ blockPart.class }}</span>\n                </div>\n                \n                <span class="uip-icon">{{blockPart.icon}}</span>\n              \n              </a>\n            \n            </template>\n          </div>\n        \n        </div>\n        \n      </template>\n    \n    </dropdown>\n  '},ToggleSection={props:{title:String,startOpen:Boolean},data:()=>({open:!1}),mounted(){this.startOpen&&(this.open=!0)},computed:{returnVisibilityIcon(){return this.open?"expand_more":this.open?void 0:"chevron_left"}},methods:{toggleVisibility(){this.open=!this.open}},template:'\n  \n    <div class="uip-flex uip-flex-column uip-row-gap-s">\n    \n      \x3c!-- Title --\x3e\n      <div class="uip-flex uip-gap-s uip-flex-center uip-flex-between">\n        \n       \n        <div class="uip-flex uip-gap-xxs uip-flex-center uip-cursor-pointer uip-flex-between uip-flex-grow"\n        @click="toggleVisibility()">\n          \n          \n          <span class="uip-text-bold uip-text-emphasis">{{ title }}</span> \n          \n          <a class="uip-link-muted uip-icon">{{ returnVisibilityIcon }}</a>\n          \n          \n        </div>\n      \n      </div>\n      \n      <div v-if="open" class="uip-padding-left-s">\n        <slot></slot>\n      </div>\n      \n    </div>\n  \n  '},BlockStyleHandler={emits:["update"],components:{flexLayout:defineAsyncComponent(()=>import("../options/flex-layout.min.js?ver=3.3.1")),contextmenu:defineAsyncComponent(()=>import("../v3.5/utility/contextmenu.min.js?ver=3.3.1")),Dimensions:defineAsyncComponent(()=>import("../options/dimensions.min.js?ver=3.3.1")),Styles:defineAsyncComponent(()=>import("../options/styles.min.js?ver=3.3.1")),Spacing:defineAsyncComponent(()=>import("../options/spacing.min.js?ver=3.3.1")),TextFormat:defineAsyncComponent(()=>import("../options/text-format.min.js?ver=3.3.1")),PositionDesigner:defineAsyncComponent(()=>import("../options/position-designer.min.js?ver=3.3.1")),EffectsDesigner:defineAsyncComponent(()=>import("../options/effects.min.js?ver=3.3.1"))},props:{styleSettings:Object,component:String,title:String,startOpen:Boolean,styleName:String},data:()=>({blockStyle:{},open:!1,activeState:"default",colorTheme:"light",loading:!1,strings:{toggleColour:__("Toggle dark / light mode","uipress-lite"),resetSection:__("Reset section","uipress-lite")},pseudoSelectors:[{value:"default",label:__("Default","uipress-lite")},{value:":active",label:__(":active","uipress-lite")},{value:":focus",label:__(":focus","uipress-lite")},{value:":hover",label:__(":hover","uipress-lite")},{value:":visited",label:__(":visited","uipress-lite")},{value:"::before",label:__("::before","uipress-lite")},{value:"::after",label:__("::after","uipress-lite")},{value:":menu-collapsed",label:__("Menu collapsed","uipress-lite")},{value:"tablet",label:__("Tablet","uipress-lite")},{value:"mobile",label:__("Mobile","uipress-lite")}]}),watch:{styleSettings:{handler(){this.injectPropValue()},deep:!0,immediate:!0}},computed:{returnVisibilityIcon(){return this.open?"expand_more":this.open?void 0:"chevron_left"},returnCurrentBlockStyle(){let e;switch(this.activeState){case"default":e="light"==this.colorTheme?this.blockStyle.value:this.blockStyle.darkValue;break;default:const t=this.activeState,n=this.colorTheme;this.ensureNestedObject(this.blockStyle,"pseudo",n,t),e=this.blockStyle.pseudo[n][t]}return e||(e={}),e},returnActiveState(){const e=this.pseudoSelectors.findIndex(e=>e.value==this.activeState);return this.pseudoSelectors[e].label},returnThemeIcon(){return"light"==this.colorTheme?"light_mode":"dark_mode"}},mounted(){this.startOpen&&(this.open=!0)},methods:{injectPropValue(){if(!this.isObject(this.styleSettings))return this.blockStyle={};this.blockStyle=this.styleSettings},toggleVisibility(){this.open=!this.open},handleStyleUpdate(e){switch(this.blockStyle.settingName||(this.blockStyle.settingName=this.styleName),this.activeState){case"default":const t="light"==this.colorTheme?"value":"darkValue";this.blockStyle[t]=e,this.break;default:const n=this.activeState,i=this.colorTheme;this.ensureNestedObject(this.blockStyle,"pseudo",i,n),this.blockStyle.pseudo[i][n]=e}},itemHasPseudo(e){const t=this.colorTheme;let n=this.hasNestedPath(this.blockStyle,"pseudo",t,e);return!!n&&0!==Object.keys(n).length},toggleColorMode(){const e="light"==this.colorTheme?"dark":"light";this.colorTheme=e},clearPseudo(e){this.hasNestedPath(this.blockStyle,"pseudo","light",e)&&delete this.blockStyle.pseudo.light[e],this.hasNestedPath(this.blockStyle,"pseudo","dark",e)&&delete this.blockStyle.pseudo.dark[e]},resetStyleSection(){delete this.blockStyle.value,delete this.blockStyle.darkValue,delete this.blockStyle.pseudo,this.$refs.styleoptions.close()}},template:'\n  \n    <div class="uip-flex uip-flex-column uip-row-gap-s">\n    \n      \x3c!-- Title --\x3e\n      <div class="uip-flex uip-gap-s uip-flex-center uip-flex-between" @contextmenu.prevent.stop="$refs.styleoptions.show($event)">\n        \n       \n        <div class="uip-flex uip-gap-xxs uip-flex-center uip-cursor-pointer uip-flex-between"\n        :class="{\'uip-flex-grow\' : !open}"\n        @click="toggleVisibility()">\n          \n          \n          <span class="uip-text-bold uip-text-emphasis">{{ title }}</span> \n          \n          <a class="uip-link-muted uip-icon">{{ returnVisibilityIcon }}</a>\n          \n          \n        </div>\n        \n        \n        <div @click.prevent.stop="$refs.blockstates.show($event)" \n        class="uip-flex uip-gap-xs uip-fade-in" v-if="open">\n        \n          <span @click.prevent.stop="toggleColorMode" :title="strings.toggleColour"\n          class="uip-link-default hover:uip-background-muted uip-border-rounder uip-icon uip-padding-xxs uip-padding-top-xxxs uip-padding-bottom-xxxs">\n            {{returnThemeIcon}}\n          </span>\n        \n          <div @click.prevent.stop="$refs.blockstates.show($event)" \n          class="uip-text-xs uip-padding-xxxs uip-padding-left-xs uip-padding-right-xxs uip-border-rounder uip-background-muted uip-link-default uip-flex uip-gap-xxs uip-flex-center">\n            <span>{{returnActiveState}}</span>\n            <a class="uip-link-muted uip-icon">expand_more</a>\n          </div>\n        \n        </div>\n      \n      </div>\n      \n      <div v-if="open" class="uip-padding-left-s">\n        <component :is="component" :value="returnCurrentBlockStyle" @update="handleStyleUpdate"/>\n      </div>\n      \n      \n      <contextmenu ref="blockstates">\n      \n        <div class="uip-padding-xs uip-flex uip-flex-column uip-text-weight-normal uip-text-s">\n        \n          <template v-for="item in pseudoSelectors">\n          \n            <a @click="activeState = item.value; $refs.blockstates.close()"\n            :class="activeState == item.value ? \'uip-background-muted uip-text-emphasis\' : \'hover:uip-background-muted\'"\n            class="uip-link-default uip-padding-xxs uip-border-rounder uip-no-wrap uip-flex uip-flex-center uip-flex-between uip-gap-s">\n              \n              \n              <span>{{ item.label }}</span>\n              \n              \n              <a v-if="itemHasPseudo(item.value)" \n              @click.prevent.stop="clearPseudo(item.value)" class="uip-link-muted uip-icon uip-link-muted">close</a>\n            \n            </a>\n            \n          </template>\n        \n        </div>\n      \n      </contextmenu>\n      \n      \n      <contextmenu ref="styleoptions">\n      \n        <div class="uip-padding-xs uip-flex uip-flex-column uip-text-weight-normal uip-text-s">\n        \n          <a @click="resetStyleSection"\n          class="hover:uip-background-muted uip-link-danger uip-padding-xxs uip-border-rounder uip-no-wrap uip-flex uip-flex-center uip-flex-between uip-gap-s">\n          \n            <span>{{ strings.resetSection }}</span>\n            \n            <span class="uip-icon">restart_alt</span>\n          \n          </a>\n        \n        </div>\n      \n      </contextmenu>\n    \n    </div>\n  \n  '};export default{inject:["uiTemplate"],components:{QueryBuilder:defineAsyncComponent(()=>import("../options/query-builder.min.js?ver=3.3.1")),Interactions:defineAsyncComponent(()=>import("../options/interactions.min.js?ver=3.3.1")),responsiveControls:defineAsyncComponent(()=>import("../options/responsive.min.js?ver=3.3.1")),Classes:defineAsyncComponent(()=>import("../options/classes.min.js?ver=3.3.1")),Conditions:defineAsyncComponent(()=>import("../options/conditions.min.js?ver=3.3.1")),BlockStyleHandler:BlockStyleHandler,BlockParts:BlockParts,StylePresets:StylePresets,ToggleSection:ToggleSection},data(){return{block:{},uid:this.$route.params.uid,section:"settings",loading:!0,activeTab:!1,showSettings:!1,activePart:"root",strings:{blockID:__("ID","uipress-lite"),proOption:__("This is a pro option. Upgrade to unlock","uipress-lite"),options:__("Options","uipress-lite"),hiddenOnDevice:__("Hidden on device","uipress-lite"),tooltip:__("Tooltip","uipress-lite"),tooltipMessage:__("Message","uipress-lite"),styles:__("Styles","uipress-lite"),queryLoop:__("Query loop","uipress-lite"),query:__("Query","uipress-lite"),none:__("None","uipress-lite"),name:__("Name","uipress-lite"),link:__("Link","uipress-lite"),general:__("General","uipress-lite"),layout:__("Layout","uipress-lite"),size:__("Size","uipress-lite"),style:__("Style","uipress-lite"),spacing:__("Spacing","uipress-lite"),text:__("Text","uipress-lite"),position:__("Position","uipress-lite"),effects:__("Effects","uipress-lite"),general:__("General","uipress-lite"),code:__("Code","uipress-lite"),classes:__("Classes","uipress-lite"),conditions:__("Conditions","uipress-lite"),content:__("Content","uipress-lite"),interactions:__("Interactions","uipress-lite")},optionsSections:{settings:{value:"settings",label:__("Settings","uipress-lite")},style:{value:"style",label:__("Style","uipress-lite")},advanced:{value:"advanced",label:__("Advanced","uipress-lite")}}}},created(){this.uipApp.blockSettings=this},computed:{maybeShowInteractionPanel(){return!!this.block.interactions&&this.block.interactions.length},returnBlockRealName(){const e=this.block.moduleName,t=this.uipApp.data.blocks.find(t=>t.moduleName===e);return t?t.name:this.block.name},returnBlockQuerySettings(){return this.block.query||(this.block.query={settings:{}}),this.block.query.settings},returnBlockOptions(){const e=this.block.moduleName,t=this.uipApp.data.blocks,n=t.findIndex(t=>t.moduleName===e);if(n<0)return[];const i=t[n].optionsEnabled,s=i.findIndex(e=>"block"===e.name);return s<0?[]:i[s].options}},methods:{async show(e,t){this.block=e,this.activePart="root",await nextTick(),this.showSettings=!0,this.loading=!1,t&&(this.section=t)},close(){this.showSettings=!1,this.block=null},componentExists(e){return!!this.$root._.appContext.components[e]},optionFullWidth(e){return this.hasNestedPath(e,"args","fullWidth")},handleActiveTabChange(e){this.section=e;const t={query:{...this.$route.query,section:this.section}};this.$router.push(t)},returnBlockStylePart(e){const t="root"==this.activePart?"style":this.activePart,n=this.hasNestedPath(this.block,"settings",t,"preset"),i=this.uipApp.data.options.block_preset_styles;if(n&&this.isObject(i)&&n in i){const t=i[n];return this.ensureNestedObject(t,"preset","options",e),t.preset.options[e]}return this.ensureNestedObject(this.block,"settings",t,"options",e),this.block.settings[t].options[e]},isAvailable(e){return!e.requiresUpgrade||!!this.uiTemplate.proActivated},returnBlockSettingValue(e){const t=this.hasNestedPath(this.block,"settings","block","options");if(!t)return;const n=e.uniqueKey?e.uniqueKey:e.option;return n in t?t[n].value:void 0},handleBlockSettingUpdate(e,t){const n=e.uniqueKey?e.uniqueKey:e.option;this.ensureNestedObject(this.block,"settings","block","options",n),this.block.settings.block.options[n].value=t},returnAdvancedValue(e){const t=this.hasNestedPath(this.block,"settings","advanced","options");if(t&&e in t)return t[e].value},handleBlockAdavancedUpdate(e,t){this.ensureNestedObject(this.block,"settings","advanced","options",e),this.block.settings.advanced.options[e].value=t},returnBlockPseudo(e){const t="root"==this.activePart?"style":this.activePart,n=this.hasNestedPath(this.block,"settings",t,e);return n||""},handleBlockPseudoChange(e,t){const n="root"==this.activePart?"style":this.activePart;this.ensureNestedObject(this.block,"settings",n,t),this.block.settings[n][t]=e}},template:'\n    \n    \n    \n    <div v-if="showSettings" id="uip-block-settings"\n    class="uip-position-fixed uip-top-80 uip-right-16 uip-bottom-16 uip-background-default uip-w-320 uip-flex uip-flex-column uip-row-gap-s uip-fade-in uip-shadow" style="border-radius: calc(var(--uip-border-radius-large) + var(--uip-padding-xs)); z-index: 2;overflow:auto">\n    \n        \n        <div class="uip-flex uip-flex-column uip-gap-s uip-padding-s">\n          \n          \x3c!-- Block settings header --\x3e\n          <div class="uip-flex uip-flex-between uip-flex-center">\n          \n            <div class="uip-flex uip-flex-column">\n              <div class="uip-text-bold uip-blank-input uip-text-l uip-text-emphasis">{{ returnBlockRealName }}</div>\n            </div>\n            \n            <a class="uip-link-muted hover:uip-background-muted uip-border-rounder uip-icon uip-padding-xxs" @click="close()">close</a>\n            \n          </div>\n          \x3c!-- End block settings header --\x3e\n          \n          \n          \x3c!-- Toggle active tab --\x3e\n          <toggle-switch :options="optionsSections" :activeValue="section" :returnValue="handleActiveTabChange" class="uip-margin-bottom-xxs"/>\n          \n          \n          \x3c!-- Settings Tab --\x3e\n          <div v-if="section == \'settings\'" class="uip-flex uip-flex-column uip-gap-s">\n          \n            \x3c!-- General settings --\x3e\n            <ToggleSection :title="strings.general" :startOpen="true">\n              <div class="uip-grid-col-1-3">\n              \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>{{strings.name}}</span></div>\n                  <input class="uip-input uip-input-small" type="text" v-model="block.name">\n                \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>{{strings.blockID}}</span></div>\n                  <div class="uip-flex uip-flex-center uip-background-muted uip-border-rounder uip-padding-xxxs uip-padding-left-xs uip-padding-right-xxs uip-overflow-hidden">\n                  \n                    <div class="uip-blank-input uip-text-s uip-flex-grow uip-overflow-hidden uip-text-ellipsis uip-no-wrap">{{block.uid}}</div>\n                    <span class="uip-icon uip-link-muted" @click="copyToClipboard(block.uid)">content_copy</span>\n                    \n                  </div>\n                  \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s uip-max-h-30"><span>{{strings.link}}</span></div>\n                  <link-select :value="block.linkTo" :returnData="(d)=>{block.linkTo = d}"/>\n                  \n                  \x3c!--Tooltip text --\x3e\n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>{{strings.tooltip}}</span></div>\n                  <input type="text" v-model="block.tooltip.message" class="uip-input uip-input-small">\n                                      \n              </div>\n            </ToggleSection>\n            \x3c!-- End general settings --\x3e\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Query loop  --\x3e\n            <ToggleSection :title="strings.queryLoop">\n            \n              <QueryBuilder v-if="uiTemplate.proActivated" :block="block" :value="returnBlockQuerySettings"/>\n              \n              <div class="uip-grid-col-1-3" v-else>\n                <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>{{ strings.queryLoop }}</span></div>\n                <div class="uip-padding-xxs uip-border-rounder uip-background-green-wash uip-text-s">{{strings.proOption}}</div>\n              </div>\n              \n            </ToggleSection>\n            \x3c!-- End query --\x3e\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Interactions  --\x3e\n            <ToggleSection :title="strings.interactions" :startOpen="maybeShowInteractionPanel">\n            \n              <Interactions v-if="uiTemplate.proActivated" :block="block"/>\n              \n              <div class="uip-grid-col-1-3" v-else>\n                <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>{{ strings.queryLoop }}</span></div>\n                <div class="uip-padding-xxs uip-border-rounder uip-background-green-wash uip-text-s">{{strings.proOption}}</div>\n              </div>\n              \n            </ToggleSection>\n            \x3c!-- End query --\x3e\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Responsive  --\x3e\n            <ToggleSection :title="strings.hiddenOnDevice">\n            \n                  <responsiveControls :value="block.responsive" :returnData="(e)=>{block.responsive = e}"/>\n              \n            </ToggleSection>\n            \x3c!-- End Responsive --\x3e\n            \n            <div class="uip-border-top" v-if="returnBlockOptions.length"></div>\n            \n            \x3c!-- Block options  --\x3e\n            <ToggleSection :title="strings.options" :startOpen="true" v-if="returnBlockOptions.length">\n                  \n                  <div class="uip-flex uip-flex-column uip-row-gap-xs">\n                  \n                    <template v-for="option in returnBlockOptions">\n                      \n                      <div :class="optionFullWidth(option) ? \'uip-flex uip-flex-column uip-row-gap-xxs\' : \'uip-grid-col-1-3\'">\n                      \n                        <div v-if="!optionFullWidth(option)" class="uip-text-muted uip-flex uip-flex-center uip-text-s uip-h-30 uip-gap-xs uip-position-relative">\n                          \n                          <dropdown pos="left center" :openOnHover="true" \n                          :snapX="[\'#uip-block-settings\']" :hover="true">\n                            <template class="uip-flex-no-shrink" v-slot:trigger>\n                              <span :class="option.help ? \'uip-text-underline\' : \'\'">{{option.label}}</span>\n                            </template>\n                            <template v-if="option.help" v-slot:content>\n                              <div class="uip-text-s uip-padding-xs uip-max-w-200">{{option.help}}</div>\n                            </template>\n                          </dropdown>\n                          \n                        </div>\n                          \n                        <div class="uip-flex uip-flex-center uip-w-100p">\n                        \n                          <component v-if="componentExists(option.componentName) && isAvailable(option)" \n                          :is="option.componentName"\n                          v-bind="option"\n                          :value="returnBlockSettingValue(option)"\n                          :returnData="(data)=>handleBlockSettingUpdate(option, data)"/>\n                          \n                          <div v-else class="uip-padding-xxs uip-border-rounder uip-background-green-wash uip-text-s">\n                             {{strings.proOption}}\n                          </div>\n                        </div>\n                        \n                      </div>\n                      \n                    </template>\n                    \n                  </div>\n              \n            </ToggleSection>\n            \x3c!-- End block options --\x3e\n            \n          \n          </div>\n          \x3c!-- End setting tab --\x3e\n          \n          \n          \x3c!-- Advanced Tab --\x3e\n          <div v-if="section == \'advanced\'" class="uip-flex uip-flex-column uip-gap-s">\n          \n            \x3c!-- Classes  --\x3e\n            <ToggleSection :title="strings.classes" :startOpen="true">\n              <div class="uip-grid-col-1-3">\n              \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s uip-padding-top-xxs uip-flex-start"><span>{{strings.classes}}</span></div>\n                  <Classes :value="returnAdvancedValue(\'classes\')" :returnData="(d)=>{handleBlockAdavancedUpdate(\'classes\', d)}"/>\n                                      \n              </div>\n            </ToggleSection>\n\n\n            \x3c!-- Conditions  --\x3e\n            <ToggleSection :title="strings.conditions" :startOpen="true">\n              <div class="uip-grid-col-1-3">\n              \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s uip-padding-top-xxs uip-flex-start"><span>{{strings.conditions}}</span></div>\n                  <Conditions :value="returnAdvancedValue(\'conditions\')" :returnData="(d)=>{handleBlockAdavancedUpdate(\'conditions\', d)}"/>\n                                      \n              </div>\n            </ToggleSection>\n                      \n            \x3c!-- Code  --\x3e\n            <ToggleSection :title="strings.code" :startOpen="true">\n              <div class="uip-grid-col-1-3">\n              \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>css</span></div>\n                  <code-editor :args="{language:\'css\'}" :value="returnAdvancedValue(\'css\')" :returnData="(d)=>{handleBlockAdavancedUpdate(\'css\', d)}"/>\n                \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>Javscript</span></div>\n                  <code-editor :args="{language:\'javascript\'}" :value="returnAdvancedValue(\'js\')" :returnData="(d)=>{handleBlockAdavancedUpdate(\'js\', d)}"/>\n                                      \n              </div>\n            </ToggleSection>\n            \n          \n          </div>\n          \x3c!-- Advanced tab--\x3e\n          \n          \n          \x3c!-- Styles tab --\x3e\n          <div v-if="section == \'style\'" class="uip-flex uip-flex-column uip-gap-s">\n          \n            <BlockParts :block="block" :activePart="activePart" @update="(d)=>{activePart=d}"/>\n            \n            \x3c!-- Presets --\x3e\n            <StylePresets :activePart="activePart" :block="block"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Layout --\x3e\n            <BlockStyleHandler \n            :startOpen="!!block.content"\n            :styleSettings="returnBlockStylePart(\'flexLayout\')" component="flexLayout" \n            styleName="flexLayout"\n            :title="strings.layout"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Dimensions --\x3e\n            <BlockStyleHandler \n            :startOpen="true"\n            styleName="dimensions"\n            :styleSettings="returnBlockStylePart(\'dimensions\')" component="Dimensions" \n            :title="strings.size"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Styles --\x3e\n            <BlockStyleHandler \n            :startOpen="true"\n            styleName="styles"\n            :styleSettings="returnBlockStylePart(\'styles\')" component="Styles" \n            :title="strings.style"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Spacing --\x3e\n            <BlockStyleHandler \n            :startOpen="true"\n            styleName="spacing"\n            :styleSettings="returnBlockStylePart(\'spacing\')" component="Spacing" \n            :title="strings.spacing"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Text --\x3e\n            <BlockStyleHandler \n            styleName="textFormat"\n            :styleSettings="returnBlockStylePart(\'textFormat\')" component="TextFormat" \n            :title="strings.text"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Before / after  --\x3e\n            <ToggleSection :title="strings.content">\n              <div class="uip-grid-col-1-3">\n              \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>::before</span></div>\n                  <uip-input :value="returnBlockPseudo(\'beforeContent\')" :returnData="(data) => { handleBlockPseudoChange(data,\'beforeContent\') }"/>\n                \n                  <div class="uip-text-muted uip-flex uip-flex-center uip-text-s"><span>::after</span></div>\n                  <uip-input :value="returnBlockPseudo(\'afterContent\')" :returnData="(data) => handleBlockPseudoChange(data,\'afterContent\')"/>\n                                      \n              </div>\n            </ToggleSection>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Position --\x3e\n            <BlockStyleHandler \n            styleName="positionDesigner"\n            :styleSettings="returnBlockStylePart(\'positionDesigner\')" component="PositionDesigner" \n            :title="strings.position"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \x3c!-- Effects --\x3e\n            <BlockStyleHandler \n            styleName="effectsDesigner"\n            :styleSettings="returnBlockStylePart(\'effectsDesigner\')" component="EffectsDesigner" \n            :title="strings.effects"/>\n            \n            <div class="uip-border-top"></div>\n            \n            \n            \n          </div>  \n        \n        \n        </div>\n        \n        \n    </div>\n        \n        '};