import{defineAsyncComponent}from"../../../libs/vue-esm.js";export default{components:{colorSelect:defineAsyncComponent(()=>import("../libs/colorpicker.js")),styleManager:defineAsyncComponent(()=>import("./style-manager.min.js"))},props:{value:String,returnData:Function,args:Object},data(){return{color:this.value,opacity:100,dragging:!1,dontProcessVars:!1}},watch:{opacity:{handler(t,e){t||(this.opacity=0),t>100&&(this.opacity=100),t<0&&(this.opacity=0),this.updateOpacity()},deep:!0},value:{handler(){this.color=this.value}}},computed:{hasStyleManager(){return!this.args||(!this.isObject(this.args)||(!("hasStyleManager"in this.args)||this.args.hasStyleManager))},returnColor(){return this.color?this.color.includes("gradient")?"#b500ff":this.color.includes("--")?this.colorFromVar:this.color:"#b500ff"},colorFromVar(){if(this.dontProcessVars)return this.color;const t=this.uipApp.data.themeStyles,e=this.color.trim();if(e in t){const r=this.returnActiveMode,o=t[e][r];if(o)return o}const r=getComputedStyle(document.documentElement).getPropertyValue(e).trim();return r||"#b500ff"},returnActiveMode(){return this.uipApp.data.userPrefs.darkTheme?this.uipApp.data.userPrefs.darkTheme?"darkValue":void 0:"value"},hasEyeDropper:()=>!!window.EyeDropper},methods:{preventOverDrag(t){this.dragging=!0},allowColorReturn(t){this.dragging=!1,this.returnData(this.color)},setBackgroundColor(t){this.color=t.cssColor,this.setOpacity()},setOpacity(){if(!this.$refs.colorpicker)return"100";let t=this.$refs.colorpicker.querySelector("#color-picker-alpha-slider");if(t){let e=t.value;this.opacity=e}},updateOpacity(){if(!this.$refs.colorpicker)return;if(!this.opacity)return;let t=this.$refs.colorpicker.querySelector("#color-picker-alpha-slider");t&&(t.value=this.opacity,t.dispatchEvent(new Event("input",{bubbles:!0})))},startColorPicker(){(new EyeDropper).open().then(t=>{this.color=t.sRGBHex})},processScreen(t){this.$emit("request-screen",t)},setColorFromVar(t){this.color=t.value,this.returnData(t.name)}},template:'\n  \n\t  <div class="" ref="colorpicker">\n\t\n\t\t\x3c!--Catches overdrag and prevents dropdowns from closing--\x3e\n\t\t<div v-if="dragging" @click.stop.prevent="dragging = false" @mouseup.stop.prevent="dragging = false" style="position:fixed;left:0;right:0;top:0;bottom:0"></div>\n\t\t\n\t\t<colorSelect\n\t\t:color="returnColor"\n\t\tdefault-format="hex" \n\t\t@mouseup="allowColorReturn"\n\t\t@mousedown="preventOverDrag"\n\t\t@click="dragging=false"\n\t\t@color-change="setBackgroundColor"/>\n\t\t\n\t\t<div class="uip-flex uip-gap-xs">\n\t\t  <input @input="returnData(color)" class="uip-input uip-flex-grow" type="text" @focus="dontProcessVars = true" @blur="dontProcessVars = false" v-model="color" placeholder="#4776cd">\n\t  \n\t\t  <div class="uip-flex uip-flex-center uip-background-muted uip-border-rounder uip-padding-xxs">\n\t\t\t  <input class="uip-text-s uip-blank-input uip-w-30 uip-remove-steps" \n\t\t\t  type="number" min="0" max="100" step="1" v-model="opacity">\n\t\t\t  <span class="uip-text-s">%</span>\n\t\t  </div>\n\t\t  \n\t\t  \n\t\t  <button v-if="hasEyeDropper" @click="startColorPicker" class="uip-button-default uip-flex uip-flex-center uip-padding-xxs">\n\t\t\t<span class="uip-icon">colorize</span>\n\t\t  </button>\n\t\t  \n\t\t</div>\n\t\t\n\t\t\x3c!--Styles--\x3e\n\t\t<div v-if="hasStyleManager" class="uip-border-top uip-margin-top-s uip-margin-bottom-s"></div>\n\t\t\n\t\t<styleManager v-if="hasStyleManager" :currentColor="color" :actualValue="value" @request-screen="(d) => {processScreen(d)}" @go-back="$emit(\'go-back\')" :returnData="setColorFromVar"/>\n\t\n\t\t\n\t  </div>\n\t\t'};