<?php
/**
 * Twenty Twenty-Two functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_Two
 * @since Twenty Twenty-Two 1.0
 */


if ( ! function_exists( 'twentytwentytwo_support' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since Twenty Twenty-Two 1.0
	 *
	 * @return void
	 */
	function twentytwentytwo_support() {

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style.css' );
	}

endif;

add_action( 'after_setup_theme', 'twentytwentytwo_support' );

if ( ! function_exists( 'twentytwentytwo_styles' ) ) :

	/**
	 * Enqueue styles.
	 *
	 * @since Twenty Twenty-Two 1.0
	 *
	 * @return void
	 */
	function twentytwentytwo_styles() {
		// Register theme stylesheet.
		$theme_version = wp_get_theme()->get( 'Version' );

		$version_string = is_string( $theme_version ) ? $theme_version : false;
		wp_register_style(
			'twentytwentytwo-style',
			get_template_directory_uri() . '/style.css',
			array(),
			$version_string
		);

		// Enqueue theme stylesheet.
		wp_enqueue_style( 'twentytwentytwo-style' );
	}

endif;

add_action( 'wp_enqueue_scripts', 'twentytwentytwo_styles' );

// Add block patterns
require get_template_directory() . '/inc/block-patterns.php';



/////////////
 







/////////////////////////////////////

add_filter( 'woocommerce_checkout_fields' , 'customize_checkout_fields' );

function customize_checkout_fields( $fields ) {
    $only_virtual = true;
    foreach( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
        // Verifica se h produtos no virtuais
        if ( ! $cart_item['data']->is_virtual() ) $only_virtual = false;
    }

    if( $only_virtual ) {
        unset($fields['billing']['billing_company']);
        unset($fields['billing']['billing_address_1']);
        unset($fields['billing']['billing_address_2']);
        unset($fields['billing']['billing_city']);
        unset($fields['billing']['billing_postcode']);
        unset($fields['billing']['billing_country']);
        unset($fields['billing']['billing_state']);
        unset($fields['billing']['billing_phone']);
        // Desativa o campo de notas do pedido
        add_filter( 'woocommerce_enable_order_notes_field', '__return_false' );
    }
    return $fields;
}



add_action('woocommerce_product_query', 'filtrar_produtos_por_categoria');
function filtrar_produtos_por_categoria($query) {
    if (!empty($_GET['categoria_produto'])) {
        $categoria = sanitize_text_field($_GET['categoria_produto']);
        $tax_query = (array) $query->get('tax_query');

        $tax_query[] = array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => $categoria,
                'operator' => 'IN',
        );

        $query->set('tax_query', $tax_query);
    }
}

















add_action( 'template_redirect', 'redirecionar_apos_finalizar_pedido' );

function redirecionar_apos_finalizar_pedido() {
    // Verificar se estamos na pgina de finalizao de pedido do WooCommerce
    if ( ! is_wc_endpoint_url( 'order-received' ) ) {
        return;
    }

    // Verificar se o parmetro "wcf-order" est presente na URL
    if ( isset( $_GET['wcf-order'] ) ) {
        // Obter o ID do pedido a partir do parmetro "wcf-order"
        $order_id = sanitize_text_field( $_GET['wcf-order'] );

        // Verificar se o pedido est pago
        $order = wc_get_order( $order_id );
        if ( $order && $order->is_paid() ) {
            // Construir a URL de redirecionamento com o ID do pedido
            $url_redirecionamento = home_url( '/impressao/?impressao=' . $order_id );

            // Redirecionar para a URL de redirecionamento
            wp_redirect( $url_redirecionamento );
            exit;
        }
    }
}



 




 















add_action('wp_footer', 'custom_delete_cart_script');
function custom_delete_cart_script() {
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var deleteOrdersBtn = document.getElementById('limpar');
            if (deleteOrdersBtn) {
                deleteOrdersBtn.addEventListener('click', function(event) {
                    event.preventDefault(); // Previne o comportamento padro do link
                    var data = {
                        'action': 'custom_delete_cart'
                    };
                    // Envia uma solicitao AJAX para limpar o carrinho
                    jQuery.post('<?php echo admin_url('admin-ajax.php'); ?>', data, function(response) {
                        // Redireciona para a pgina inicial aps limpar o carrinho
                        window.location.href = '<?php echo home_url(); ?>';
                    });
                });
            }
        });
    </script>
    <?php
}

// Manipulador de AJAX para limpar o carrinho
add_action('wp_ajax_custom_delete_cart', 'custom_delete_cart');
add_action('wp_ajax_nopriv_custom_delete_cart', 'custom_delete_cart');
function custom_delete_cart() {
    WC()->cart->empty_cart();
    die();
}





// Defina uma funo para lidar com a verificao e redirecionamento
function verificar_pedido_e_redirecionar() {
    // Obtm o ID do pedido da URL
    $order_id = isset($_GET['wcf-order']) ? intval($_GET['wcf-order']) : 0;

    // Verifica se o ID do pedido  vlido
    if ($order_id > 0) {
        // Obtm o status do pedido
        $order = wc_get_order($order_id);
        $order_status = $order->get_status();

        // Se o status do pedido for 'completed', redireciona para a pgina de impresso
        if ($order_status === 'completed') {
            $url_redirecionamento = home_url('/impressao/?impressao=' . $order_id);
            wp_redirect($url_redirecionamento);
            exit;
        }
    }
}

// Engatilhe a funo acima no gancho 'template_redirect'
add_action('template_redirect', 'verificar_pedido_e_redirecionar');




function custom_logout() {
    wp_logout();
    wp_safe_redirect(home_url());
    exit();
}
add_action('wp_ajax_custom_logout', 'custom_logout');
add_action('wp_ajax_nopriv_custom_logout', 'custom_logout'); // For logged-out users.









function redirecionar_admin_para_produtos( $redirect_to, $request, $user ) {
    // Verifica se o usurio est logando e  um administrador
    if ( isset( $user->roles ) && is_array( $user->roles ) ) {
        if ( in_array( 'administrator', $user->roles ) ) {
            // Define o URL de redirecionamento para a pgina de produtos do WooCommerce
            return admin_url( 'edit.php?post_type=product' );
        } else {
            // Para outros papis, mantm o redirecionamento padro
            return $redirect_to;
        }
    } else {
        return $redirect_to;
    }
}
add_filter( 'login_redirect', 'redirecionar_admin_para_produtos', 10, 3 );










function set_editar_title_for_frete($data, $postarr) {
    if ($data['post_type'] == 'frete') {
        $data['post_title'] = 'Editar';  // Define o ttulo como 'Editar'
    }
    return $data;
}
add_filter('wp_insert_post_data', 'set_editar_title_for_frete', 99, 2);

function hide_title_field_for_frete() {
    global $post_type;
    if ('frete' === $post_type) {
        echo '<style>
                #titlewrap {
                    display: none;
                }
              </style>';
    }
}
add_action('admin_head', 'hide_title_field_for_frete');










function my_acf_repeater_footer_script() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {

        function calculateTotalAndVolume() {
            var grandTotal = 0;
            var totalVolume = 0; // Para armazenar a soma das quantidades

            // Iterar sobre cada linha do repetidor
            $('.acf-field[data-name="itensproduto"] .acf-row:not(.acf-clone)').each(function() {
                var quantidade = parseFloat($(this).find('.acf-field[data-name="quantidade"] input').val()) || 0;
                var preco = parseFloat($(this).find('.acf-field[data-name="precoitem"] input').val()) || 0;
                var total = quantidade * preco;

                // Adicionar ao total geral e ao volume total
                grandTotal += total;
                totalVolume += quantidade; // Adicionar a quantidade ao total de volume

                // Atualizar o campo total de cada item
                $(this).find('.acf-field[data-name="total"] input').val(total.toFixed(2).replace('.', ','));
            });

            // Atualizar o total geral
            var formattedTotal = grandTotal.toFixed(2).replace('.', ',');
            $('.acf-field[data-name="valor_total"] input').val(formattedTotal);
            $('#display_valor_total').html('<h1 style="text-align: center; margin: 30px;">Total do Frete: R$ ' + formattedTotal + '</h1>');

            // Atualizar a exibio do total de volume e o campo escondido
            $('#display_valor_total').append('<h2 style="text-align: center;">Quantidade de Volume: ' + totalVolume + '</h2>');
            $('.acf-field[data-name="quantidade_de_volume"] input').val(totalVolume);
        }

        if($('#display_valor_total').length === 0) {
            $('.acf-field[data-name="valor_total"]').after('<div id="display_valor_total"></div>');
        }

        $('.acf-field[data-name="itensproduto"]').on('keyup change', 'input', calculateTotalAndVolume);
        acf.add_action('remove_row', calculateTotalAndVolume);
        acf.add_action('add_row', calculateTotalAndVolume);

        calculateTotalAndVolume(); // Calcula o total e o volume inicial na carga da pgina

        // Ocultar os campos que no devem ser exibidos
        $('.acf-field[data-name="valor_total"]').css('display', 'none');
        $('.acf-field[data-name="quantidade_de_volume"]').css('display', 'none');

    });
    </script>
    <?php
}
add_action('acf/input/admin_footer', 'my_acf_repeater_footer_script');


















function customizar_formato_acf_resultados($title, $post, $field, $post_id) {
    // Obter o valor do campo personalizado 'preco' para este post
    $preco = get_field('preco', $post->ID);
    if ($preco) {
        // Formatando o valor como moeda em reais
        $valorFormatado = 'R$ ' . number_format($preco, 2, ',', '.');
        // Se existe 'preco', adicionar ao ttulo com o valor formatado
        $title .= ' - ' . $valorFormatado;
    }
    return $title;
}

// Este filtro ir afetar todos os campos do tipo post_object. Se necessrio, ajuste para torn-lo mais especfico.
add_filter('acf/fields/post_object/result', 'customizar_formato_acf_resultados', 10, 4);













function enqueue_custom_admin_js() {
    wp_enqueue_script('custom-admin-js', '', [], '', true);
    wp_localize_script('custom-admin-js', 'adminAjax', [
        'url' => admin_url('admin-ajax.php')
    ]);
}
add_action('admin_enqueue_scripts', 'enqueue_custom_admin_js');

function my_custom_admin_ajax() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        $(document).on('keyup', '#my-search-field', function() {
            $.ajax({
                url: adminAjax.url,
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'search_posts_by_title',
                    search: $(this).val(),
                },
                success: function(response) {
                    if (response.success) {
                        $('select[name="acf[buscar_item]"]').empty();
                        response.data.forEach(function(item) {
                            $('select[name="acf[buscar_item]"]').append($('<option></option>').attr('value', item.id).text(item.title));
                        });
                    }
                }
            });
        });
    });
    </script>
    <?php
}
add_action('acf/input/admin_head', 'my_custom_admin_ajax');

function search_posts_by_title() {
    $search = sanitize_text_field($_POST['search']);
    $response = [];

    $args = [
        'post_type' => 'cadastro_de_item_fre',
        's'         => $search,
        'posts_per_page' => -1,
    ];

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $response[] = [
                'id' => get_the_ID(),
                'title' => get_the_title(),
                // Removido a busca por campos personalizados para simplificar
            ];
        }
    }

    wp_send_json_success($response);
}

add_action('wp_ajax_search_posts_by_title', 'search_posts_by_title');
add_action('wp_ajax_nopriv_search_posts_by_title', 'search_posts_by_title'); // Remova esta linha se o AJAX for somente para usurios logados

// Adicionando o campo de busca acima do select
function add_custom_search_field() {
    echo '<input type="text" id="my-search-field" placeholder="Digite para buscar...">';
}

add_action('acf/render_field/name=buscar_item', 'add_custom_search_field', 9); // Prioridade 9 para garantir que aparea antes do campo.







function adicionar_scripts_admin_custom() {
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            // Substitua 'seu_campo_post_object' pelo seletor do campo Post Object especfico
            $(document).on('change', '[data-name="Item"] select', function() {
                // Extrair informaes do valor selecionado
                var selectedText = $(this).find('option:selected').text();
                var info = selectedText.split(' - ');

                // Supondo que 'info[0]' seja o ttulo e 'info[1]' seja o preo
                var titulo = info[0];
                var preco = info[1] ? info[1].replace('R$ ', '') : '';

                // Atualizar outros campos
                // Voc precisar ajustar os seletores abaixo com base nos nomes dos campos reais
                var $parentRepeater = $(this).closest('.acf-row');
                
                // Atualiza o campo 'titulo_item'
                $parentRepeater.find('[data-name="titulo_item"] input').val(titulo);
                // Atualiza o campo 'precoitem'
                $parentRepeater.find('[data-name="precoitem"] input').val(preco);
                // Limpa o campo 'quantidade'
                $parentRepeater.find('[data-name="quantidade"] input').val('');
                $parentRepeater.find('[data-name="total"] input').val('');
                $parentRepeater.find('[data-name="valor_total"] input').val(''); 


            });
        });
    </script>
    <?php
}
add_action('acf/input/admin_footer', 'adicionar_scripts_admin_custom');








 


















 






function my_acf_calculate_valor_total_haver() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {

        function calculateTotalHaver() {
            var grandTotalHaver = 0;
            // Iterar sobre cada linha do repetidor dentro do grupo 'pagamento_haver'
            $('.acf-field[data-name="pagamento_haver"] .acf-field[data-name="lista_haver"] .acf-row:not(.acf-clone)').each(function() {
                var valorHaver = parseFloat($(this).find('.acf-field[data-name="valor_haver"] input').val().replace(',', '.')) || 0;
                // Adicionar ao total geral
                grandTotalHaver += valorHaver;
            });

            // Atualizar o input e o elemento de texto com o valor total
            var formattedTotalHaver = grandTotalHaver.toFixed(2).replace('.', ',');
            // Atualizar o campo valor_total_haver
            $('.acf-field[data-name="valor_total_haver"] input').val(formattedTotalHaver);
            // Opo: atualizar um elemento de exibio, se necessrio
            $('#display_valor_total_haver').html('<h1 style="text-align: center; margin: 30px;">Total a Haver: R$ ' + formattedTotalHaver + '</h1>');
        }

        // Verifica se o elemento de exibio destacada existe, e se no, cria
        if($('#display_valor_total_haver').length === 0) {
            $('.acf-field[data-name="valor_total_haver"]').after('<div id="display_valor_total_haver"></div>');
        }

        // Adiciona eventos para recalcular o total quando os valores de valor_haver so alterados.
        $('.acf-field[data-name="pagamento_haver"]').on('keyup change', '.acf-field[data-name="lista_haver"] input', calculateTotalHaver);

        // Atrelar a funo de reclculo ao evento de remover e adicionar linhas do ACF dentro de 'lista_haver'.
        acf.addAction('remove_row', calculateTotalHaver);
        acf.addAction('add_row', calculateTotalHaver);

        // Calcula o total inicial na carga da pgina
        calculateTotalHaver();

        // Opo: Ocultar o campo valor_total_haver e sua label
        $('.acf-field[data-name="valor_total_haver"]').css('display', 'none');

    });
    </script>
    <?php
}
add_action('acf/input/admin_footer', 'my_acf_calculate_valor_total_haver');





























function enqueue_bootstrap_in_admin() {
    wp_enqueue_style('bootstrap-css', 'https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js', array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'enqueue_bootstrap_in_admin');

function adicionar_custom_script_no_admin() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        acf.add_action('ready append', function() {
            $('.acf-field-repeater[data-name="itensproduto"] .acf-field[data-name="Item"]').each(function() {
                var $campoItem = $(this);
                if ($campoItem.find('.btn-add-item').length === 0) {
                    var botao = '<button type="button" class="btn-add-item btn btn-primary" data-toggle="modal" data-target="#modalAddItem" style="margin-top: 5px;">Adicionar </button>';
                    $campoItem.append(botao);
                }
            });
        });

        var modalHTML = '<div class="modal fade" id="modalAddItem" tabindex="-1" role="dialog" aria-labelledby="modalAddItemLabel" aria-hidden="true">' +
                        '<div class="modal-dialog" role="document">' +
                        '<div class="modal-content">' +
                        '<div class="modal-header">' +
                        '<h5 class="modal-title" id="modalAddItemLabel">Adicionar Novo Item</h5>' +
                        '<button type="button" class="close" data-dismiss="modal" aria-label="Close">' +
                        '<span aria-hidden="true">&times;</span></button></div>' +
                        '<div class="modal-body">' +
                        '<label for="nomeItem">Nome do Item:</label>' +
                        '<input type="text" id="nomeItem" class="form-control" name="nomeItem"><br>' +
                        '<label for="precoItem">Preo:</label>' +
                        '<input type="text" id="precoItem" class="form-control" name="precoItem"><br>' +
                        '</div>' +
                        '<div class="modal-footer">' +
                        '<button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>' +
                        '<button id="salvarItem" class="btn btn-primary">Salvar</button>' +
                        '</div></div></div></div>';
        $('body').append(modalHTML);

        $(document).on('click', '#salvarItem', function() {
            var nomeItem = $('#nomeItem').val().trim();
            var precoItem = $('#precoItem').val().trim();
            if(nomeItem === '' || precoItem === '') {
                alert('Por favor, insira o nome e o preo do item.');
                return;
            }

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    'action': 'adicionar_item_ajax',
                    'nomeItem': nomeItem,
                    'precoItem': precoItem,
                    'security': '<?php echo wp_create_nonce("adicionar_item_seguro"); ?>'
                },
                success: function(response) {
                    alert(response.data.message);
                    if(response.success) {
                        $('#modalAddItem').modal('hide');
                        $('#nomeItem').val('');
                        $('#precoItem').val('');
                    }
                }
            });
        });
    });
    </script>
    <?php
}
add_action('admin_footer', 'adicionar_custom_script_no_admin');

function adicionar_item_ajax() {
    check_ajax_referer('adicionar_item_seguro', 'security');

    $nomeItem = isset($_POST['nomeItem']) ? sanitize_text_field($_POST['nomeItem']) : '';
    $precoItem = isset($_POST['precoItem']) ? sanitize_text_field($_POST['precoItem']) : '';

    $post_id = wp_insert_post(array(
        'post_title'    => $nomeItem,
        'post_type'     => 'cadastro_de_item_fre',
        'post_status'   => 'publish',
    ));

    if ($post_id) {
        update_post_meta($post_id, 'preco', $precoItem); // Adiciona o preo como um campo personalizado

        wp_send_json_success(array('message' => 'Item adicionado com sucesso. ID: ' . $post_id));
    } else {
        wp_send_json_error(array('message' => 'Falha ao adicionar item.'));
    }

    wp_die();
}
add_action('wp_ajax_adicionar_item_ajax', 'adicionar_item_ajax');
























function modificar_texto_botao($translated_text, $text, $domain) {
    if ('Publish' === $text || 'Update' === $text) { // Verifica se o texto  "Publicar" ou "Atualizar"
        $translated_text = 'Registrar'; // Novo texto para o boto
    }
    return $translated_text;
}
add_filter('gettext', 'modificar_texto_botao', 10, 3);










function custom_admin_styles_and_scripts_for_frete() {
    global $post_type;
    // Verifica se o tipo de post  'frete'
    if ('frete' !== $post_type) {
        return;
    }

    // Inclui CSS para ajustar a largura das metaboxes e esconder os containers laterais
    echo '<style>
        #post-body, #poststuff { margin-right: 0 !important; }
        .postbox-container { width: 100% !important; }
        #postbox-container-1 { display: none; }
        .postbox { width: 100% !important; margin-bottom: 40px; }
        #post-status-info { display: none; } // Esconde informaes de status adicionais, se necessrio
    </style>';

    // Inclui JavaScript para mover a caixa de publicao para o final
    echo '<script type="text/javascript">
    jQuery(document).ready(function($) {
        var publishBox = $("#submitdiv");
        var postBody = $("#post-body-content");

        // Verifica se o postBody tem uma altura mnima para evitar que a caixa de publicao sobreponha outros elementos
        if(postBody.height() < 500) {
            postBody.css("min-height", "500px");
        }
        
        // Move a caixa de publicao para o final da rea de contedo
        if (publishBox.length && postBody.length) {
            publishBox.detach().appendTo(postBody);
        }
    });
    </script>';
}
add_action('admin_head', 'custom_admin_styles_and_scripts_for_frete');









function atualizar_titulo_com_cpf_cnpj($post_id, $post, $update) {
    // Verificar se o tipo de post  'cliente_remetente' ou 'cliente_destinatario'
    if ($post->post_type != 'cliente_remetente' && $post->post_type != 'cliente_destinatario') {
        return;
    }

    // Verificar se estamos em uma requisio de autosave, para no executar durante autosaves
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // Acessar o objeto Pods associado ao tipo de post atual
    $pods = pods($post->post_type, $post_id);

    // Obter o CPF/CNPJ do campo personalizado
    $cpf_cnpj = $pods->field('cpf_cnpj');

    if (!empty($cpf_cnpj)) {
        // Novo ttulo combinando ttulo original e CPF/CNPJ
        $novo_titulo = $post->post_title . ' - ' . $cpf_cnpj;

        // Remover temporariamente a ao para evitar loop infinito
        remove_action('save_post', 'atualizar_titulo_com_cpf_cnpj', 10);

        // Atualizar o ttulo do post
        wp_update_post(array(
            'ID' => $post_id,
            'post_title' => $novo_titulo
        ));

        // Reconectar a ao de save_post aps a atualizao
        add_action('save_post', 'atualizar_titulo_com_cpf_cnpj', 10, 3);
    }
}

add_action('save_post', 'atualizar_titulo_com_cpf_cnpj', 10, 3);





















function adicionar_scripts_mascara_cpf_cnpj() {
    ?>



<script>
function mascaraCPFCNPJ(){
    var campos = document.querySelectorAll('.cpf_cnpj'); // Seleciona todos os elementos com a classe 'cpf_cnpj'
    campos.forEach(function(campo) {
        var valor = campo.value.replace(/\D/g, ''); // Remove tudo que no  dgito

        if (valor.length <= 11) { // CPF
            campo.value = valor.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, "$1.$2.$3-$4");
        } else { // CNPJ
            campo.value = valor.replace(/^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})$/, "$1.$2.$3/$4-$5");
        }
    });
}
</script>



 <?php
}
add_action('wp_head', 'adicionar_scripts_mascara_cpf_cnpj');







function redirect_after_save_frete($post_id) {
    // Verifique se  um salvamento automtico ou uma reviso.
    if (wp_is_post_revision($post_id) || defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // Verifique se o tipo do post  `frete`.
    $post_type = get_post_type($post_id);
    if ('frete' !== $post_type) {
        return;
    }

    // Adiciona uma notificao temporria para redirecionar.
    add_filter('redirect_post_location', function($location) {
        // Redireciona para a pgina de novo post do tipo `frete`.
        return admin_url('post-new.php?post_type=frete');
    });
}

// Hook na ao `save_post` para capturar quando um `frete`  salvo.
add_action('save_post', 'redirect_after_save_frete');


















