<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

global $wpdb;

// Sua consulta SQL
$query = "
    SELECT 
        order_items.order_id, 
        order_items.order_item_name, 
        posts.post_excerpt AS product_description,
        postmeta.meta_value AS senha,
        posts.post_date AS order_date
    FROM {$wpdb->prefix}woocommerce_order_items AS order_items
    JOIN {$wpdb->prefix}woocommerce_order_itemmeta AS itemmeta ON order_items.order_item_id = itemmeta.order_item_id
    JOIN {$wpdb->prefix}posts AS posts ON itemmeta.meta_value = posts.ID
    LEFT JOIN {$wpdb->prefix}postmeta AS postmeta ON posts.ID = postmeta.post_id AND postmeta.meta_key = 'senha'
    WHERE order_items.order_item_type = 'line_item'
    AND itemmeta.meta_key = '_product_id'
    AND (posts.post_title LIKE '%Hora de Internet%' OR posts.post_title LIKE '%Horas de Internet%')
    GROUP BY order_items.order_id
    ORDER BY order_items.order_id DESC
    LIMIT 1
";

$results = $wpdb->get_results($query);

$data = [];

// Verifica se obteve algum resultado
if (!empty($results)) {
    foreach ($results as $row) {
        $order_id = $row->order_id; // Aqui voc obtm o $order_id
        $descricaoLimpa = $row->product_description; // Obtm a descrio do produto

        if (preg_match('/\b(\d{2}:\d{2}:\d{2})\b/', $descricaoLimpa, $matches)) {
            $tempo = $matches[1]; // Captura o tempo da descrio limpa
        } else {
            $tempo = ""; // Defina um valor padro se o tempo no for encontrado
        }

        // Get an instance of the WC_Order Object using the specified order ID
        $order = wc_get_order($order_id);

        // Verifica se o pedido existe
        if ($order) {
            // Tenta recuperar o campo 'senha'
            $senha = $order->get_meta('senha'); // Substitua 'senha' pelo nome correto do campo

            // Obtm a data e hora do cadastro do pedido
            $order_date = $order->get_date_created();
            $order_date_formatted = $order_date->format('Y-m-d H:i:s');

            $data[] = [
                'nome' => $senha, // Substitua pelo nome do usurio desejado
                'senha' => $senha, // Usa o campo 'senha'
                'comentario' => $order_date_formatted."/".$tempo, // Insere a data e hora do cadastro do pedido
                'tempo' => $tempo, // Exemplo de tempo
            ];
        }
    }
}

// Formata os dados em um modelo desejado
$formattedData = [];
foreach ($data as $entry) {
    $formattedData[] = 'nome=' . $entry['nome'] . ',senha=' . $entry['senha'] . ',comentario=' . $entry['comentario'] . ',tempo=' . $entry['tempo'];
}

echo implode("\n", $formattedData); // Imprime os dados formatados
?>
