<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Filtro de Pedidos</title>
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
</head>

<body>
<div id="primary" class="content-area">
    <main id="main" class="site-main">
        <a href="<?php echo home_url(); ?>" class="btn btn-success" style="margin-bottom: 20px; margin: 10px; background-color: #000; border-radius: 0; padding: 10px 20px;">VOLTAR</a>  

        <a href="#" class="btn btn-info" style="margin-bottom: 20px; margin: 10px; background-color: ; border-radius: 0; padding: 10px 20px;"  data-toggle="modal" data-target="#myModal">FILTRAR</a>  

        <div class="container">
            <!-- Modal -->
            <div class="modal fade" id="myModal" role="dialog">
                <div class="modal-dialog">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <h4 class="modal-title">Modal Header</h4>
                        </div>
                        <div class="modal-body">
                            <h2>Filtro de Pedidos</h2>
                            <form method="get" action="">
                                <?php if (is_user_logged_in()) : ?>
                                    <?php $current_user = wp_get_current_user(); ?>
                                    <input type="hidden" name="usuario" value="<?php echo $current_user->ID; ?>">
                                <?php endif; ?>

<div class="form-group">
    <label for="categoriaProdutoSelect">Categoria do Produto:</label>
    <select class="form-control" id="categoriaProdutoSelect" name="categoria_produto">
        <option value="">Todas as categorias de produto</option>
        <?php
        $product_categories = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        foreach ($product_categories as $category) {
            // Verifica se a categoria tem produtos associados
            $category_products = get_posts(array(
                'post_type' => 'product',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $category->term_id,
                        'operator' => 'IN',
                    ),
                ),
            ));
            if ($category_products) {
                echo '<option value="' . $category->term_id . '">' . $category->name . '</option>';
            }
        }
        ?>
    </select>
</div>

                                <div class="form-group">
                                    <label for="dataInicial">Data Inicial:</label>
                                    <input type="date" class="form-control" id="dataInicial" name="data_inicial" value="<?php echo date('Y-m-d'); ?>">
                                </div>

                                <div class="form-group">
                                    <label for="dataFinal">Data Final:</label>
                                    <input type="date" class="form-control" id="dataFinal" name="data_final" value="<?php echo date('Y-m-d'); ?>">
                                </div>

                                <button type="submit" class="btn btn-primary">Filtrar</button>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

          <?php
// Verifica se foi enviado um formulrio via GET
if ($_SERVER["REQUEST_METHOD"] == "GET" && (isset($_GET['categoria_produto']) || isset($_GET['data_inicial']) || isset($_GET['data_final']) || isset($_GET['forma_pagamento']))) {
    // Obtendo o ID do cliente atualmente logado
    $usuario_id = get_current_user_id();

    // Obtendo os parmetros do formulrio
    $categoria_produto = isset($_GET['categoria_produto']) ? intval($_GET['categoria_produto']) : '';
    $data_inicial = isset($_GET['data_inicial']) ? $_GET['data_inicial'] : '';
    $data_final = isset($_GET['data_final']) ? $_GET['data_final'] : '';
    $forma_pagamento = isset($_GET['forma_pagamento']) ? sanitize_text_field($_GET['forma_pagamento']) : '';

    // Ajuste de formato de data
    if (!empty($data_inicial)) {
        $data_inicial = date('Y-m-d', strtotime($data_inicial));
    }
    if (!empty($data_final)) {
        $data_final = date('Y-m-d', strtotime($data_final));
    }

    // Arrays para armazenar informaes de vendas por produto e por forma de pagamento
    $vendas_por_produto = array();
    $vendas_por_forma_pagamento = array();

    // Construindo os argumentos para a consulta de pedidos
    $args = array(
        'status' => array('completed', 'processing'), // Pedidos com status "completed" e "processing"
        'limit'  => -1, // Retorna todos os pedidos
        'date_query' => array(),
        'tax_query' => array( 'relation' => 'AND' ), // Inicializa a consulta de taxa (tax query)
    );

    // Aplicando filtros se foram definidos
    if (!empty($usuario_id)) {
        $args['customer'] = $usuario_id;
    }

    // Filtro por categoria de produto
    if (!empty($categoria_produto)) {
        $args['tax_query'][] = array(
            'taxonomy' => 'product_cat',
            'field'    => 'term_id',
            'terms'    => $categoria_produto,
        );
    }

    // Filtro por data inicial e final
    if (!empty($data_inicial) && !empty($data_final)) {
        $args['date_query'][] = array(
            'after'     => $data_inicial,
            'before'    => $data_final,
            'inclusive' => true,
        );
    }

    // Obtendo os pedidos do WooCommerce com base nos argumentos
    $pedidos = wc_get_orders($args);

    // Processamento dos pedidos
    if ($pedidos) {
        foreach ($pedidos as $pedido) {
            $itens = $pedido->get_items();
            foreach ($itens as $item) {
                $produto_id = $item->get_product_id();
                $forma_pagamento_pedido = $pedido->get_payment_method();

                // Filtrando por forma de pagamento, se especificado
                if (!empty($forma_pagamento) && $forma_pagamento_pedido !== $forma_pagamento) {
                    continue;
                }

                // Contagem de vendas por produto
                if (isset($vendas_por_produto[$produto_id])) {
                    $vendas_por_produto[$produto_id]['quantidade'] += $item->get_quantity();
                    $vendas_por_produto[$produto_id]['total_produto'] += $item->get_total();
                } else {
                    $produto = wc_get_product($produto_id);
                    $vendas_por_produto[$produto_id] = array(
                        'nome' => $produto->get_name(),
                        'quantidade' => $item->get_quantity(),
                        'valor_unitario' => $produto->get_price(),
                        'total_produto' => $item->get_total(),
                    );
                }

                // Contagem de vendas por forma de pagamento
                if (isset($vendas_por_forma_pagamento[$forma_pagamento_pedido])) {
                    $vendas_por_forma_pagamento[$forma_pagamento_pedido] += $item->get_total();
                } else {
                    $vendas_por_forma_pagamento[$forma_pagamento_pedido] = $item->get_total();
                }
            }
        }

        // Exibio dos resultados
        echo '<div class="container">';
        echo '<h3>Resumo / Produto:</h3>';
        echo '<table class="table">';
        echo '<thead>';
        echo '<tr>';
        echo '<th>Produto</th>';
        echo '<th>Quantidade</th>';
        echo '<th>Uni</th>';
        echo '<th>Total</th>';
        echo '</tr>';
        echo '</thead>';
        echo '<tbody>';

        $total_vendas_por_produto = 0; // Inicializa o total de vendas por produto

        foreach ($vendas_por_produto as $produto_id => $info_produto) {
            echo '<tr>';
            echo '<td>' . $info_produto['nome'] . '</td>';
            echo '<td>' . $info_produto['quantidade'] . '</td>';
            echo '<td>' . wc_price($info_produto['valor_unitario']) . '</td>';
            echo '<td>' . wc_price($info_produto['total_produto']) . '</td>';
            echo '</tr>';
            $total_vendas_por_produto += $info_produto['total_produto']; // Soma o total de vendas por produto
        }

        echo '</tbody>';
        echo '</table>';
        echo '<p>Total / Produto: ' . wc_price($total_vendas_por_produto) . '</p>';
        echo '</div>';

        echo '<div class="container">';
        echo '<h3>Resumo / Pagamentos :</h3>';
        echo '<table class="table">';
        echo '<thead>';
        echo '<tr>';
        echo '<th>Forma de Pagamento</th>';
        echo '<th>Total Vendido</th>';
        echo '</tr>';
        echo '</thead>';
        echo '<tbody>';

        foreach ($vendas_por_forma_pagamento as $forma_pagamento => $total_vendido) {
            echo '<tr>';
            echo '<td>' . $forma_pagamento . '</td>';
            echo '<td>' . wc_price($total_vendido) . '</td>';
            echo '</tr>';
        }

        echo '</tbody>';
        echo '</table>';
        echo '</div>';
    } else {
        echo '<div class="container">';
        echo '<p>Nenhum resultado encontrado.</p>';
        echo '</div>';
    }
} else {
    echo '<div class="container">';
    echo '<p>Por favor, utilize o formulrio para filtrar os resultados.</p>';
    echo '</div>';
}
?>


        </div><!-- .container -->
    </main><!-- #main -->
</div><!-- #primary -->

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<?php
// Adicione aqui o rodap do WordPress
get_footer();
?>
</body>
</html>
