<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Filtrar Pedidos</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <form method="get" action="">
        <div class="form-group">
            <select class="form-control" id="usuarioSelect" name="usuario">
                <option value="">Todos os clientes</option>
                <?php
                $users = get_users();
                foreach ($users as $user) {
                    echo '<option value="' . esc_attr($user->ID) . '">' . esc_html($user->display_name) . '</option>';
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <select class="form-control" id="tipoPagamentoSelect" name="tipo_pagamento">
                <option value="">Todos os tipos de pagamento</option>
                <?php
                $payment_gateways = WC()->payment_gateways->get_available_payment_gateways();
                foreach ($payment_gateways as $id => $payment_gateway) {
                    if ($payment_gateway->enabled == 'yes') {
                        echo '<option value="' . esc_attr($id) . '">' . esc_html($payment_gateway->title) . '</option>';
                    }
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="categoriaProdutoSelect">Categoria do Produto:</label>
            <select class="form-control" id="categoriaProdutoSelect" name="categoria_produto">
                <option value="">Todas as categorias de produto</option>
                <?php
                $product_categories = get_terms(array(
                    'taxonomy' => 'product_cat',
                    'hide_empty' => false,
                ));
                foreach ($product_categories as $category) {
                    echo '<option value="' . esc_attr($category->term_id) . '">' . esc_html($category->name) . '</option>';
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="dataInicial">Data Inicial:</label>
            <input type="date" class="form-control" id="dataInicial" name="data_inicial" value="<?php echo date('Y-m-d'); ?>">
        </div>

        <div class="form-group">
            <label for="dataFinal">Data Final:</label>
            <input type="date" class="form-control" id="dataFinal" name="data_final" value="<?php echo date('Y-m-d'); ?>">
        </div>

        <button type="submit" class="btn btn-primary">Filtrar</button>
    </form>

    <?php
// Verifica se todas as informaes foram fornecidas
if (!isset($_GET['usuario'], $_GET['tipo_pagamento'], $_GET['categoria_produto'], $_GET['data_inicial'], $_GET['data_final'])) {
    echo "<h2 style='text-align: center;'>Por favor, preencha todos os campos necessrios</h2>";
} else {
    $usuario = $_GET['usuario'];
    $tipo_pagamento = $_GET['tipo_pagamento'];
    $categoria_produto = $_GET['categoria_produto'];
    $data_inicial = $_GET['data_inicial'];
    $data_final = $_GET['data_final'];

    // Exibe os parmetros fornecidos
    echo "<br><h2 style='text-align: center;'>Detalhes dos Pedidos: </h2> <br>";
    echo "<b>Usurio:</b> " . ($usuario ? get_userdata($usuario)->display_name : "Todos os clientes") . "<br>";
    echo "<b>Entre as datas:</b> " . $data_inicial . " e " . $data_final . "<br>";
    echo "<b>Categoria:</b> " . ($categoria_produto ? get_term($categoria_produto, 'product_cat')->name : "Todas as categorias") . "<br><br>";

    $args = [
        'limit' => -1,
        'payment_method' => $tipo_pagamento,
        'date_created' => $data_inicial && $data_final ? $data_inicial . '...' . $data_final : '',
    ];

    if (!empty($usuario)) {
        $args['customer'] = $usuario;
    }

    $orders = wc_get_orders($args);
    $filtered_orders = [];

    // Filtra os pedidos pela categoria de produto, se especificada
    foreach ($orders as $order) {
        $keepOrder = false;
        foreach ($order->get_items() as $item) {
            $product_id = $item->get_product_id();
            $product_categories = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'ids'));
            if (in_array($categoria_produto, $product_categories)) {
                $keepOrder = true;
                break;
            }
        }
        if ($keepOrder) {
            $filtered_orders[] = $order;
        }
    }

    // Verifica se h resultados
    if (empty($filtered_orders)) {
        echo "<h2 style='text-align: center;'>Nenhum dado encontrado</h2>";
    } else {
        // Continua a processar os pedidos filtrados...
        // Defina a varivel para o tamanho da fonte
        $tamanho_fonte = '18px';
        $tamanho_fonte2 = '24px';

        echo "<table class='minhaTabelaEspecifica' style='border-collapse: collapse; width: 100%; font-size: $tamanho_fonte;'>";
        echo "<thead>";
        echo "<tr>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Produto</th>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Qty</th>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Valor</th>";
        echo "<th style='border: 1px solid #000; padding: 8px;'>Total</th>";
        echo "</tr>";
        echo "</thead>";
        echo "<tbody>";

        $payment_totals = array();
        $items_aggregated = array();

        foreach ($filtered_orders as $order) {
            $payment_method = $order->get_payment_method_title();
            foreach ($order->get_items() as $item_id => $item) {
                $product_id = $item->get_product_id();
                $product_categories = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'ids'));
                if (in_array($categoria_produto, $product_categories)) {
                    $product = $item->get_product();
                    $product_name = $product->get_name();
                    $aggregate_key = $product_name . '|' . $payment_method;

                    if (isset($items_aggregated[$aggregate_key])) {
                        $items_aggregated[$aggregate_key]['quantity'] += $item->get_quantity();
                        $items_aggregated[$aggregate_key]['subtotal'] += $item->get_subtotal();
                    } else {
                        $items_aggregated[$aggregate_key] = [
                            'product_name' => $product_name,
                            'quantity' => $item->get_quantity(),
                            'price' => $product->get_price(),
                            'subtotal' => $item->get_subtotal(),
                            'payment_method' => $payment_method,
                        ];
                    }
                }
            }
        }

        foreach ($items_aggregated as $aggregate_key => $details) {
            echo "<tr>";
            echo "<td style='border: 1px solid #000; padding: 8px; font-size: $tamanho_fonte;'>" . esc_html($details['product_name']) . "</td>";
            echo "<td style='border: 1px solid #000; padding: 8px; font-size: $tamanho_fonte;'>" . esc_html($details['quantity']) . "</td>";
            echo "<td style='border: 1px solid #000; padding: 8px; font-size: $tamanho_fonte;'>" . wc_price($details['price']) . '<br>' . esc_html($details['payment_method']) . "</td>";
            echo "<td style='border: 1px solid #000; padding: 8px; font-size: $tamanho_fonte;'>" . wc_price($details['subtotal']) . "</td>";
            echo "</tr>";

            if (isset($payment_totals[$details['payment_method']])) {
                $payment_totals[$details['payment_method']] += $details['subtotal'];
            } else {
                $payment_totals[$details['payment_method']] = $details['subtotal'];
            }
        }

        echo "</tbody>";
        echo "</table>";

        // Exibio dos totais por mtodo de pagamento segue aqui...
    }
}
?>


</div>
<!-- Bootstrap JS and dependencies -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
