<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Filtrar Pedidos</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
 
<div class="container mt-5">
    <form method="get" action="">
        <div class="form-group">
            <select class="form-control" id="usuarioSelect" name="usuario">
                <option value="">Todos os clientes</option>
                <?php
                $users = get_users();
                foreach ($users as $user) {
                    echo '<option value="' . esc_attr($user->ID) . '">' . esc_html($user->display_name) . '</option>';
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <select class="form-control" id="tipoPagamentoSelect" name="tipo_pagamento">
                <option value="">Todos os tipos de pagamento</option>
                <?php
                $payment_gateways = WC()->payment_gateways->get_available_payment_gateways();
                foreach ($payment_gateways as $id => $payment_gateway) {
                    if ($payment_gateway->enabled == 'yes') {
                        echo '<option value="' . esc_attr($id) . '">' . esc_html($payment_gateway->title) . '</option>';
                    }
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="categoriaProdutoSelect">Categoria do Produto:</label>
            <select class="form-control" id="categoriaProdutoSelect" name="categoria_produto">
                <option value="">Todas as categorias de produto</option>
                <?php
                $product_categories = get_terms(array(
                    'taxonomy' => 'product_cat',
                    'hide_empty' => false,
                ));
                foreach ($product_categories as $category) {
                    echo '<option value="' . esc_attr($category->term_id) . '">' . esc_html($category->name) . '</option>';
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="dataInicial">Data Inicial:</label>
            <input type="date" class="form-control" id="dataInicial" name="data_inicial" value="<?php echo date('Y-m-d'); ?>">
        </div>

        <div class="form-group">
            <label for="dataFinal">Data Final:</label>
            <input type="date" class="form-control" id="dataFinal" name="data_final" value="<?php echo date('Y-m-d'); ?>">
        </div>

        <button type="submit" class="btn btn-primary">Filtrar</button>
    </form>

    <?php
    if (isset($_GET['usuario'], $_GET['tipo_pagamento'], $_GET['categoria_produto'], $_GET['data_inicial'], $_GET['data_final'])) {
        $usuario = $_GET['usuario'];
        $tipo_pagamento = $_GET['tipo_pagamento'];
        $categoria_produto = $_GET['categoria_produto'];
        $data_inicial = $_GET['data_inicial'];
        $data_final = $_GET['data_final'];

        $args = [
            'limit' => -1,
            'payment_method' => $tipo_pagamento,
            'date_created' => $data_inicial && $data_final ? $data_inicial . '...' . $data_final : '',
        ];

        if (!empty($usuario)) {
            $args['customer'] = $usuario;
        }

        $orders = wc_get_orders($args);
        $filtered_orders = [];

        if (!empty($categoria_produto)) {
            foreach ($orders as $order) {
                foreach ($order->get_items() as $item) {
                    $product_id = $item->get_product_id();
                    if (has_term($categoria_produto, 'product_cat', $product_id)) {
                        $filtered_orders[] = $order;
                        break;
                    }
                }
            }
        } else {
            $filtered_orders = $orders;
        }

        echo "<br><h2  style='text-align: center' >Detalhes dos Pedidos: </h2> <br>";
        echo "</h6> <b> Usuario:</b> " . ($_GET['usuario'] ? get_userdata($_GET['usuario'])->display_name : "Todos os clientes") . ", <br>";
        echo "<b>Entre as datas: </b>" . $_GET['data_inicial'] . " e " . $_GET['data_final'] . ", <br>";
        echo "<b> Tipo  de pagamento: </b>" . ($_GET['tipo_pagamento'] ? wc_get_payment_gateway_by_order($filtered_orders[0])->get_title() : "Todos os tipos de pagamento");
        echo "</h6> <br><br>";

        echo "<table class='minhaTabelaEspecifica'>";
        echo "<thead>";
        echo "<tr>";
 
        echo "<th>Produto</th>";
        echo "<th>Qty</th>";
        echo "<th>Valor</th>";
        echo "<th>Total</th>";
        echo "<th>Pagamento</th>";
        echo "</tr>";
        echo "</thead>";
        echo "<tbody>";

        $payment_totals = array();

        foreach ($filtered_orders as $order) {
            $customer_id = $order->get_customer_id();
            $customer_name = $customer_id ? get_userdata($customer_id)->display_name : '-';
            $payment_method = $order->get_payment_method_title();

            $items_summary = [];

            foreach ($order->get_items() as $item_id => $item) {
                $product = $item->get_product();
                $product_name = $product->get_name();

                if (isset($items_summary[$product_name])) {
                    $items_summary[$product_name]['quantity'] += $item->get_quantity();
                    $items_summary[$product_name]['subtotal'] += $item->get_subtotal();
                } else {
                    $items_summary[$product_name] = [
                        'quantity' => $item->get_quantity(),
                        'price' => $product->get_price(),
                        'subtotal' => $item->get_subtotal(),
                        'payment_method' => $payment_method,
                    ];
                }
            }

            foreach ($items_summary as $name => $details) {
                echo "<tr>";
 
                echo "<td>" . esc_html($name) . "</td>";
                echo "<td>" . esc_html($details['quantity']) . "</td>";
                echo "<td>" . wc_price($details['price']) . "</td>";
                echo "<td>" . wc_price($details['subtotal']) . "</td>";
                echo "<td>" . esc_html($details['payment_method']) . "</td>";
                echo "</tr>";

                if (isset($payment_totals[$payment_method])) {
                    $payment_totals[$payment_method] += $details['subtotal'];
                } else {
                    $payment_totals[$payment_method] = $details['subtotal'];
                }
            }
        }

        echo "</tbody>";
        echo "</table>";

        echo "<br><h2 style='text-align: center'>Total Pagamento</h2> <br>";
        echo "<table class='table'>";
echo "<thead>";
echo "<tr>";
echo "<th>Forma de Pagamento</th>";
echo "<th>Total</th>";
echo "</tr>";
echo "</thead>";
echo "<tbody>";

$total_sum = 0; // Inicializa a soma total
foreach ($payment_totals as $payment_method => $total) {
    echo "<tr>";
    echo "<td>" . esc_html($payment_method) . "</td>";
    echo "<td>" . wc_price($total) . "</td>";
    echo "</tr>";
    $total_sum += $total; // Adiciona ao total geral
}

// Exibe o total geral
echo "<tr style='font-weight: bold;'>";
echo "<td>Total Geral:</td>";
echo "<td>" . wc_price($total_sum) . "</td>";
echo "</tr>";

echo "</tbody>";
echo "</table>";
    }
    ?>
</div>





<style>
    .table {
        width: 100%;
        border-collapse: collapse;
    }
    .table th, .table td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }
    .table tbody tr:last-child td {
        font-size: 20px; /* Aumenta o tamanho da fonte */
        font-weight: bold; /* Faz o texto ficar em negrito */
        background-color: #f2f2f2; /* Adiciona uma cor de fundo */
    }
</style>



<style>

.minhaTabelaEspecifica {
  width: 100% !important; /* Faz com que a tabela ocupe toda a largura do continer pai */
  border-collapse: collapse !important; /* Remove o espao entre as bordas das clulas */
  table-layout: auto !important; /* Permite que a largura das colunas se ajuste ao contedo */
}

.minhaTabelaEspecifica th, .minhaTabelaEspecifica td {
  border: 1px solid #ddd !important; /* Adiciona borda s clulas */
  padding: 8px !important; /* Adiciona um pouco de espao dentro das clulas */
  text-align: left !important; /* Alinha o texto  esquerda */
}

</style>


<!-- Bootstrap JS and dependencies -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
 
