<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * @package WooCommerce/Templates
 * @version 5.9.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_checkout_form', $checkout );

// Here, you can customize the checkout form as you wish
?>
<div id="customer_details">
	<div class="col2-set" id="customer_details">
		<div class="col-1">
			<?php do_action( 'woocommerce_checkout_billing' ); ?>
		</div>
	</div>
</div>

<?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>

<?php do_action( 'woocommerce_before_order_notes', $checkout ); ?>

<?php if ( ! WC()->cart->needs_shipping() || wc_ship_to_billing_address_only() ) : ?>

	<h3><?php esc_html_e( 'Additional information', 'woocommerce' ); ?></h3>

<?php endif; ?>

<?php do_action( 'woocommerce_after_order_notes', $checkout ); ?>

<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

<?php echo wc_get_template( 'checkout/terms.php' ); ?>

<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

<?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>

<div class="form-row place-order">
	<noscript>
		<?php
		/* translators: $1 and $2 opening and closing emphasis tags respectively */
		printf( esc_html__( 'Your order so far: %1$s%2$s.', 'woocommerce' ), '<strong>', '</strong>' );
		?>
	</noscript>

	<?php wc_get_template( 'checkout/terms.php' ); ?>

	<button type="submit" class="button alt" name="woocommerce_checkout_place_order" id="place_order" value="<?php esc_attr_e( 'Place order', 'woocommerce' ); ?>" data-value="<?php esc_attr_e( 'Place order', 'woocommerce' ); ?>"><?php esc_html_e( 'Place order', 'woocommerce' ); ?></button>

	<?php do_action( 'woocommerce_checkout_order_review' ); ?>
</div>

<?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
