<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if ( ! defined( 'ABSPATH' ) ) {
		die;
	} // Cannot access pages directly.
	if ( ! class_exists( 'WBTM_Dependencies_Pro' ) ) {
		class WBTM_Dependencies_Pro {
			public function __construct() {
				// Ensure WBTM_Translations is loaded from the main plugin
				require_once WP_PLUGIN_DIR . '/bus-ticket-booking-with-seat-reservation/inc/WBTM_Translations.php';
				add_action( 'init', array( $this, 'language_load' ) );
				add_action( 'add_wbtm_frontend_script', array( $this, 'frontend_script' ) );
				add_action( 'add_wbtm_admin_script', array( $this, 'admin_script' ) );
				add_action( 'add_wbtm_common_script', array( $this, 'common_script' ) );
				add_action( 'admin_init', array( $this, 'wbtm_upgrade' ) );
				$this->load_pro();
				add_action( 'admin_notices', array( $this, 'pdf_admin_notice' ) );
				add_action( 'mp_status_notice_sec', array( $this, 'status_notice_sec' ) );
				add_action( 'mp_status_table_item_sec', array( $this, 'status_table_item_sec' ) );
			}

			public function language_load() {
				$plugin_dir = basename( dirname( __DIR__ ) ) . "/languages/";
				load_plugin_textdomain( 'addon-bus--ticket-booking-with-seat-pro', false, $plugin_dir );
			}

			public function frontend_script() {
				//wp_enqueue_script( 'mpwpb_pro', MPWPB_Plugin_PRO_URL . '/assets/frontend/mpwpb_pro.js', array( 'jquery' ), time(), true );
			}

			public function admin_script() {
				wp_enqueue_style( 'wbtm_admin_pro', WBTM_PLUGIN_URL_PRO . '/assets/admin/wbtm_admin_pro.css', array(), time() );
				wp_enqueue_script( 'wbtm_admin_pro', WBTM_PLUGIN_URL_PRO . '/assets/admin/wbtm_admin_pro.js', array( 'jquery' ), time(), true );
				
				// Load custom CSS for backend order page
				if (isset($_GET['page']) && $_GET['page'] === 'wbtm_backend_order') {
					wp_enqueue_style( 'wbtm_backend_order_custom', WBTM_PLUGIN_URL_PRO . '/assets/admin/wbtm_backend_order_custom.css', array(), time() );
					wp_enqueue_script( 'wbtm_backend_order_custom', WBTM_PLUGIN_URL_PRO . '/assets/admin/wbtm_backend_order_custom.js', array( 'jquery' ), time(), true );
				}
			}

			public function common_script() {
				wp_enqueue_style( 'mpwpb_pro', WBTM_PLUGIN_URL_PRO . '/assets/frontend/wbtm_global_pro.css', array(), time() );
			}

			public function wbtm_upgrade() {
				if ( get_option( 'wbtm_conflict_update_pro' ) != 'completed' ) {
					update_option( 'wbtm_conflict_update_pro', 'completed' );
                }
				if ( get_option( 'wbtm_upgrade_global_data_pro' ) != 'completed' ) {
					$global_settings = get_option( 'wbtm_bus_settings' );
					$pdf_settings    = [];
					if ( isset( $global_settings['merge_pdf_ticket'] ) && $global_settings['merge_pdf_ticket'] ) {
						$pdf_settings['merge_pdf_ticket'] = $global_settings['merge_pdf_ticket'];
					}
					if ( isset( $global_settings['pdf_logo'] ) && $global_settings['pdf_logo'] ) {
						$pdf_settings['pdf_logo'] = $global_settings['pdf_logo'];
					}
					if ( isset( $global_settings['pdf_bacckground_image'] ) && $global_settings['pdf_bacckground_image'] ) {
						$pdf_settings['pdf_bg'] = $global_settings['pdf_bacckground_image'];
					}
					if ( isset( $global_settings['pdf_backgroud_color'] ) && $global_settings['pdf_backgroud_color'] ) {
						$pdf_settings['pdf_bg_color'] = $global_settings['pdf_backgroud_color'];
					}
					if ( isset( $global_settings['pdf_text_color'] ) && $global_settings['pdf_text_color'] ) {
						$pdf_settings['pdf_text_color'] = $global_settings['pdf_text_color'];
					}
					if ( isset( $global_settings['pdf_company_address'] ) && $global_settings['pdf_company_address'] ) {
						$pdf_settings['pdf_address'] = $global_settings['pdf_company_address'];
					}
					if ( isset( $global_settings['pdf_company_phone'] ) && $global_settings['pdf_company_phone'] ) {
						$pdf_settings['pdf_phone'] = $global_settings['pdf_company_phone'];
					}
					if ( isset( $global_settings['pdf_company_email'] ) && $global_settings['pdf_company_email'] ) {
						$pdf_settings['pdf_email'] = $global_settings['pdf_company_email'];
					}
					if ( isset( $global_settings['pdf_terms_title'] ) && $global_settings['pdf_terms_title'] ) {
						$pdf_settings['pdf_tc_title'] = $global_settings['pdf_terms_title'];
					}
					if ( isset( $global_settings['pdf_terms_text'] ) && $global_settings['pdf_terms_text'] ) {
						$pdf_settings['pdf_tc_text'] = $global_settings['pdf_terms_text'];
					}
					update_option( 'wbtm_pdf_settings', $pdf_settings );
					$email_settings = [];
					if ( isset( $global_settings['email_send_pdf'] ) && $global_settings['email_send_pdf'] ) {
						$email_settings['pdf_send_status'] = $global_settings['email_send_pdf'];
					}
					if ( isset( $global_settings['pdf_email_send_on'] ) && $global_settings['pdf_email_send_on'] ) {
						$email_settings['pdf_email_status'] = $global_settings['pdf_email_send_on'];
					}
					if ( isset( $global_settings['pdf_email_subject'] ) && $global_settings['pdf_email_subject'] ) {
						$email_settings['pdf_email_subject'] = $global_settings['pdf_email_subject'];
					}
					if ( isset( $global_settings['pdf_email_subject'] ) && $global_settings['pdf_email_subject'] ) {
						$email_settings['pdf_email_subject'] = $global_settings['pdf_email_subject'];
					}
					if ( isset( $global_settings['pdf_email_text'] ) && $global_settings['pdf_email_text'] ) {
						$email_settings['pdf_email_content'] = $global_settings['pdf_email_text'];
					}
					if ( isset( $global_settings['pdf_email_admin_notification_email'] ) && $global_settings['pdf_email_admin_notification_email'] ) {
						$email_settings['pdf_admin_notification_email'] = $global_settings['pdf_email_admin_notification_email'];
					}
					if ( isset( $global_settings['pdf_email_form_name'] ) && $global_settings['pdf_email_form_name'] ) {
						$email_settings['pdf_email_form_name'] = $global_settings['pdf_email_form_name'];
					}
					if ( isset( $global_settings['pdf_email_form_email'] ) && $global_settings['pdf_email_form_email'] ) {
						$email_settings['pdf_email_form_email'] = $global_settings['pdf_email_form_email'];
					}
					update_option( 'wbtm_email_settings', $email_settings );
					update_option( 'wbtm_upgrade_global_data_pro', 'completed' );
				}
				if ( get_option( 'wbtm_upgrade_post_meta_attendee' ) != 'completed' ) {
					$all_posts_ids = WBTM_Global_Function::get_all_post_id( 'wbtm_bus', - 1, 1, 'any' );
					if ( sizeof( $all_posts_ids ) > 0 ) {
						$d_forms = WBTM_Attendee_form::default_form();
						foreach ( $all_posts_ids as $post_id ) {
							$attendee_infos = [];
							foreach ( $d_forms as $key => $form ) {
								$form['active']   = WBTM_Global_Function::get_post_info( $post_id, $key );
								$attendee_infos[] = $form;
								delete_post_meta( $post_id, $key );
							}
							update_post_meta( $post_id, 'wbtm_attendee_info', $attendee_infos );
							//*******************//
							$custom_attendees = WBTM_Global_Function::get_post_info( $post_id, 'attendee_reg_form', [] );
							$custom_form      = [];
							if ( sizeof( $custom_attendees ) > 0 ) {
								foreach ( $custom_attendees as $attendee ) {
									if ( $attendee['field_label'] && $attendee['field_id'] && $attendee['filed_type'] ) {
										$custom_form[] = [
											'field_id'    => $attendee['field_id'],
											'filed_type'  => $attendee['filed_type'],
											'required'    => array_key_exists( 'checkbox_field', $attendee ) ? 1 : '',
											'field_label' => $attendee['field_label'],
											'args'        => array_key_exists( 'field_values', $attendee ) ? $attendee['field_values'] : '',
											'active'      => 1
										];
									}
								}
							}
							delete_post_meta( $post_id, 'attendee_reg_form' );
							update_post_meta( $post_id, 'wbtm_custom_attendee_info', $custom_form );
						}
					}
					update_option( 'wbtm_upgrade_post_meta_attendee', 'completed' );
				}
				if ( get_option( 'wbtm_upgrade_order_meta' ) != 'completed' ) {
					$all_posts_ids = WBTM_Global_Function::get_all_post_id( 'wbtm_bus_booking', - 1, 1, 'any' );
					if ( sizeof( $all_posts_ids ) > 0 ) {
						foreach ( $all_posts_ids as $post_id ) {
							$journey_date  = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_journey_date' );
							$bus_time      = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_bus_start' );
							$user_time     = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_user_start' );
							$boarding_time = date( 'Y-m-d H:i', strtotime( $journey_date . ' ' . $user_time ) );
							$start_time    = date( 'Y-m-d H:i', strtotime( $journey_date . ' ' . $bus_time ) );
							update_post_meta( $post_id, 'wbtm_boarding_time', $boarding_time );
							update_post_meta( $post_id, 'wbtm_start_time', $start_time );
							$dropping_point = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_droping_point' );
							update_post_meta( $post_id, 'wbtm_dropping_point', $dropping_point );
							$pickup_point = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_pickpoint' );
							update_post_meta( $post_id, 'wbtm_pickup_point', $pickup_point );
							/***************/
							$order_status = WBTM_Global_Function::get_post_info( $post_id, 'wbtm_status' );
							$order_status = WBTM_Functions::get_order_status_text( $order_status );
							update_post_meta( $post_id, 'wbtm_order_status', $order_status );
						}
					}
					$ex_services = WBTM_Global_Function::get_all_post_id( 'wbtm_service_booking', - 1, 1, 'any' );
					if ( sizeof( $ex_services ) > 0 ) {
						foreach ( $ex_services as $ex_service_id ) {
							$order_status = WBTM_Global_Function::get_post_info( $ex_service_id, 'wbtm_status' );
							$order_status = WBTM_Functions::get_order_status_text( $order_status );
							update_post_meta( $ex_service_id, 'wbtm_order_status', $order_status );
						}
					}
					update_option( 'wbtm_upgrade_order_meta', 'completed' );
				}
			}

			private function load_pro() {
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Function_PRO.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Layout_Pro.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Settings_Global_PRO.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_return_discount.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_PRO_License.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Settings_PRO.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Attendee_form.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Pro_Pdf.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Pro_Mail.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_CSV.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Backend_Order.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Passenger_List.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_Reports.php';
				require_once WBTM_PLUGIN_DIR_PRO . '/inc/WBTM_View_Ticket.php';
			}

			public function status_notice_sec() {
				if ( isset( $_REQUEST['active_mep_pdf_support_plugin'] ) && $_REQUEST['active_mep_pdf_support_plugin'] == 'yes' ) {
					activate_plugin( 'magepeople-pdf-support-master/mage-pdf.php' );
				}
				if ( isset( $_REQUEST['install_mep_pdf_support_plugin'] ) && $_REQUEST['install_mep_pdf_support_plugin'] == 'yes' ) {
					include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
					include_once( ABSPATH . 'wp-admin/includes/file.php' );
					include_once( ABSPATH . 'wp-admin/includes/misc.php' );
					include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
					$title    = 'title';
					$url      = 'url';
					$nonce    = 'nonce';
					$plugin   = 'plugin';
					$api      = 'api';
					$upgrades = new Plugin_Upgrader( new Plugin_Installer_Skin( compact( 'title', 'url', 'nonce', 'plugin', 'api' ) ) );
					$upgrades->install( 'https://github.com/magepeopleteam/magepeople-pdf-support/archive/master.zip' );
				}
			}

			public function status_table_item_sec() {
				?>
                <tr>
                    <th data-export-label="WC Version">PDF Tickets Installed:</th>
                    <th>
                        <span class="textSuccess"> <span class="far fa-check-circle mR_xs"></span>Yes</span>
                    </th>
                </tr>
                <tr>
                    <th data-export-label="WC Version">MagePeople PDF Support Installed:</th>
                    <th><?php $this->pdf_support_install_check(); ?></th>
                </tr>
                <tr>
                    <th data-export-label="WC Version">PHP GD library Installed:</th>
                    <th>
						<?php if ( extension_loaded( 'gd' ) ) { ?>
                            <span class="textSuccess"> <span class="far fa-check-circle mR_xs"></span>Yes</span>
						<?php } else { ?>
                            <span class="textWarning"> <span class="fas fa-exclamation-triangle mR_xs"></span>No</span>
						<?php } ?>
                    </th>
                </tr>
                <tr>
                    <th data-export-label="WC Version">PHP mbstring library Installed:</th>
                    <th>
						<?php if ( extension_loaded( 'mbstring' ) ) { ?>
                            <span class="textSuccess"> <span class="far fa-check-circle mR_xs"></span>Yes</span>
						<?php } else { ?>
                            <span class="textWarning"> <span class="fas fa-exclamation-triangle mR_xs"></span>No</span>
						<?php } ?>
                    </th>
                </tr>
				<?php
			}

			public function pdf_support_install_check() {
				$admin_url               = get_admin_url();
				$active_mpdf_plugin_url  = '<a href="' . $admin_url . 'edit.php?post_type=wbtm_bus&page=wbtm_status_page&active_mep_pdf_support_plugin=yes" class="page-title-action">Active Now</a>';
				$install_mpdf_plugin_url = '<a href="' . $admin_url . 'edit.php?post_type=wbtm_bus&page=wbtm_status_page&install_mep_pdf_support_plugin=yes" class="page-title-action">Install Now</a>';
				include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
				$plugin_dir = ABSPATH . 'wp-content/plugins/magepeople-pdf-support-master';
				if ( is_plugin_active( 'magepeople-pdf-support-master/mage-pdf.php' ) ) {
					echo '<span class="mep_success"> <span class="far fa-check-circle mR_xs"></span>Yes</span>';
				} elseif ( is_dir( $plugin_dir ) ) {
					echo '<span class="textWarning"> <span class="fas fa-exclamation-triangle mR_xs"></span>Installed But Not Active ' . $active_mpdf_plugin_url . '</span>';
				} else {
					echo '<span class="textWarning"> <span class="fas fa-exclamation-triangle mR_xs"></span>Not Installed  ' . $install_mpdf_plugin_url . '</span>';
				}
			}

			public function pdf_admin_notice() {
				$admin_url               = get_admin_url();
				$active_mpdf_plugin_url  = '<a href="' . $admin_url . 'edit.php?post_type=wbtm_bus&page=wbtm_status_page&active_mep_pdf_support_plugin=yes" class="page-title-action">Active Now</a>';
				$install_mpdf_plugin_url = '<a href="' . $admin_url . 'edit.php?post_type=wbtm_bus&page=wbtm_status_page&install_mep_pdf_support_plugin=yes" class="page-title-action">Install Now</a>';
				include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
				$plugin_dir = ABSPATH . 'wp-content/plugins/magepeople-pdf-support-master';
				if ( is_plugin_active( 'magepeople-pdf-support-master/mage-pdf.php' ) ) {
					$message = null;
				} elseif ( is_dir( $plugin_dir ) ) {
					$message = '<span class="textWarning"> <span class="fas fa-exclamation-triangle mR_xs"></span>Mage PDF Support Plugin should be Activated But its only Installed But Not Actived ' . $active_mpdf_plugin_url . '</span>';
				} else {
					$message = '<span class="textWarning"> <span class="fas fa-exclamation-triangle mR_xs"></span>Mage PDF Support Plugin should be Installed & Activated But its not installed in your website  ' . $install_mpdf_plugin_url . '</span>';
				}
				if ( ! empty( $message ) ) {
					$class = 'notice notice-error';
					printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), $message );
				}
			}
		}
		new WBTM_Dependencies_Pro();
	}
