<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if (!defined('ABSPATH')) {
		die;
	} // Cannot access pages directly.
	if (!class_exists('WBTM_Settings_Global_PRO')) {
		class WBTM_Settings_Global_PRO {
			public function __construct() {
				add_filter('wbtm_settings_sec_reg', array($this, 'settings_sec_reg'), 12, 1);
				add_filter('wbtm_settings_sec_fields', array($this, 'settings_sec_fields'), 12, 1);
			}
			public function settings_sec_reg($default_sec): array {
				$label=WBTM_Functions::get_name();
				$sections = array(
					array(
						'id' => 'wbtm_pdf_settings',
						'title' => $label.' '.esc_html__('PDF Settings', 'addon-bus--ticket-booking-with-seat-pro')
					),
					array(
						'id' => 'wbtm_passenger_pdf_settings',
						'title' => $label.' '.esc_html__('PDF Passenger  List', 'addon-bus--ticket-booking-with-seat-pro')
					),
					array(
						'id' => 'wbtm_passenger_csv_settings',
						'title' => $label.' '.esc_html__('CSV Settings', 'addon-bus--ticket-booking-with-seat-pro')
					),
					array(
						'id' => 'wbtm_email_settings',
						'title' => $label.' '.esc_html__('Email Settings', 'addon-bus--ticket-booking-with-seat-pro')
					)
				);
				return array_merge($default_sec, $sections);
			}
			public function settings_sec_fields($default_fields): array {
				$settings_fields = array(
					'wbtm_pdf_settings' => array(
						array(
							'name' => 'merge_pdf_ticket',
							'label' => __('Merge Pdf Ticket', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => __('If YES, then multiple seats of the same order will generate one ticket. Default no', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'select',
							'default' => 'no',
							'options' => array(
								'yes' => esc_html__('Yes', 'addon-bus--ticket-booking-with-seat-pro'),
								'no' => esc_html__('No', 'addon-bus--ticket-booking-with-seat-pro')
							)
						),
						array(
							'name' => 'pdf_logo',
							'label' => esc_html__('Logo', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Add your custom logo what will appear on the PDF Ticket', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'file',
							'default' => ''
						),
						array(
							'name' => 'pdf_bg',
							'label' => esc_html__('Background Image', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('You can add a custom Background Image for Pdf. The image width should be 680px', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'file',
							'default' => ''
						),
						array(
							'name' => 'pdf_bg_color',
							'label' => esc_html__('Background Color', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('PDF Ticket Background Color', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'color',
							'default' => ''
						),
						array(
							'name' => 'pdf_text_color',
							'label' => esc_html__('Text Color', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('PDF Ticket Text Color', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'color',
							'default' => ''
						),
						array(
							'name' => 'pdf_address',
							'label' => esc_html__('Company address', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Add your company address', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'textarea'
						),
						array(
							'name' => 'pdf_phone',
							'label' => esc_html__('Phone Number', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Add company phone number here', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'text',
							'default' => ''
						),
						array(
							'name' => 'pdf_email',
							'label' => esc_html__('E-mail', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Add company E-mail here', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'text',
							'default' => ''
						),
						array(
							'name' => 'pdf_tc_title',
							'label' => esc_html__('Terms & Condition Title', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('This T & C Text will display in the ticket footer', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'text',
							'default' => ''
						),
						array(
							'name' => 'pdf_tc_text',
							'label' => esc_html__('Terms & Condition Text', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('This T & C Text will display in the ticket footer', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'wysiwyg',
							'default' => ''
						),
					),
					'wbtm_passenger_pdf_settings' => array(
						array(
							'name' => 'passenger_pdf_bus_name',
							'label' => esc_html__('Bus Name', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Bus Name ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_bus_id',
							'label' => esc_html__('Bus No', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Bus No ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_price',
							'label' => esc_html__('Price', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Price ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_total_passenger',
							'label' => esc_html__('Total Passenger', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Total Passenger ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_total_order',
							'label' => esc_html__('Total Order', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Total Order ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_pin',
							'label' => esc_html__('PIN', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show PIN ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_order_id',
							'label' => esc_html__('Order ID', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Order ID ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_seat_name',
							'label' => esc_html__('Seat Name', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Seat Name ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_name',
							'label' => esc_html__('Passenger Name', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Name ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_phone',
							'label' => esc_html__('Passenger Phone', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Phone ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(

							'name' => 'passenger_pdf_extra_service',
							'label' => esc_html__('Passenger Extra Service', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Extra Service ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(

							'name' => 'passenger_pdf_from_to',
							'label' => esc_html__('From=>To', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show From=>To ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'passenger_pdf_pickup_drop_off',
							'label' => esc_html__('Pickup/drop off', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Pickup/drop off ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),

						array(
							'name' => 'passenger_pdf_attendee_info',
							'label' => esc_html__('Attendee Info', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Attendee Info ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),

					),
					'wbtm_passenger_csv_settings' => array(
						array(
							'name' => 'csv_bus_name',
							'label' => esc_html__('Bus Name', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Bus Name ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_bus_id',
							'label' => esc_html__('Bus No', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Bus No ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_price',
							'label' => esc_html__('Price', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Price ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' =>'csv_pin',
							'label' => esc_html__('PIN', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show PIN ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(

							'name' =>'csv_journey_date',
							'label' => esc_html__('Journey Date', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Journey Date ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(

							'name' => 'csv_order_id',
							'label' => esc_html__('Order ID', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Order ID ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_seat_name',
							'label' => esc_html__('Seat Name', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Seat Name ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_name',
							'label' => esc_html__('Passenger Name', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Name ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_phone',
							'label' => esc_html__('Passenger Phone', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Phone ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(

							'name' => 'csv_email',
							'label' => esc_html__('Passenger Email', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Email ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_address',
							'label' => esc_html__('Passenger Address', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Address ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_extra_service',
							'label' => esc_html__('Extra Service', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Passenger Extra Service ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(

							'name' => 'csv_from_to',
							'label' => esc_html__('From=>To', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show From=>To ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
						array(
							'name' => 'csv_pickup_drop_off',
							'label' => esc_html__('Pickup/drop off', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Show Pickup/drop off ?', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'checkbox',
							'default' => 'on',
						),
					),
					'wbtm_email_settings' => array(
						array(
							'name' => 'pdf_send_status',
							'label' => __('Send Ticket?', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => __('Please select which order status data you want to export', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'select',
							'default' => 'yes',
							'options' => array(
								'yes' => esc_html__('Yes', 'addon-bus--ticket-booking-with-seat-pro'),
								'no' => esc_html__('No', 'addon-bus--ticket-booking-with-seat-pro')
							)
						),
						array(
							'name' => 'pdf_email_status',
							'label' => esc_html__('Send Email on', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Send email with the ticket as attachment when these order status comes', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'multicheck',
							'default' => array(
								'processing' => 'processing',
								'completed' => 'completed'
							),
							'options' => array(
								'on-hold' => esc_html__('On Hold', 'addon-bus--ticket-booking-with-seat-pro'),
								'pending' => esc_html__('Pending', 'addon-bus--ticket-booking-with-seat-pro'),
								'processing' => esc_html__('Processing', 'addon-bus--ticket-booking-with-seat-pro'),
								'completed' => esc_html__('Completed', 'addon-bus--ticket-booking-with-seat-pro'),
							)
						),
						array(
							'name' => 'pdf_email_subject',
							'label' => esc_html__('Email Subject', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Set email subject here', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'text',
							'default' => ''
						),
						array(
							'name' => 'pdf_email_content',
							'label' => esc_html__('Email Content', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => '<span style="color: red">' . esc_html__('Please use this shortcode for get real data.', 'addon-bus--ticket-booking-with-seat-pro') . '</span> <br><br>' . esc_html__('Customer Name:', 'addon-bus--ticket-booking-with-seat-pro') . '{customer_name} <br>' . esc_html__('Bus Name:', 'addon-bus--ticket-booking-with-seat-pro') . '{bus_name} <br>' . esc_html__('Journey Date:', 'addon-bus--ticket-booking-with-seat-pro') . '{journey_date} <br>' . esc_html__(' Order ID: ', 'addon-bus--ticket-booking-with-seat-pro') . '{order_id} <br>',
							'type' => 'wysiwyg',
							'default' =>'Hello {customer_name}, <br><br> Thank you for registering. <br><br> Please download pdf ticket in this attachment. <br><br> Please carry out printing ticket on event spot. <br><br> Here is details of event: <br><br> Bus Name: {bus_name} <br><br> Journey Date: {journey_date}',
						),
						array(
							'name' => 'pdf_admin_notification_email',
							'label' => esc_html__('Admin Notification Email', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Please enter an email address so an admin can rceive pdf ticket and seat treashold notification ', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'text',
							'default' => ''
						),
						array(
							'name' => 'pdf_email_form_name',
							'label' => esc_html__('Email From Name', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Add Email From Name here', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'text',
							'default' => ''
						),
						array(
							'name' => 'pdf_email',
							'label' => esc_html__('Email From Email', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => esc_html__('Add Email From Email here', 'addon-bus--ticket-booking-with-seat-pro'),
							'type' => 'text',
							'default' => ''
						),
						array(
							'name' => 'minimum_seat_treshold',
							'label' => esc_html__('Minimum Seat Threshold', 'bus-ticket-booking-with-seat-reservation'),
							'desc' => esc_html__('Set the minimum number of available seats. When this limit is reached or crossed, an email notification will be sent to the admin.', 'bus-ticket-booking-with-seat-reservation'),
							'type' => 'number',
							'default' => -1,
							'placeholder' => esc_html__('Ex:5', 'bus-ticket-booking-with-seat-reservation'),
						),
						array(
							'name' => 'seat_treshold_email_content',
							'label' => esc_html__('Minimum Seat Treshold Email Content', 'addon-bus--ticket-booking-with-seat-pro'),
							'desc' => '<span style="color: red">' . esc_html__('Please use this shortcode for get real data.', 'addon-bus--ticket-booking-with-seat-pro') . '</span> <br><br>' . esc_html__('Bus Name:', 'addon-bus--ticket-booking-with-seat-pro') . '{bus_name} <br>' . esc_html__('Journey Date:', 'addon-bus--ticket-booking-with-seat-pro') . '{journey_date} <br>',
							'type' => 'wysiwyg',
							'default' =>'Hello , <br><br> {bus_name} on {journey_date} only has 5 seat left. <br><br>',
						),
					)
				);
				return array_merge($default_fields, $settings_fields);
			}
		}
		new WBTM_Settings_Global_PRO();
	}