<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if (!defined('ABSPATH')) {
		die;
	} // Cannot access pages directly.
	if (!class_exists('WBTM_Settings_PRO')) {
		class WBTM_Settings_PRO {
			public function __construct() {
				add_action('add_wbtm_add_setting_menu', [$this, 'add_setting_menu']);
				add_action('add_wbtm_settings_tab_content', [$this, 'tab_content']);
				add_action('wbtm_custom_form_item', array($this, 'custom_form_item'));
				//add_action('add_wbtm_extra_service_content', array($this, 'extra_bag_settings'));
				add_action('wbtm_settings_save', [$this, 'settings_save']);
				add_filter('wbtm_filter_description_array', [$this, 'description_array']);
			}
			public function add_setting_menu() {
				?>
				<li data-tabs-target="#wbtm_reg_form_settings">
					<span class="fab fa-wpforms mR_xs"></span>
					<?php esc_html_e('Registration Form', 'addon-bus--ticket-booking-with-seat-pro'); ?>
				</li>
				<?php
			}
			public function tab_content($post_id) {
				$attendees = WBTM_Global_Function::get_post_info($post_id, 'wbtm_attendee_info', []);
				$attendee_infos =sizeof($attendees)>0?$attendees:WBTM_Attendee_form::default_form();
				$custom_infos = WBTM_Global_Function::get_post_info($post_id, 'wbtm_custom_attendee_info', []);
				//echo '<pre>';print_r($custom_infos);echo '</pre>';
				?>
				<div class="tabsItem" data-tabs="#wbtm_reg_form_settings">
					<h3><?php esc_html_e('Passenger Registration Form', 'addon-bus--ticket-booking-with-seat-pro'); ?></h3>
					<p><?php WBTM_Settings::info_text('wbtm_reg_form_settings'); ?></p>
					
					<div class="_mB">
						<div class="_dLayout_bgLight_dFlex_justifyBetween">
							<div class="_dFlex_fdColumn">
								<label>
									<?php esc_html_e('Form Field Settings', 'addon-bus--ticket-booking-with-seat-pro'); ?>
								</label>
								<span><?php esc_html_e('Here you can set form field requirements.', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
							</div>
						</div>
						<div class="_dLayout">
							<?php if (sizeof($attendee_infos) > 0) { ?>
								<table>
									<thead>
									<tr>
										<th style="text-align: left;"><?php esc_html_e('Default Label', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
										<th><?php esc_html_e('Label', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
										<th><?php esc_html_e('Required', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
										<th><?php esc_html_e('Show/Hide', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($attendee_infos as $attendee_info) { ?>
										<tr>
											<th><?php echo esc_html($attendee_info['d_label']); ?></th>
											<td>
												<label>
													<input type="text" class="formControl wbtm_name_validation" name="wbtm_label_text[]" value="<?php echo esc_attr($attendee_info['field_label']); ?>" placeholder="<?php echo esc_attr($attendee_info['field_label']); ?>"/>
												</label>
											</td>
											<td>
												<label>
													<select class="formControl" name="wbtm_input_required[]">
														<option value="1" <?php echo esc_attr($attendee_info['required'] == 1 ? 'selected' : ''); ?>><?php esc_html_e('Required', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
														<option value="" <?php echo esc_attr(!$attendee_info['required'] ? 'selected' : ''); ?>><?php esc_html_e('Not Required', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
													</select>
												</label>
											</td>
											<td>
												<label>
													<select class="formControl" name="wbtm_input_active[]">
														<option value="1" <?php echo esc_attr($attendee_info['active'] == 1 ? 'selected' : ''); ?>><?php esc_html_e('Active', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
														<option value="" <?php echo esc_attr(!$attendee_info['active'] ? 'selected' : ''); ?>><?php esc_html_e('Disabled', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
													</select>
												</label>
											</td>
										</tr>
									<?php } ?>
									</tbody>
								</table>
							<?php } ?>
						</div>
					</div>
					
					<div class="_dLayout_bgLight">
						<div class="_dFlex_fdColumn">
							<label>
								<?php esc_html_e('Custom Form Field Settings', 'addon-bus--ticket-booking-with-seat-pro'); ?>
							</label>
							<?php WBTM_Settings::info_text('wbtm_custom_reg_form_settings'); ?>
						</div>
					</div>
					<div class="_dLayout  wbtm_settings_area wbtm_custom_form_setting_area">
						<table>
							<thead>
							<tr>
								<th>
									<?php esc_html_e('Label', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<i class="textRequired">&nbsp;*</i>
								</th>
								<th>
									<?php esc_html_e('Unique Id', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<i class="textRequired">&nbsp;*</i>
								</th>
								<th>
									<?php esc_html_e('Input Type', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<i class="textRequired">&nbsp;*</i>
								</th>
								<th>
									<?php esc_html_e('Field Value', 'addon-bus--ticket-booking-with-seat-pro'); ?>
									<i class="textRequired">&nbsp;*</i>
								</th>
								<th><?php esc_html_e('Required', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
								<th><?php esc_html_e('Default Value', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
								<th><?php echo WBTM_Translations::text_action(); ?></th>
							</tr>
							</thead>
							<tbody class="wbtm_sortable_area wbtm_item_insert">
							<?php if (sizeof($custom_infos) > 0) { ?>
								<?php foreach ($custom_infos as $custom_info) { ?>
									<?php $this->custom_form_item($custom_info); ?>
								<?php } ?>
							<?php } ?>
							</tbody>
						</table>
						<div class="_margin_xs">
<?php WBTM_Custom_Layout::add_new_button(esc_html__('Add New Custom Form', 'addon-bus--ticket-booking-with-seat-pro')); ?>
							<?php do_action('wbtm_hidden_table', 'wbtm_custom_form_item'); ?>
						</div>
					</div>
				</div>
				<?php
			}
			public function custom_form_item($form_info) {
				$label = array_key_exists('field_label', $form_info) ? $form_info['field_label'] : '';
				$type = array_key_exists('filed_type', $form_info) ? $form_info['filed_type'] : 'text';
				$required = array_key_exists('required', $form_info) ? $form_info['required'] : '';
				$id = array_key_exists('required', $form_info) ? $form_info['field_id'] : '';
				$d_value = array_key_exists('d_value', $form_info) ? $form_info['d_value'] : '';
				$field_values = array_key_exists('args', $form_info) ? $form_info['args'] : '';
				$active_class = $type == 'select' || $type == 'checkbox' || $type == 'radio' ? '' : 'dNone';
				$active_class_date = $type == 'date' ? '' : 'dNone';
				$active_class_d_value = $type == 'date' ? 'dNone' : '';
				?>
				<tr class="wbtm_remove_area">
					<td>
						<label>
							<input type="text" class="formControl wbtm_name_validation" name="wbtm_custom_label[]" value="<?php echo esc_attr($label); ?>" placeholder="<?php esc_attr_e('Enter Input Label', 'addon-bus--ticket-booking-with-seat-pro'); ?>"/>
						</label>
					</td>
					<td>
						<label>
							<input type="text" class="formControl wbtm_id_validation" name="wbtm_custom_id[]" value="<?php echo esc_attr($id); ?>" placeholder="<?php esc_attr_e('unique id. space & spacial character not allow', 'addon-bus--ticket-booking-with-seat-pro'); ?>"/>
						</label>
					</td>
					<td>
						<label>
							<select class="formControl" name="wbtm_custom_type[]">
								<option value="text" <?php echo esc_attr($type == 'text' ? 'selected' : ''); ?>><?php esc_html_e('Text', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="email" <?php echo esc_attr($type == 'email' ? 'selected' : ''); ?>><?php esc_html_e('Email', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="number" <?php echo esc_attr($type == 'number' ? 'selected' : ''); ?>><?php esc_html_e('Number', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="select" <?php echo esc_attr($type == 'select' ? 'selected' : ''); ?>><?php esc_html_e('Select', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="checkbox" <?php echo esc_attr($type == 'checkbox' ? 'selected' : ''); ?>><?php esc_html_e('Checkbox', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="radio" <?php echo esc_attr($type == 'radio' ? 'selected' : ''); ?>><?php esc_html_e('Radio', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="textarea" <?php echo esc_attr($type == 'textarea' ? 'selected' : ''); ?>><?php esc_html_e('Textarea', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="date" <?php echo esc_attr($type == 'date' ? 'selected' : ''); ?>><?php esc_html_e('Date', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
							</select>
						</label>
					</td>
					<td>
						<label class="<?php echo esc_attr($active_class); ?>">
							<input type="text" class="formControl" name="wbtm_custom_value[]" value="<?php echo esc_attr($field_values); ?>" placeholder="Ex: male,female"/>
						</label>
					</td>
					<td>
						<label>
							<select class="formControl" name="wbtm_custom_required[]">
								<option value="1" <?php echo esc_attr($required == 1 ? 'selected' : ''); ?>><?php esc_html_e('Required', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
								<option value="" <?php echo esc_attr(!$required ? 'selected' : ''); ?>><?php esc_html_e('Not Required', 'addon-bus--ticket-booking-with-seat-pro'); ?></option>
							</select>
						</label>
					</td>
					<td>
						<label class="<?php echo esc_attr($active_class_d_value); ?>">
							<input type="text" class="formControl" name="wbtm_default_value[]" value="<?php echo esc_attr($d_value); ?>" placeholder="Ex: Male"/>
						</label>
						<?php
							$date = $d_value ? date('Y-m-d', strtotime($d_value)) : '';
							$date_format = WBTM_Global_Function::date_picker_format();
							$now = date_i18n($date_format, strtotime(current_time('Y-m-d')));
							$hidden_date = $date ? date('Y-m-d', strtotime($date)) : '';
							$visible_date = $date ? date_i18n($date_format, strtotime($date)) : ''
						?>
						<label class="<?php echo esc_attr($active_class_date); ?>">
							<input type="hidden" name="wbtm_default_date[]" value="<?php echo esc_attr($hidden_date); ?>"/>
							<input value="<?php echo esc_attr($visible_date); ?>" class="formControl date_type" placeholder="<?php echo esc_attr($now); ?>"/>
						</label>
					</td>
					<td><?php WBTM_Custom_Layout::move_remove_button(); ?></td>
				</tr>
				<?php
			}
			public function extra_bag_settings($post_id) {
				$ex_bag_infos = WBTM_Function_PRO::get_extra_bag_info($post_id);
				if (sizeof($ex_bag_infos) > 0) {
					$label = array_key_exists('field_label', $ex_bag_infos) ? $ex_bag_infos['field_label'] : '';
					$price = array_key_exists('price', $ex_bag_infos) ? $ex_bag_infos['price'] : '';
					$max_qty = array_key_exists('max_qty', $ex_bag_infos) ? $ex_bag_infos['max_qty'] : '';
					$active = array_key_exists('active', $ex_bag_infos) ? $ex_bag_infos['active'] : '';
					$active_ex = $active ? 'mActive' : '';
					$checked_ex = $active ? 'checked' : '';
					?>
					<div class="divider"></div>
					<h5 class="dFlex">
						<?php WBTM_Custom_Layout::switch_button('wbtm_user_extra_bag', $checked_ex); ?>
						<span class="_mL"><?php esc_html_e('Extra Bag Settings', 'addon-bus--ticket-booking-with-seat-pro'); ?></span>
					</h5>
					<?php WBTM_Settings::info_text('wbtm_user_extra_bag'); ?>
					<div data-collapse="#wbtm_user_extra_bag" class="<?php echo esc_attr($active_ex); ?>">
						<div class="divider"></div>
						<div class="_dLayout_xs_mp_zero">
							<div class="_bgColor_2_padding_xs">
								<label class="max_700">
									<span class="max_300">
										<?php esc_html_e('Label', 'addon-bus--ticket-booking-with-seat-pro'); ?>
										<i class="textRequired">&nbsp;*</i>
									</span>
									<input class="formControl wbtm_name_validation" name="wbtm_ex_bag_label" value="<?php echo esc_attr($label); ?>"/>
								</label>
							</div>
							<div class="_padding_xs">
								<label class="max_700">
									<span class="max_300">
										<?php esc_html_e('Price', 'addon-bus--ticket-booking-with-seat-pro'); ?>
										<i class="textRequired">&nbsp;*</i>
									</span>
									<input class="formControl wbtm_price_validation" name="wbtm_ex_bag_price" value="<?php echo esc_attr($price); ?>"/>
								</label>
							</div>
							<div class="_bgColor_2_padding_xs">
								<label class="max_700">
									<span class="max_300">
										<?php esc_html_e('Maximum Qty', 'addon-bus--ticket-booking-with-seat-pro'); ?>
										<i class="textRequired">&nbsp;*</i>
									</span>
									<input class="formControl wbtm_number_validation" name="wbtm_ex_bag_max_qty" value="<?php echo esc_attr($max_qty); ?>"/>
								</label>
							</div>
						</div>
					</div>
					<?php
				}
			}
			/*******************************/
			public function settings_save($post_id) {
				if (get_post_type($post_id) == WBTM_Functions::get_cpt()) {
					$attendees = WBTM_Global_Function::get_post_info($post_id, 'wbtm_attendee_info', []);
					$d_forms = sizeof($attendees)>0?$attendees:WBTM_Attendee_form::default_form();
					$label = WBTM_Global_Function::get_submit_info('wbtm_label_text', array());
					$required = WBTM_Global_Function::get_submit_info('wbtm_input_required', array());
					$active = WBTM_Global_Function::get_submit_info('wbtm_input_active', array());
					if(sizeof($d_forms)>0) {
						$attendee_infos = [];
						foreach ($d_forms as $key => $form) {
							$form['required'] = $required[$key] ?: '';
							$form['active'] = $active[$key] ?: '';
							$form['field_label'] = $label[$key] ?: $form['d_label'];
							$attendee_infos[] = $form;
						}
						update_post_meta($post_id, 'wbtm_attendee_info', $attendee_infos);
					}
					
					/**************/
					$custom_info = [];
					$custom_label = WBTM_Global_Function::get_submit_info('wbtm_custom_label', array());
					$custom_id = WBTM_Global_Function::get_submit_info('wbtm_custom_id', array());
					$custom_type = WBTM_Global_Function::get_submit_info('wbtm_custom_type', array());
					$custom_value = WBTM_Global_Function::get_submit_info('wbtm_custom_value', array());
					$custom_required = WBTM_Global_Function::get_submit_info('wbtm_custom_required', array());
					$d_value = WBTM_Global_Function::get_submit_info('wbtm_default_value', array());
					$date_value = WBTM_Global_Function::get_submit_info('wbtm_default_date', array());
					if (sizeof($custom_id) > 0) {
						foreach ($custom_id as $key => $id) {
							$input_type = $custom_type[$key];
							if ($id && $custom_label[$key] && $input_type) {
								if ($input_type == 'select' || $input_type == 'checkbox' || $input_type == 'radio') {
									if ($custom_value[$key]) {
										$custom_info[] = [
											'field_id' => $id,
											'filed_type' => $custom_type[$key],
											'required' => $custom_required[$key],
											'field_label' => $custom_label[$key],
											'args' => $custom_value[$key],
											'd_value' => $d_value[$key],
											'active' => 1,
										];
									}
								}
								else if ($input_type == 'date') {
									$custom_info[] = [
										'field_id' => $id,
										'filed_type' => $custom_type[$key],
										'required' => $custom_required[$key],
										'field_label' => $custom_label[$key],
										'args' => '',
										'd_value' => $date_value[$key],
										'active' => 1,
									];
								}
								else {
									$custom_info[] = [
										'field_id' => $id,
										'filed_type' => $custom_type[$key],
										'required' => $custom_required[$key],
										'field_label' => $custom_label[$key],
										'args' => '',
										'd_value' => $d_value[$key],
										'active' => 1,
									];
								}
							}
						}
					}
					update_post_meta($post_id, 'wbtm_custom_attendee_info', $custom_info);
					/**************/
					$display_ex = WBTM_Global_Function::get_submit_info('wbtm_user_extra_bag') ? '1' : '';
					$label_ex = WBTM_Global_Function::get_submit_info('wbtm_ex_bag_label');
					$max_qty = WBTM_Global_Function::get_submit_info('wbtm_ex_bag_max_qty') ?: 1;
					$price = WBTM_Global_Function::get_submit_info('wbtm_ex_bag_price') ?: 0;
					$ex_bag_info = [
						'max_qty' => $max_qty,
						'price' => $price,
						'field_label' => $label_ex,
						'active' => $display_ex,
					];
					//update_post_meta($post_id, 'wbtm_ex_bag_info', $ex_bag_info);
				}
			}
			/*******************************/
			public function description_array($des = []) {
				$des['bus_return_discount'] = esc_html__('Enter return ticket discount as percentage (like 10.4%) or fixed amount. Select the type from dropdown.', 'addon-bus--ticket-booking-with-seat-pro');
				$des['wbtm_reg_form_settings'] = esc_html__('Here you can make passenger information form.', 'addon-bus--ticket-booking-with-seat-pro');
				$des['wbtm_custom_reg_form_settings'] = esc_html__('Here you can add custom attendee form fields.', 'addon-bus--ticket-booking-with-seat-pro');
				$des['wbtm_user_extra_bag'] = esc_html__('By default Extra bag is off but you can keep it On by switching this option. which add each attendee info', 'addon-bus--ticket-booking-with-seat-pro');
				return $des;
			}
		}
		new WBTM_Settings_PRO();
	}