<?php
/*
Plugin Name: WC – Checkout sem dados de cobrança
Description: Remove/torna opcionais todos os campos de cobrança e envio no checkout.
Author: você
*/

if (!defined('ABSPATH')) exit;

/* 1) Torna TODOS os campos de endereço NÃO obrigatórios */
add_filter('woocommerce_default_address_fields', function($fields){
  foreach ($fields as $k => &$f) {
    $f['required'] = false;
  }
  return $fields;
}, 9999);

/* 2) Torna TODOS os campos de billing/shipping NÃO obrigatórios e os remove do formulário */
add_filter('woocommerce_checkout_fields', function($fields){
  foreach ($fields as $group => &$set) {
    foreach ($set as $key => &$field) {
      $field['required'] = false;
    }
  }
  // Remove do checkout (não aparecem e não são validados)
  $fields['billing']  = array();
  $fields['shipping'] = array();
  // Remove “notas do pedido”
  unset($fields['order']['order_comments']);
  return $fields;
}, 9999);

/* 3) Desativa o campo de notas do pedido de forma global (fallback) */
add_filter('woocommerce_enable_order_notes_field', '__return_false');



 
/*
Plugin Name: WC – Redireciona para Comprovante
Description: Após finalizar o pedido, redireciona para a página do comprovante customizado.
Author: você
*/

if (!defined('ABSPATH')) exit;

/** AJUSTE O SLUG aqui se sua página tiver outro: */
define('GER_COMPROVANTE_SLUG', 'comprovante'); // slug da página que usa o template page-conprovante.php

/** (A) Descobre a página do comprovante pelo slug ou pelo template */
function ger_comprovante_page_id(){
  // 1) tenta pelo slug
  $p = get_page_by_path(GER_COMPROVANTE_SLUG);
  if ($p && !is_wp_error($p)) return (int) $p->ID;

  // 2) fallback: busca por template file
  $pages = get_pages(array(
    'meta_key'   => '_wp_page_template',
    'meta_value' => 'page-conprovante.php',
    'number'     => 1,
  ));
  if (!empty($pages)) return (int) $pages[0]->ID;

  return 0;
}

/** (B) Monta a URL do comprovante com order_id + key */
function ger_comprovante_url($order){
  $pid = ger_comprovante_page_id();
  if (!$pid || !($order instanceof WC_Order)) return '';
  return add_query_arg(array(
    'order_id' => $order->get_id(),
    'key'      => $order->get_order_key(),
  ), get_permalink($pid));
}

/** (C) Troca a URL “order received” usada pelo checkout (funciona para a maioria dos gateways) */
add_filter('woocommerce_get_checkout_order_received_url', function($url, $order){
  $custom = ger_comprovante_url($order);
  return $custom ?: $url;
}, 9999, 2);

/** (D) Se algum gateway ignorar (ou redirecionar para /order-received/), força o redirecionamento */
add_action('template_redirect', function(){
  if (is_admin()) return;

  // evita loop quando já estamos na página do comprovante
  $pid = ger_comprovante_page_id();
  if ($pid && is_page($pid)) return;

  // intercepta a página padrão de "pedido recebido" e manda pro comprovante
  if (function_exists('is_wc_endpoint_url') && is_wc_endpoint_url('order-received')) {
    $order_id = absint(get_query_var('order-received'));
    if ($order_id) {
      $order = wc_get_order($order_id);
      if ($order) {
        $url = ger_comprovante_url($order);
        if ($url) {
          wp_safe_redirect($url);
          exit;
        }
      }
    }
  }
}, 20);
