<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<?php astra_content_bottom(); ?>
	</div> <!-- ast-container -->
	</div><!-- #content -->
<?php
	astra_content_after();

	astra_footer_before();

	astra_footer();

	astra_footer_after();
?>
	</div><!-- #page -->
<?php
	astra_body_bottom();
	wp_footer();
?>
	</body>


	









	 <script>
jQuery(function($){

  // IDs dos inputs que precisam de spinner
  const campos = ['#nomeRemetente', '#nomeDestinatario', '#buscaProduto'];

  // Função para criar o wrapper + ícone de loading
  function prepararCampo(sel){
    const $inp = $(sel);
    if (!$inp.length) return;

    // Evita duplicar wrapper se já rodou antes
    if (!$inp.parent().hasClass('input-spin-wrap')){
      $inp.wrap('<span class="input-spin-wrap"></span>');
      $inp.after('<span class="spin-ico" aria-hidden="true"></span>');
    }
  }

  // Mostrar/ocultar o spinner do campo manualmente
  function toggleSpinner(sel, show){
    const $inp = $(sel);
    if (!$inp.length) return;
    const $ico = $inp.siblings('.spin-ico');
    if (show) $ico.show(); else $ico.hide();
  }

  // Prepara todos os campos automaticamente
  campos.forEach(prepararCampo);

  // Liga spinner aos eventos do Autocomplete existente
  $(document)
    .on('autocompletesearch', campos.join(','), function(){
      toggleSpinner('#' + this.id, true);
    })
    .on('autocompleteresponse autocompleteclose', campos.join(','), function(){
      toggleSpinner('#' + this.id, false);
    });

  // Fallback extra: detecta chamadas AJAX do seu endpoint
  $(document).ajaxSend(function(_evt, _jqXHR, opts){
    try{
      if (opts && typeof opts.data === 'string' && opts.data.indexOf('action=buscar') !== -1){
        const el = document.activeElement;
        if (el && campos.includes('#' + el.id)){
          toggleSpinner('#' + el.id, true);
        }
      }
    }catch(e){}
  });

  $(document).ajaxComplete(function(_evt, _jqXHR, opts){
    try{
      if (opts && typeof opts.data === 'string' && opts.data.indexOf('action=buscar') !== -1){
        campos.forEach(sel => toggleSpinner(sel, false));
      }
    }catch(e){}
  });

});
</script>
 











<script>
document.addEventListener("DOMContentLoaded", function(){
    const form = document.querySelector("form.mpForm");
    const link = document.querySelector('a.menu-link[href*="nova-passagem"]');

    // 🔹 Quando o usuário enviar o formulário, salva a URL no localStorage
    if(form){
        form.addEventListener("submit", function(e){
            const action = form.getAttribute("action") || "";
            const params = new URLSearchParams(new FormData(form)).toString();
            const finalUrl = action + "?" + params;

            localStorage.setItem("ultima_url_passagem", finalUrl);
        });
    }

    // 🔹 Quando carregar o menu, se já existir última URL salva, troca o href
    if(link){
        const ultimaUrl = localStorage.getItem("ultima_url_passagem");
        if(ultimaUrl){
            link.setAttribute("href", ultimaUrl);
        }
    }
});
</script>



</html>
