  <!-- ===== Spinner: cartão de vidro central (aparece no clique e some só no 100% da página) ===== -->
<style>
  :root { --dt-gap: 12px; --dt-hdr: 60px; }

  #dt-spinner{
    position: fixed;
    top: calc(var(--dt-hdr, 60px) + var(--dt-gap));
    left: 50%;
    transform: translateX(-50%);
    z-index: 2147483647;

    display: flex; align-items: center; gap: 10px;
    padding: 10px 14px; border-radius: 14px;
    background: rgba(255,255,255,.65);
    -webkit-backdrop-filter: blur(6px);
    backdrop-filter: blur(6px);
    box-shadow: 0 8px 24px rgba(0,0,0,.12), 0 2px 8px rgba(0,0,0,.08);

    pointer-events: none; /* cliques passam por baixo */
    opacity: 1; transition: opacity .18s ease, transform .18s ease;
  }
  #dt-spinner.is-fade{ opacity: 0; transform: translate(-50%, -4px); }

  #dt-spinner .spinner{
    width: 28px; height: 28px;
    border: 3px solid rgba(0,0,0,.1);
    border-top: 3px solid #0d6efd;
    border-radius: 50%;
    animation: dtspin 1s linear infinite;
    pointer-events: none;
  }
  #dt-spinner .label{
    font: 600 14px/1.2 system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
    color: #0d3b66;
    letter-spacing: .2px;
    user-select: none; white-space: nowrap;
    pointer-events: none;
  }
  @keyframes dtspin { to { transform: rotate(360deg); } }
</style>

<div id="dt-spinner" aria-hidden="true">
  <div class="spinner"></div>
  <div class="label">Aguarde…</div>
</div>

<script>
(function(){
  const el = document.getElementById('dt-spinner');
  let fadeT = null, closing = false, clickTimer = null;

  /* --- posiciona abaixo do header real --- */
  const HEADER_SEL = 'header, .site-header, #masthead, .navbar, .main-header';
  function setHeaderOffset(){
    try{
      const hdr = document.querySelector(HEADER_SEL);
      const h = hdr ? Math.round(hdr.getBoundingClientRect().height) : 60;
      document.documentElement.style.setProperty('--dt-hdr', h + 'px');
    }catch(e){
      document.documentElement.style.setProperty('--dt-hdr', '60px');
    }
  }
  setHeaderOffset();
  window.addEventListener('resize', setHeaderOffset);
  document.addEventListener('DOMContentLoaded', setHeaderOffset);

  /* --- helpers --- */
  function show(){
    if (!el) return;
    closing = false;
    if (fadeT){ clearTimeout(fadeT); fadeT = null; }
    el.style.display = 'flex';
    el.classList.remove('is-fade');
  }
  function hide(){
    if (!el || closing) return;
    closing = true;
    el.classList.add('is-fade');
    fadeT = setTimeout(()=>{
      el.style.display = 'none';
      el.classList.remove('is-fade');
      closing = false;
    }, 180);
  }

  /* --- aparece no primeiro paint --- */
  show();

  /* --- fecha SOMENTE quando a página estiver 100% carregada --- */
  function closeOnLoadOnce(){
    // aguarda um frame pra garantir pintura final
    requestAnimationFrame(() => setTimeout(hide, 50));
    // remove os listeners para não repetir
    window.removeEventListener('load', closeOnLoadOnce);
    window.removeEventListener('pageshow', onPageShow);
    document.removeEventListener('readystatechange', onRS);
  }
  function onPageShow(e){ if (e.persisted) closeOnLoadOnce(); }     // BFCache
  function onRS(){ if (document.readyState === 'complete') closeOnLoadOnce(); }

  if (document.readyState === 'complete') {
    closeOnLoadOnce(); // caso o script rode depois do load
  } else {
    window.addEventListener('load', closeOnLoadOnce, { once:true });
    window.addEventListener('pageshow', onPageShow, { once:true });
    document.addEventListener('readystatechange', onRS);
  }

  /* === MOSTRAR AO CLICAR (navegação / submit) === */
  function shouldIgnore(elm){
    return !!(elm && (elm.rel?.includes?.('no-spinner') || elm.dataset.spinner === 'off'));
  }

  // Links de navegação
  document.addEventListener('click', function (e) {
    const a = e.target.closest && e.target.closest('a[href]');
    if (!a) return;

    const href = a.getAttribute('href') || '';
    if (shouldIgnore(a) ||
        a.target === '_blank' ||
        href.startsWith('#') ||
        href.startsWith('javascript:') ||
        a.hasAttribute('download')) return;

    // mostra imediatamente
    show();

    // se a navegação for interceptada (SPA), auto-fecha depois de 2.5s
    if (clickTimer) clearTimeout(clickTimer);
    clickTimer = setTimeout(() => {
      if (document.visibilityState === 'visible') hide();
    }, 2500);
  }, true);

  // Envio de formulários
  document.addEventListener('submit', function (e) {
    const form = e.target;
    if (!form) return;
    if (shouldIgnore(form)) return;

    show();
    // se for AJAX/SPA, auto-fecha
    if (clickTimer) clearTimeout(clickTimer);
    clickTimer = setTimeout(() => {
      if (document.visibilityState === 'visible') hide();
    }, 2500);
  }, true);

  // Feedback ao sair da página (casos sem clique)
  window.addEventListener('beforeunload', () => show(), { capture:true });

  // Failsafe (se algum recurso travar o load, não fica preso para sempre)
  setTimeout(closeOnLoadOnce, 180000);

  // API opcional p/ usar em outros scripts
  window.DTSpinner = { show, hide };
})();
</script>
<!-- ===== /Spinner ===== -->




<?php 
/**
 * The header for Astra Theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?><!DOCTYPE html>


    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.12.1/css/dataTables.bootstrap5.min.css"/>



    
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">



    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>



<?php astra_html_before(); ?>
<html <?php language_attributes(); ?>>
<head>
<?php astra_head_top(); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php
if ( apply_filters( 'astra_header_profile_gmpg_link', true ) ) {
	?>
	<link rel="profile" href="https://gmpg.org/xfn/11"> 
	<?php
}
?>
<?php wp_head(); ?>
<?php astra_head_bottom(); ?>
</head>

<body <?php astra_schema_body(); ?> <?php body_class(); ?>>
<?php astra_body_top(); ?>
<?php wp_body_open(); ?>

<a
	class="skip-link screen-reader-text"
	href="#content"
	title="<?php echo esc_attr( astra_default_strings( 'string-header-skip-link', false ) ); ?>">
		<?php echo esc_html( astra_default_strings( 'string-header-skip-link', false ) ); ?>
</a>

<div
<?php
	echo wp_kses_post(
		astra_attr(
			'site',
			array(
				'id'    => 'page',
				'class' => 'hfeed site',
			)
		)
	);
	?>
>
	<?php
	astra_header_before();

	astra_header();

	astra_header_after();

	astra_content_before();
	?>
	<div id="content" class="site-content">
		<div class="ast-container">
		<?php astra_content_top(); ?>



<style>
/* =========================================
   Loading p/ Autocomplete — versão refinada
   - sem flicker (JS cuida do timing)
   - adapta ao tamanho do input
   - dark mode friendly
   - funciona com Bootstrap/Astra
   ========================================= */

/* Variáveis fáceis de ajustar */
:root{
  --spin-size: clamp(14px, 0.9em, 18px);   /* tamanho do spinner */
  --spin-right: .6rem;                     /* distância da borda direita */
  --spin-track: #cfcfcf;                   /* trilha do spinner */
  --spin-head:  #333;                      /* “ponteiro” do spinner */
}
@media (prefers-color-scheme: dark){
  :root{
    --spin-track: #6b7280;
    --spin-head:  #e5e7eb;
  }
}

/* Wrapper que o JS injeta (não precisa alterar seu HTML) */
.input-spin-wrap{
  position: relative;
  display: inline-block;
  width: 100%;
  vertical-align: middle;
}

/* Mantém layout do input; reserva espaço p/ spinner */
.input-spin-wrap > input{
  width: 100%;
  padding-right: calc(var(--spin-size) + 1.2rem) !important;
}

/* O “círculo” do spinner (leve, via border) */
.input-spin-wrap .spin-ico{
  position: absolute;
  top: 50%;
  right: var(--spin-right);
  transform: translateY(-50%);
  width: var(--spin-size);
  height: var(--spin-size);
  border-radius: 50%;
  border: 2px solid var(--spin-track);
  border-top-color: var(--spin-head);
  animation: spin-rot .7s linear infinite;
  display: none; /* JS controla visibilidade */
  opacity: .95;
  pointer-events: none;
}

/* Inputs desabilitados → spinner discreto se aparecer */
.input-spin-wrap > input:disabled ~ .spin-ico{
  opacity: .4;
}

@keyframes spin-rot { to { transform: translateY(-50%) rotate(360deg); } }
@media (prefers-reduced-motion: reduce){
  .input-spin-wrap .spin-ico{ animation-duration: 2.2s; }
}

/* Garante dropdown acima de modais/headers */
.ui-autocomplete{ z-index: 20000 !important; }
</style>


