<?php
/**
 * Template Name: Baixa Rápida de Fretes
 * Description: Página única para dar baixa rápida por Destinatário (sem usar functions.php).
 */
if (!defined('ABSPATH')) exit;
date_default_timezone_set('America/Manaus');

/* ===========================================================
   HELPERS (somente nesta página)
   =========================================================== */

function brq_br_money_to_float($v) {
  if ($v === '' || $v === null) return 0.0;
  if (is_numeric($v)) return floatval($v);
  $v = str_replace(['.', ' '], '', (string)$v);
  $v = str_replace(',', '.', $v);
  return floatval(is_numeric($v) ? $v : 0);
}
function brq_float_to_br($f) { return number_format((float)$f, 2, ',', '.'); }

function brq_calc_devido_page($post_id) {
  $total_produtos = brq_br_money_to_float(get_post_meta($post_id, 'valor_total_produtos', true));
  $total_pago     = brq_br_money_to_float(get_post_meta($post_id, 'valor_total_pago', true));
  $desconto       = brq_br_money_to_float(get_post_meta($post_id, 'valor_desconto', true));

  $tem_devido_meta = get_post_meta($post_id, 'valor_total_devido', true);
  if ($tem_devido_meta !== '') {
    $d = brq_br_money_to_float($tem_devido_meta);
    if ($total_produtos > 0 && ($total_pago > 0 || $desconto > 0)) {
      $d2 = max(0, $total_produtos - $total_pago - $desconto);
      if (abs($d - $d2) > 0.01) $d = $d2;
    }
    return $d;
  }
  if ($total_produtos <= 0) return 0.0;
  return max(0, $total_produtos - $total_pago - $desconto);
}

/* ===========================================================
   "ENDPOINTS" INTERNOS (a própria página responde JSON)
   Chame com fetch para: ?brq_api=search|list|apply
   =========================================================== */

$brq_nonce_action = 'brq_baixa_page_nonce';
$brq_can = current_user_can('edit_posts');

if (isset($_REQUEST['brq_api'])) {
  // Respondemos somente JSON
  header('Content-Type: application/json; charset=utf-8');

  if (!$brq_can) {
    echo wp_json_encode(['success'=>false,'data'=>['message'=>'forbidden']]); exit;
  }
  $nonce_ok = isset($_REQUEST['nonce']) && wp_verify_nonce(sanitize_text_field($_REQUEST['nonce']), $brq_nonce_action);
  if (!$nonce_ok) {
    echo wp_json_encode(['success'=>false,'data'=>['message'=>'invalid nonce']]); exit;
  }

  global $wpdb;
  $api = sanitize_text_field($_REQUEST['brq_api']);

  if ($api === 'search') {
    $q = isset($_REQUEST['q']) ? sanitize_text_field($_REQUEST['q']) : '';
    if (mb_strlen($q) < 3) { echo wp_json_encode(['success'=>true,'data'=>[]]); exit; }

    // nomes distintos por LIKE
    $sql = "
      SELECT DISTINCT pm.meta_value AS nome
      FROM {$wpdb->postmeta} pm
      INNER JOIN {$wpdb->posts} p ON p.ID = pm.post_id
      WHERE p.post_type='encomendas' AND p.post_status IN ('publish','pending','draft')
        AND pm.meta_key='nome_destinatario' AND pm.meta_value LIKE %s
      ORDER BY pm.meta_value ASC
      LIMIT 30
    ";
    $like = '%' . $wpdb->esc_like($q) . '%';
    $nomes = $wpdb->get_col($wpdb->prepare($sql, $like));

    $out = [];
    foreach ($nomes as $nome) {
      // IDs desse destinatário, apenas tipocat=Frete
      $ids = $wpdb->get_col($wpdb->prepare("
        SELECT p.ID
        FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} m1 ON m1.post_id=p.ID AND m1.meta_key='nome_destinatario' AND m1.meta_value=%s
        INNER JOIN {$wpdb->postmeta} m2 ON m2.post_id=p.ID AND m2.meta_key='tipocat' AND m2.meta_value='Frete'
        WHERE p.post_type='encomendas' AND p.post_status IN ('publish','pending','draft')
      ", $nome));

      $qtd = count($ids);
      $aberto = 0.0;
      foreach ($ids as $pid) { $aberto += brq_calc_devido_page($pid); }

      $out[] = [
        'nome'       => $nome,
        'qtd'        => $qtd,
        'aberto'     => $aberto,
        'aberto_fmt' => 'R$ ' . brq_float_to_br($aberto),
      ];
    }

    echo wp_json_encode(['success'=>true,'data'=>$out]); exit;
  }

  if ($api === 'list') {
    $cliente = isset($_REQUEST['cliente']) ? sanitize_text_field($_REQUEST['cliente']) : '';
    $apenas_aberto = !empty($_REQUEST['aberto']);
    if ($cliente === '') { echo wp_json_encode(['success'=>true,'data'=>[]]); exit; }

    $q = new WP_Query([
      'post_type'      => 'encomendas',
      'posts_per_page' => -1,
      'post_status'    => ['publish','pending','draft'],
      'meta_query'     => [
        'relation' => 'AND',
        [ 'key'=>'tipocat', 'value'=>'Frete', 'compare'=>'=' ],
        [ 'key'=>'nome_destinatario', 'value'=>$cliente, 'compare'=>'=' ],
      ],
      'orderby'        => 'date',
      'order'          => 'ASC',
    ]);
    $data = [];
    while ($q->have_posts()) { $q->the_post();
      $id = get_the_ID();
      $faturado = brq_br_money_to_float(get_post_meta($id,'valor_total_produtos',true));
      $pago     = brq_br_money_to_float(get_post_meta($id,'valor_total_pago',true));
      $devido   = brq_calc_devido_page($id);
      if ($apenas_aberto && $devido <= 0.001) continue;

      $data[] = [
        'id'       => $id,
        'emissao'  => get_the_date('Y-m-d', $id),
        'origem'   => get_post_meta($id,'origem',true),
        'destino'  => get_post_meta($id,'destino',true),
        'faturado' => $faturado,
        'pago'     => $pago,
        'devido'   => $devido,
      ];
    }
    wp_reset_postdata();
    echo wp_json_encode(['success'=>true,'data'=>$data]); exit;
  }

  if ($api === 'apply') {
    $items_json = isset($_POST['items']) ? wp_unslash($_POST['items']) : '[]';
    $items = json_decode($items_json, true);
    if (!is_array($items)) { echo wp_json_encode(['success'=>false,'data'=>['message'=>'payload inválido']]); exit; }

    $entregar = !empty($_POST['entregar']);
    $agora    = current_time('Y-m-d H:i');
    $ok = 0;

    foreach ($items as $it) {
      $pid = isset($it['id']) ? intval($it['id']) : 0;
      if (!$pid) continue;

      $add_din = brq_br_money_to_float($it['dinheiro'] ?? 0);
      $add_pix = brq_br_money_to_float($it['pix']      ?? 0);
      $add_deb = brq_br_money_to_float($it['debito']   ?? 0);
      $add_cre = brq_br_money_to_float($it['credito']  ?? 0);
      $add_des = brq_br_money_to_float($it['desconto'] ?? 0);

      $din = brq_br_money_to_float(get_post_meta($pid,'valor_dinheiro',true));
      $pix = brq_br_money_to_float(get_post_meta($pid,'valor_pix',true));
      $deb = brq_br_money_to_float(get_post_meta($pid,'valor_debito',true));
      $cre = brq_br_money_to_float(get_post_meta($pid,'valor_credito',true));
      $des = brq_br_money_to_float(get_post_meta($pid,'valor_desconto',true));
      $tot = brq_br_money_to_float(get_post_meta($pid,'valor_total_pago',true));
      $tot_prod = brq_br_money_to_float(get_post_meta($pid,'valor_total_produtos',true));

      // aplica
      $din += $add_din; $pix += $add_pix; $deb += $add_deb; $cre += $add_cre; $des += $add_des;
      $tot += $add_din + $add_pix + $add_deb + $add_cre;

      $devido = max(0, $tot_prod - $tot - $des);

      update_post_meta($pid,'valor_dinheiro',      brq_float_to_br($din));
      update_post_meta($pid,'valor_pix',           brq_float_to_br($pix));
      update_post_meta($pid,'valor_debito',        brq_float_to_br($deb));
      update_post_meta($pid,'valor_credito',       brq_float_to_br($cre));
      update_post_meta($pid,'valor_desconto',      brq_float_to_br($des));
      update_post_meta($pid,'valor_total_pago',    brq_float_to_br($tot));
      update_post_meta($pid,'valor_total_devido',  brq_float_to_br($devido));
      update_post_meta($pid,'data_pagamento',      $agora);

      if ($entregar && $devido <= 0.001) {
        update_post_meta($pid,'status','Entregue');
      }
      $ok++;
    }

    echo wp_json_encode(['success'=>true,'data'=>['ok'=>$ok]]); exit;
  }

  echo wp_json_encode(['success'=>false,'data'=>['message'=>'unknown api']]); exit;
}

/* ===========================================================
   RENDERIZAÇÃO DA PÁGINA
   =========================================================== */

get_header();
$nonce = wp_create_nonce($brq_nonce_action);
$endpoint_base = add_query_arg('brq_api','', get_permalink());
?>
<style>
  .brq-card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:14px;margin:12px 0}
  .brq-grid{display:grid;gap:10px}
  @media(min-width:992px){.brq-two{grid-template-columns:1.2fr .8fr}}
  .brq-pill{border-radius:999px;border:1px solid #e5e7eb;background:#f8fafc;padding:2px 8px;display:inline-block}
  .brq-table{width:100%;border-collapse:collapse;font-size:14px}
  .brq-table th,.brq-table td{border:1px solid #e5e7eb;padding:6px}
  .brq-table thead th{position:sticky;top:0;background:#f3f4f6;z-index:1}
  .money{font-variant-numeric:tabular-nums}
  .kbd{border:1px solid #d1d5db;border-bottom-width:2px;border-radius:6px;padding:2px 6px;background:#f9fafb}
  .brq-progress{height:8px;background:#e5e7eb;border-radius:6px;overflow:hidden}
  .brq-progress > span{display:block;height:8px;background:#2563eb;width:0%}
  .brq-muted{color:#6b7280}
</style>

<div class="brq-grid brq-two">
  <div class="brq-card">
    <h2 style="margin:0 0 8px">Baixa Rápida de Fretes</h2>
    <div style="display:flex;gap:10px;align-items:end;flex-wrap:wrap">
      <div style="flex:1 1 280px">
        <label class="brq-muted">Destinatário</label>
        <input type="text" id="brq-busca" class="regular-text" placeholder="Digite 3+ letras...">
        <ul id="brq-sug" style="margin:6px 0 0;max-height:220px;overflow:auto;list-style:none;padding:0;display:none;border:1px solid #e5e7eb;border-radius:8px"></ul>
        <div class="brq-muted" style="margin-top:4px">Dica: <span class="kbd">Enter</span> carrega o 1º sugerido.</div>
      </div>
      <label style="display:flex;gap:8px;align-items:center;margin-left:auto">
        <input type="checkbox" id="brq-aberto" checked> Apenas em aberto
      </label>
      <button class="button" id="brq-recarregar" disabled>Recarregar</button>
    </div>

    <div style="display:flex;justify-content:space-between;align-items:center;margin-top:10px">
      <div class="brq-pill"><b>Cliente:</b> <span id="brq-cli">—</span></div>
      <div class="brq-muted">Sel.: <span id="brq-qtd">0</span> • Em aberto: <span id="brq-valor" class="money">R$ 0,00</span></div>
    </div>

    <div style="max-height:56vh;overflow:auto;margin-top:10px">
      <table class="brq-table" id="brq-tab">
        <thead>
          <tr>
            <th style="width:42px"><input type="checkbox" id="brq-all"></th>
            <th style="width:84px">Nº</th>
            <th>Emissão</th>
            <th>Origem</th>
            <th>Destino</th>
            <th class="money">Faturado</th>
            <th class="money">Pago</th>
            <th class="money">Devedor</th>
          </tr>
        </thead>
        <tbody><tr><td colspan="8" style="text-align:center;color:#6b7280">Busque um cliente…</td></tr></tbody>
      </table>
    </div>
  </div>

  <div class="brq-card">
    <h3 style="margin:0 0 8px">Lançar Baixa</h3>
    <div class="brq-grid" style="grid-template-columns:1fr 1fr;gap:8px">
      <label>Dinheiro <input type="text" id="brq-din" class="regular-text" placeholder="0,00"></label>
      <label>Pix      <input type="text" id="brq-pix" class="regular-text" placeholder="0,00"></label>
      <label>Débito   <input type="text" id="brq-deb" class="regular-text" placeholder="0,00"></label>
      <la
