<?php
/* 
Template Name: Página Simples
*/
get_header(); // chama o header.php do tema
?>
 
<?php date_default_timezone_set('America/Manaus');?>



 


 




 <?php
/** Página de Gerenciamento de Fretes (Ajustada) */
date_default_timezone_set('America/Manaus');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<title>Gerenciamento de Fretes</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Ícones -->
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
 
<!-- Bootstrap 5 -->
 
<!-- DataTables 1.13 + extensões -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/select/1.7.0/css/select.bootstrap5.min.css">

<!-- Flatpickr -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<style>
  body { overflow-x: hidden; }
  table.dataTable thead th, table.dataTable tbody td { white-space: nowrap; }
  .filter-container{ display:flex; flex-wrap:wrap; gap:15px; margin-bottom:10px; background:aliceblue; padding:10px; border-radius:10px; }
  .filter-group{ display:flex; flex-direction:column; flex:1; max-width:220px;}
  .filter-group label{ margin-bottom:5px; font-weight:600; color:#0056b3; }
  .ticket { width:100%; background:#f8f9fa; border:2px dashed #000; border-radius:15px; position:relative; padding:6px; display:block; text-align:center; }
  .status-item{ padding:10px 12px; border-radius:0; color:#fff; font-weight:700; display:inline-block; width:100%; }
  .total-faturado{ background:#000; }
  .total-desconto{ background:#007bff; }
  .total-lancados{ background:#0056b3; }
  .total-volumes{ background:#ffc107; color:#000; }
  .total-receber{ background:#dc3545; }
  .status-item2{ display:flex; align-items:center; border:1px solid #ddd; border-radius:0 40px 40px 0; height:68px; padding:0; margin-bottom:20px; background:floralwhite; }
  .status-item2 .icon-background{ background:#fff; display:flex; align-items:center; justify-content:center; height:100%; width:100px; border-right:1px solid #ddd; }
  .icon-size{ width:50px; height:auto; }
  .loading-container{ position:relative; }
  .loading-container .loading{ display:none; position:absolute; inset:0; background:rgba(255,255,255,.8); z-index:10; }
  .loading-container.loading .loading{ display:block; }
  .offcanvas-end { width:50%; }
  .offcanvas-body { padding:0; }
  iframe { width:100%; height:100vh; border:0; margin-top:-30px; }
  .hidden{ display:none; }
  .dt-buttons { margin-bottom:10px; }
  div.dataTables_wrapper div.dataTables_filter{ text-align:right; }
  #hist-status { font-size: .9rem; }
</style>
</head>
<body>

<div class="container-xxl">
  <br>
  <div class="d-flex justify-content-between align-items-center mb-1">
    <h5 class="mb-0"><i class="bi bi-truck display-7"></i> FILTRO DE FRETES</h5>

    <?php
    $current_user = wp_get_current_user();
    if ( ! in_array('grupo_encomenda33333', (array)$current_user->roles, true) ) : ?>
      <button class="btn btn-link text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#orderFilterSection">
        <i class="fas fa-chevron-down"></i> Mostrar Valores
      </button>
    <?php endif; ?>
  </div>

  <div id="orderFilterSection" class="collapse">
    <div class="status-container row g-3">
      <div class="col-md-2 col-sm-6">
        <div class="loading-container" id="total-faturado-container">
          <span class="status-item total-faturado ticket">Totalização <br><span id="total-fretes">R$ 0,00</span></span>
          <div class="loading"></div>
        </div>
      </div>
      <div class="col-md-2 col-sm-6">
        <div class="loading-container" id="total-recebido-container">
          <span class="status-item ticket" style="background:#28a745;">Recebido<br><span id="total-recebido">R$ 0,00</span></span>
          <div class="loading"></div>
        </div>
      </div>
      <div class="col-md-2 col-sm-6">
        <div class="loading-container" id="total-receber-container">
          <span class="status-item total-receber ticket">A Receber <br><span id="total-receber">R$ 0,00</span></span>
          <div class="loading"></div>
        </div>
      </div>
      <div class="col-md-2 col-sm-6">
        <div class="loading-container" id="total-desconto-container">
          <span class="status-item total-desconto ticket">Descontos <br><span id="total-desconto">R$ 0,00</span></span>
          <div class="loading"></div>
        </div>
      </div>
      <div class="col-md-2 col-sm-6">
        <div class="loading-container" id="total-lancados-container">
          <span class="status-item total-lancados ticket">Fretes<br><span id="total-lancados">0</span></span>
          <div class="loading"></div>
        </div>
      </div>
      <div class="col-md-2 col-sm-6">
        <div class="loading-container" id="total-volumes-container">
          <span class="status-item total-volumes ticket">Volumes <br><span id="total-volumes">0</span></span>
          <div class="loading"></div>
        </div>
      </div>

      <div class="col-md-3 col-sm-6">
        <div class="status-item2 loading-container">
          <div class="icon-background" id="total-dinheiro-container">
            <img src="<?php echo esc_url(get_bloginfo('template_directory')); ?>/real.png" class="icon-size" alt="Dinheiro">
          </div>
          <div class="text-container">
            <span>DINHEIRO</span><br><div class="loading"></div>
            <span id="total-dinheiro">R$ 0,00</span>
          </div>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="status-item2 loading-container">
          <div class="icon-background" id="total-pix-container">
            <img src="<?php echo esc_url(get_bloginfo('template_directory')); ?>/pix.png" class="icon-size" alt="Pix">
          </div>
          <div class="text-container">
            <span>PIX</span><br><div class="loading"></div>
            <span id="total-pix">R$ 0,00</span>
          </div>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="status-item2 loading-container">
          <div class="icon-background" id="total-debito-container">
            <img src="<?php echo esc_url(get_bloginfo('template_directory')); ?>/debito.png" class="icon-size" alt="Débito">
          </div>
          <div class="text-container">
            <span>DÉBITO</span><br><div class="loading"></div>
            <span id="total-debito">R$ 0,00</span>
          </div>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="status-item2 loading-container">
          <div class="icon-background" id="total-credito-container">
            <img src="<?php echo esc_url(get_bloginfo('template_directory')); ?>/bandeiras.jpg" class="icon-size" alt="Crédito">
          </div>
          <div class="text-container">
            <span>CRÉDITO</span><br><div class="loading"></div>
            <span id="total-credito">R$ 0,00</span>
          </div>
        </div>
      </div>
    </div><!--/status-container-->
  </div><!--/orderFilterSection-->

  <div class="filter-container">
    <div class="col-md-2 col-lg-2 filter-group">
      <label class="form-label">Data de emissão:</label>
      <div class="loading-container" id="filter-data-container">
        <input type="text" id="filter-data2" class="form-control" placeholder="Período">
        <div class="loading"></div>
      </div>
    </div>

    <div class="col-md-2 col-lg-2 filter-group">
      <label class="form-label">Status PG:</label>
      <select id="filter-status" class="form-select"><option value="">Todos</option></select>
    </div>

    <div class="col-md-2 col-lg-2 filter-group">
      <label class="form-label">Origem:</label>
      <select id="filter-status-pg" class="form-select"><option value="">Todos</option></select>
    </div>

    <div class="col-md-2 col-lg-2 filter-group">
      <label class="form-label">Destino:</label>
      <select id="filter-viagem" class="form-select"><option value="">Todos</option></select>
    </div>

    <div class="col-md-2 col-lg-2 filter-group">
      <label class="form-label">Entregue?</label>
      <select id="filter-destinatario" class="form-select"><option value="">Todos</option></select>
    </div>

    <div class="col-md-2 col-lg-2 filter-group">
      <label class="form-label">Transporte:</label>
      <select id="filter-cidade" class="form-select"><option value="">Todos</option></select>
    </div>
  </div>

  <div class="table-responsive mt-2">
  <?php
// ====== Parâmetros (GET) ======
$data_inicial = isset($_GET['data_inicial_int']) ? sanitize_text_field($_GET['data_inicial_int']) : '';
$data_final   = isset($_GET['data_final_int'])   ? sanitize_text_field($_GET['data_final_int'])   : '';

$hist   = isset($_GET['hist']) && $_GET['hist'] === '1';
$ano    = isset($_GET['ano']) ? (int) $_GET['ano'] : (int) date('Y');
if ($ano < 1900 || $ano > 2100) { $ano = (int) date('Y'); }

$qParam = isset($_GET['q']) ? sanitize_text_field($_GET['q']) : '';
$scope  = isset($_GET['scope']) ? sanitize_key($_GET['scope']) : 'all';

// ====== Período ======
if ($hist) {
  // Ano inteiro (ou o passado em ?ano=)
  $data_inicial_convertida = sprintf('%04d-01-01', $ano);
  $data_final_convertida   = sprintf('%04d-12-31', $ano);
} elseif ($data_inicial && $data_final) {
  $data_inicial_convertida = $data_inicial;
  $data_final_convertida   = $data_final;
} else {
  // Default: últimos 6 dias + hoje
  $data_inicial_convertida = (new DateTime('-0 days'))->format('Y-m-d');
  $data_final_convertida   = (new DateTime('today'))->format('Y-m-d');
}

// ====== Query base ======
$args2 = array(
  'post_type'      => 'encomendas',
  'posts_per_page' => -1,
  'post_status'    => 'publish',
  'date_query'     => array(
    array(
      'after'     => $data_inicial_convertida,
      'before'    => $data_final_convertida,
      'inclusive' => true,
    ),
  ),
  'meta_query'     => array(
    'relation' => 'AND',
    array(
      'key'     => 'tipocat',
      'value'   => 'Frete', // <<< AQUI: Encomenda (não Frete)
      'compare' => '='
    )
  )
);

// ====== Busca por termo (servidor) ======
if ($qParam !== '') {
  // filtros por escopo
  $dest_only = array(
    array('key'=>'nome_destinatario',    'value'=>$qParam, 'compare'=>'LIKE'),
    array('key'=>'contato_destinatario', 'value'=>$qParam, 'compare'=>'LIKE'),
    array('key'=>'cpf_destinatario',     'value'=>$qParam, 'compare'=>'LIKE'),
    array('key'=>'destino',              'value'=>$qParam, 'compare'=>'LIKE'),
  );
  $rem_only = array(
    array('key'=>'nome_remetente',    'value'=>$qParam, 'compare'=>'LIKE'),
    array('key'=>'contato_remetente', 'value'=>$qParam, 'compare'=>'LIKE'),
    array('key'=>'cpf_remetente',     'value'=>$qParam, 'compare'=>'LIKE'),
    array('key'=>'origem',            'value'=>$qParam, 'compare'=>'LIKE'),
  );
  $extras = array(
    array('key'=>'setor',      'value'=>$qParam, 'compare'=>'LIKE'),
    array('key'=>'transporte', 'value'=>$qParam, 'compare'=>'LIKE'),
  );

  if ($scope === 'dest') {
    $args2['meta_query'][] = array_merge(array('relation'=>'OR'), $dest_only);
  } elseif ($scope === 'rem') {
    $args2['meta_query'][] = array_merge(array('relation'=>'OR'), $rem_only);
  } else {
    $args2['meta_query'][] = array_merge(array('relation'=>'OR'), $dest_only, $rem_only, $extras);
  }

  // ====== Busca por ID do post (q numérico) ======
  if (ctype_digit($qParam)) {
    // Para garantir que encontre o ID mesmo fora do período, removemos filtros de data
    $args2 = array(
      'post_type'   => 'encomendas',
      'p'           => (int) $qParam,
      'post_status' => 'publish',
    );
    // Se quiser manter a restrição por tipocat = Encomenda mesmo no ID, descomente:
    // $args2['meta_query'] = array(
    //   array('key'=>'tipocat','value'=>'Encomenda','compare'=>'=')
    // );
  }
}

$the_query = new WP_Query($args2);
?>

    <div class="d-flex align-items-center justify-content-between p-2 border rounded">
      <p class="mb-0">
        Exibindo registros de pagamentos de:
        <?php echo esc_html(date('d/m/Y', strtotime($data_inicial_convertida))); ?>
        até
        <?php echo esc_html(date('d/m/Y', strtotime($data_final_convertida))); ?>
        <?php if ($hist): ?>
          <span class="badge text-bg-info ms-2">Modo histórico (ano inteiro)</span>
        <?php endif; ?>
      </p>
      <div class="d-flex align-items-center gap-3" style="font-size:14px;">
        <span class="d-flex align-items-center"><span style="width:12px;height:12px;background:green;border-radius:50%;display:inline-block;margin-right:5px;"></span>Pago e entregue</span>
        <span class="d-flex align-items-center"><span style="width:12px;height:12px;background:orange;border-radius:50%;display:inline-block;margin-right:5px;"></span>Pago, não entregue</span>
        <span class="d-flex align-items-center"><span style="width:12px;height:12px;background:red;border-radius:50%;display:inline-block;margin-right:5px;"></span>Não pago, não entregue</span>
      </div>
    </div>
    <br>

    <table id="example" class="table table-striped table-bordered align-middle nowrap" style="width:100%; font-size:13px;">
      <thead>
      <tr>
        <th><input type="checkbox" id="select-all"></th>
        <th>Nº</th>
        <th>Emissão</th>
        <th>Oper</th>
        <th>Remetente</th>
        <th>Destinatário</th>
        <th>Vol</th>
        <th>Status PG</th>
        <th>Nota Fiscal</th>
        <th>Tel Destinatário</th>
        <th>CPF do Destinatário</th>
        <th>Origem</th>
        <th>Destino</th>
        <th>Dinheiro</th>
        <th>Pix</th>
        <th>Débito</th>
        <th>Crédito</th>
        <th>Entregue?</th>
        <th>Valor Total de Produtos</th>
        <th>Valor Total Pago</th>
        <th>Valor Total Devido</th>
        <th>Valor do Desconto</th>
        <th>Tel do Remetente</th>
        <th>Produtos Selecionados</th>
        <th>Transporte</th>
        <th>Observações</th>
        <th>Setor</th>
        <th>Ações</th>
      </tr>
      </thead>
      <tbody>
      <?php if ($the_query->have_posts()) : ?>
        <?php
        // Helpers
        function money_to_float($v) {
            $v = trim((string)$v);
            if ($v === '' || $v === null) return 0.0;
            $v = str_replace(['.', ' '], '', $v);
            $v = str_replace(',', '.', $v);
            return (float)$v;
        }
        function br_money($f) { return number_format((float)$f, 2, ',', '.'); }

        if (!function_exists('__decode_produtos_sel')) {
          function __decode_produtos_sel($raw) {
            if (is_array($raw)) return $raw;
            if (is_string($raw) && $raw !== '') {
              $arr = json_decode($raw, true);
              if (json_last_error() === JSON_ERROR_NONE && is_array($arr)) return $arr;
              if (function_exists('wp_unslash')) {
                $arr = json_decode(wp_unslash($raw), true);
                if (json_last_error() === JSON_ERROR_NONE && is_array($arr)) return $arr;
              }
              if (function_exists('maybe_unserialize')) {
                $arr = maybe_unserialize($raw);
                if (is_array($arr)) return $arr;
                if (is_string($arr)) {
                  $j = json_decode($arr, true);
                  if (json_last_error() === JSON_ERROR_NONE && is_array($j)) return $j;
                }
              }
            }
            return [];
          }
        }
        if (!function_exists('__to_float_br')) {
          function __to_float_br($v) {
            if ($v === null || $v === '') return 0.0;
            if (is_numeric($v)) return (float)$v;
            $s = str_replace(['.', ' '], '', (string)$v);
            $s = str_replace(',', '.', $s);
            return is_numeric($s) ? (float)$s : 0.0;
          }
        }

        while ($the_query->have_posts()) : $the_query->the_post();
          $encomenda_id = get_the_ID();
          $data_emissao = get_the_date('d/m/Y');
          $autor_encomenda = get_the_author_meta('display_name', get_post_field('post_author', $encomenda_id));

          // Metas
          $nome_remetente     = get_post_meta($encomenda_id, 'nome_remetente', true);
          if (mb_strlen($nome_remetente) > 40) $nome_remetente = mb_substr($nome_remetente, 0, 30) . '...';

          $dados_nota_fiscal  = get_post_meta($encomenda_id, 'notas_fiscais_json', true);


          $dados_nota_fiscal = get_post_meta($encomenda_id, 'notas_fiscais_json', true);

// Garante que sempre será um array válido
$dados_nota_fiscal = !empty($dados_nota_fiscal) && is_string($dados_nota_fiscal)
    ? json_decode($dados_nota_fiscal, true)
    : [];

// Exemplo: percorrendo as notas
if (!empty($dados_nota_fiscal) && is_array($dados_nota_fiscal)) {
    foreach ($dados_nota_fiscal as $nota) {
        $nota_numero = isset($nota['numero']) ? $nota['numero'] : '';
        $serie  = isset($nota['serie']) ? $nota['serie'] : '';
        $valor  = isset($nota['valor']) ? $nota['valor'] : 0;
        $obs    = isset($nota['obs']) ? $nota['obs'] : '';

       // echo "NF: {$numero} | Série: {$serie} | Valor: R$ " . number_format($valor, 2, ',', '.') . " | Obs: {$obs}<br>";
    }
} 





          $contato_remetente  = get_post_meta($encomenda_id, 'contato_remetente', true);
          $cpf_remetente      = get_post_meta($encomenda_id, 'cpf_remetente', true);
          $nome_destinatario  = get_post_meta($encomenda_id, 'nome_destinatario', true);
          $contato_destinatario = get_post_meta($encomenda_id, 'contato_destinatario', true);
          $cpf_destinatario   = get_post_meta($encomenda_id, 'cpf_destinatario', true);
          $origem             = get_post_meta($encomenda_id, 'origem', true);
          $destino            = get_post_meta($encomenda_id, 'destino', true);
          $tipodepagamento    = get_post_meta($encomenda_id, 'tipoP', true);
          $transporte_id      = get_post_meta($encomenda_id, 'transporte', true);
          $transporte_title   = $transporte_id ? get_the_title($transporte_id) : '';

          $valor_total_produtos = money_to_float(get_post_meta($encomenda_id, 'valor_total_produtos', true));
          $valor_total_pago     = money_to_float(get_post_meta($encomenda_id, 'valor_total_pago', true));
          $valor_total_devido   = money_to_float(get_post_meta($encomenda_id, 'valor_total_devido', true));
          $valor_desconto       = money_to_float(get_post_meta($encomenda_id, 'valor_desconto', true));

          $valor_dinheiro = money_to_float(get_post_meta($encomenda_id, 'valor_dinheiro', true));
          $valor_pix      = money_to_float(get_post_meta($encomenda_id, 'valor_pix', true));
          $valor_debito   = money_to_float(get_post_meta($encomenda_id, 'valor_debito', true));
          $valor_credito  = money_to_float(get_post_meta($encomenda_id, 'valor_credito', true));

          $status          = (string)get_post_meta($encomenda_id, 'status', true); // Recebida / Entregue
          $obs             = get_post_meta($encomenda_id, 'obs', true);
          $setor           = get_post_meta($encomenda_id, 'setor', true);

          // Produtos selecionados
          $produtos_raw = get_post_meta($encomenda_id, 'produtos_selecionados', true);
          $produtos_selecionados = __decode_produtos_sel($produtos_raw);
          $lista_produtos = [];
          $quantidade_total = 0;

          if (is_array($produtos_selecionados)) {
            foreach ($produtos_selecionados as $produto_id => $detalhes) {
              if (!is_array($detalhes)) $detalhes = ['id' => (is_numeric($produto_id) ? (int)$produto_id : 0), 'quantidade' => $detalhes];
              $id = 0;
              foreach (['id','produto_id','product_id','post_id'] as $k) { if (!empty($detalhes[$k])) { $id = (int)$detalhes[$k]; break; } }
              if (!$id && is_numeric($produto_id)) $id = (int)$produto_id;

              $quantidade = isset($detalhes['quantidade']) ? __to_float_br($detalhes['quantidade'])
                         : (isset($detalhes['qtd']) ? __to_float_br($detalhes['qtd'])
                         : (isset($detalhes['qty']) ? __to_float_br($detalhes['qty']) : 0));

              $preco = 0.0;
              if (isset($detalhes['preco']))      $preco = __to_float_br($detalhes['preco']);
              elseif (isset($detalhes['valor']))  $preco = __to_float_br($detalhes['valor']);
              elseif (isset($detalhes['preco_unit'])) $preco = __to_float_br($detalhes['preco_unit']);

              $nome_produto = trim((string)($detalhes['nome'] ?? ''));
              if ($nome_produto === '') {
                $titulo = $id ? get_the_title($id) : '';
                $nome_produto = $titulo ? $titulo : ($id ? 'Produto #'.$id : 'Item');
              }

              $preco_formatado = number_format((float)$preco, 2, ',', '.');
              $lista_produtos[] = "{$quantidade} x {$nome_produto} (R$ {$preco_formatado})";
              $quantidade_total += $quantidade;
            }
          }
          $produtos_html = implode("<br>", $lista_produtos);

          // Classe do botão Destinatário (indicador de situação)
          $classe_btn = 'btn-secondary';
          if ($status === 'Recebida' && $valor_total_pago > 0)      $classe_btn = 'btn-warning';
          elseif ($status === 'Entregue' && $valor_total_pago > 0)  $classe_btn = 'btn-success';
          elseif ($status === 'Recebida' && $valor_total_pago <= 0) $classe_btn = 'btn-danger';

          $link_popup = esc_url(site_url('fencomenda?ent=nao&encomendaid=' . (int)$encomenda_id));
          $popup_js   = "var w=1200,h=700,left=(screen.width-w)/2,top=(screen.height-h)/2;"
                      . "window.open(this.href,'popupWindow','width='+w+',height='+h+',left='+left+',top='+top+',scrollbars=yes,resizable=yes');return false;";
          ?> 
          <tr>
            <td>
              <input type="checkbox" class="select-row hidden" data-id="<?php echo (int)$encomenda_id; ?>">
              <?php if (abs($valor_total_produtos - $valor_total_devido) < 0.01) : ?>
     <button class="dt-button pay-button" 
        data-id="<?php echo (int)$encomenda_id; ?>" 
        style="background:#2196F3;color:#fff;padding:6px 10px;font-size:13px;border-radius:4px;">
  <span><i class="fas fa-credit-card"></i> Pagamento</span>
</button>

              <?php endif; ?>
            </td>

            <td><?php echo (int)$encomenda_id; ?></td>
            <td><?php echo esc_html($data_emissao); ?></td>
            <td><?php echo esc_html($autor_encomenda); ?></td>
            <td><?php echo esc_html($nome_remetente); ?></td>

            <td>
              <?php if (in_array($classe_btn, ['btn-warning','btn-success'], true)) : ?>
                <a href="<?php echo $link_popup; ?>" class="btn btn-sm <?php echo esc_attr($classe_btn); ?> w-100 d-block" onclick="<?php echo esc_attr($popup_js); ?>">
                  <?php echo esc_html($nome_destinatario); ?>
                </a>
              <?php else : ?>
                <span class="btn btn-sm <?php echo esc_attr($classe_btn); ?> w-100 d-block">
                  <?php echo esc_html($nome_destinatario); ?>
                </span>
              <?php endif; ?>
            </td>

            <td><?php echo (float)$quantidade_total; ?></td>
            <td><?php echo ($valor_total_devido > 0 ? 'Falta Pagar' : 'Pago'); ?></td>
            <td><?php echo esc_html($nota_numero); ?></td>

            <td><?php echo esc_html($contato_destinatario); ?></td>
            <td><?php echo esc_html($cpf_destinatario); ?></td>
            <td><?php echo esc_html($origem); ?></td>
            <td><?php echo esc_html($destino); ?></td>

            <td><?php echo br_money($valor_dinheiro); ?></td>
            <td><?php echo br_money($valor_pix); ?></td>
            <td><?php echo br_money($valor_debito); ?></td>
            <td><?php echo br_money($valor_credito); ?></td>

            <td><?php echo ($status === 'Entregue' ? 'Sim' : 'Nao'); ?></td>

            <td>R$ <?php echo br_money($valor_total_produtos); ?></td>
            <td>R$ <?php echo br_money($valor_total_pago); ?></td>
            <td>R$ <?php echo br_money($valor_total_devido); ?></td>
            <td>R$ <?php echo br_money($valor_desconto); ?></td>

            <td><?php echo esc_html($contato_remetente); ?></td>
            <td><?php echo $produtos_html; ?></td>
            <td><?php echo esc_html($transporte_title); ?></td>
            <td><?php echo esc_html($obs); ?></td>
            <td><?php echo esc_html($setor); ?></td>

            <td class="text-nowrap">
              <?php if (abs($valor_total_pago - $valor_total_produtos) < 0.01) : ?>
                <?php if ($status !== 'Entregue') : ?>
                  <a class="btn btn-warning"
                     href="<?php echo esc_url(site_url('fencomenda&ent=ok&envio=destok&encomendaid=' . $encomenda_id)); ?>">
                     Entrega
                  </a>
                <?php endif; ?>
              <?php endif; ?>

              <a class="btn btn-secondary"
                 href="<?php echo esc_url(site_url('fencomenda&ent=nao&encomendaid=' . $encomenda_id)); ?>">
                 Visualizar
              </a>

              <button class="btn btn-primary btn-edit-encomenda" data-id="<?php echo (int)$encomenda_id; ?>">Editar</button>

              <a href="<?php echo esc_url(get_delete_post_link($encomenda_id)); ?>"
                 class="btn btn-danger"
                 onclick="return confirm('Tem certeza que deseja deletar esta encomenda?')">
                 Deletar
              </a>
            </td>
          </tr>
        <?php endwhile; wp_reset_postdata(); ?>
      <?php endif; ?>
      </tbody>
    </table>
  </div><!--/table-responsive-->
</div><!--/container-->

<!-- Offcanvas para detalhes -->
<div class="offcanvas offcanvas-end" id="demo" data-bs-backdrop="true">
  <div class="offcanvas-header">
    <h3 id="frete-title">Frete - </h3>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <div id="loading-spinner" style="display:none;text-align:center;">
      <div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div>
    </div>
    <iframe id="frete-iframe" src="" onload="document.getElementById('loading-spinner').style.display='none'"></iframe>
  </div>
</div>

<!-- Modal Pagamento -->
<div class="modal fade" id="paymentModal" tabindex="-1" aria-hidden="true">
 <div class="modal-dialog">
  <div class="modal-content">
   <div class="modal-header"><h5 class="modal-title">Inserir Valores de Pagamento</h5></div>
   <div class="modal-body">
     <input type="hidden" id="selected-ids">
     <div class="row g-3">
       <div class="col-md-6">
         <label class="form-label">Valor em Dinheiro:</label>
         <input type="text" class="form-control payment-input" name="valor_dinheiro" placeholder="0,00">
       </div>
       <div class="col-md-6">
         <label class="form-label">Valor em Pix:</label>
         <input type="text" class="form-control payment-input" name="valor_pix" placeholder="0,00">
       </div>
       <div class="col-md-6">
         <label class="form-label">Valor em Débito:</label>
         <input type="text" class="form-control payment-input" name="valor_debito" placeholder="0,00">
       </div>
       <div class="col-md-6">
         <label class="form-label">Valor em Crédito:</label>
         <input type="text" class="form-control payment-input" name="valor_credito" placeholder="0,00">
       </div>
     </div>
     <div class="mt-2">
       <label class="form-label">Valor de Desconto:</label>
       <input type="text" class="form-control payment-input" id="discount-amount" name="valor_desconto" placeholder="0,00">
     </div>

     <div class="mt-3">
       <p>Total a pagar: R$ <span id="total-amount">0,00</span></p>
       <p>Total informado: R$ <span id="input-total">0,00</span></p>
       <p>Total faltando: R$ <span id="missing-total">0,00</span></p>
       <p id="error-message" class="text-danger d-none">O total informado não corresponde ao total a pagar!</p>
     </div>
   </div>
   <div class="modal-footer">
     <button type="button" class="btn btn-primary" id="confirm-payment">Confirmar Pagamento</button>
   </div>
  </div>
 </div>
</div>

<!-- Modal Editor WP -->
<div class="modal fade" id="editEncomendaModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable" style="max-width:1100px;">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Editar Encomenda <span id="eem-id" class="text-muted"></span></h5>
        <div class="d-flex gap-2">
          <button type="button" id="eem-fullscreen" class="btn btn-outline-secondary btn-sm" title="Tela cheia">
            <span class="material-icons">fullscreen</span>
          </button>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
        </div>
      </div>
      <div class="modal-body p-0" style="height:75vh;">
        <iframe id="eem-iframe" src="" style="width:100%;height:100%;border:0;"></iframe>
      </div>
      <div class="modal-footer">
        <small id="eem-feedback" class="text-muted me-auto"></small>
        <button type="button" id="eem-save-proxy" class="btn btn-primary">Salvar</button>
        <button type="button" id="eem-refresh" class="btn btn-outline-secondary">Atualizar lista</button>
      </div>
    </div>
  </div>
</div>

<!-- jQuery / Bootstrap / DataTables / Flatpickr / QZ Tray -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/select/1.7.0/js/dataTables.select.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/pt.js"></script>

<script src="<?php echo esc_url(get_template_directory_uri()); ?>/qz/js/qz-tray.js"></script>

<script>
/* ====== Filtro por período (flatpickr) ====== */
(function(){
  // Helpers rápidos
  const normalizeDMY = (s) => {
    s = (s||'').toString().trim();
    if (!s) return '';
    let m = s.match(/^(\d{4})-(\d{1,2})-(\d{1,2})$/); // YYYY-MM-DD -> DD/MM/YYYY
    if (m) return `${m[3].padStart(2,'0')}/${m[2].padStart(2,'0')}/${m[1]}`;
    m = s.match(/^(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{4})$/); // DD/MM/YYYY ou DD-MM-YYYY -> DD/MM/YYYY
    if (m) return `${m[1].padStart(2,'0')}/${m[2].padStart(2,'0')}/${m[3]}`;
    return s;
  };
  const buildLabel = (a,b) => {
    a = normalizeDMY(a); b = normalizeDMY(b);
    return (a && b) ? `${a} a ${b}` : (a || b || '');
  };

  // Lê período da URL (prioriza *_br; depois *_int)
  const usp  = new URLSearchParams(window.location.search);
  const diBr = usp.get('data_inicial_br') || '';
  const dfBr = usp.get('data_final_br')   || '';
  const di   = usp.get('data_inicial_int')|| '';
  const df   = usp.get('data_final_int')  || '';

  // Preenche o input visível ao carregar
  const lbl = buildLabel(diBr || di, dfBr || df);
  const $inp = document.getElementById('filter-data2');
  if ($inp && lbl) $inp.value = lbl;

  // Define defaultDate para o Flatpickr (aceita 'YYYY-MM-DD' ou Date)
  const defaultDate = (di || df) ? [di || df, df || di] : undefined;

  flatpickr("#filter-data2", {
    mode: "range",
    locale: "pt",
    dateFormat: "d/m/Y",
    defaultDate, // <- mantém o range após reload
    onClose: function(selectedDates) {
      if (selectedDates.length === 2) {
        const iniBR = flatpickr.formatDate(selectedDates[0], "d/m/Y");
        const fimBR = flatpickr.formatDate(selectedDates[1], "d/m/Y");
        const ini   = flatpickr.formatDate(selectedDates[0], "Y-m-d");
        const fim   = flatpickr.formatDate(selectedDates[1], "Y-m-d");

        const homeUrl = "<?php echo esc_url( site_url('filtronovofrete') ); ?>";
        const url = new URL(homeUrl);
        url.searchParams.set('data_inicial_br',  iniBR);
        url.searchParams.set('data_final_br',    fimBR);
        url.searchParams.set('data_inicial_int', ini);
        url.searchParams.set('data_final_int',   fim);
        // Ao usar o período, removemos filtros paralelos
        url.searchParams.delete('hist');
        url.searchParams.delete('q');
        url.searchParams.delete('scope');

        window.location.href = url.toString();
      }
    }
  });
})();
</script>


<script>
jQuery(function($){

  /* ====== Mapeamento de colunas ====== */
  const COL = {
    CHECK:0, ID:1, EMISSAO:2, OPER:3, REM:4, DEST:5, VOL:6, STATUSPG:7, NF:8,
    TELDEST:9, CPFDEST:10, ORIGEM:11, DESTINO:12, DIN:13, PIX:14, DEB:15, CRED:16,
    ENTREGUE:17, FATURADO:18, PAGO:19, DEVEDOR:20, DESC:21, TELREM:22, PROD:23,
    TRANSP:24, OBS:25, SETOR:26, ACOES:27
  };

  const ajaxurl    = "<?php echo esc_js(admin_url('admin-ajax.php')); ?>";
  const ajax_nonce = "<?php echo esc_js(wp_create_nonce('atualizar_pagamento_encomenda')); ?>";
  const homeurl    = "<?php echo esc_js(home_url('/')); ?>";

  function intVal(v){
    if (typeof v === 'string') {
      v = v.replace(/[^\d,-]/g,'').replace(/\./g,'').replace(',','.');
      return parseFloat(v) || 0;
    }
    if (typeof v === 'number') return v;
    return 0;
  }
  const fmtBR = n => (Number(n)||0).toLocaleString('pt-BR',{style:'currency',currency:'BRL'});

  /* ====== QZ helpers compartilhados ====== */
/* ====== QZ helpers compartilhados ====== */
function ensureQz(){
  if (window.qz && qz.websocket && qz.websocket.isActive()) return Promise.resolve();
  if (window.qz) return qz.websocket.connect();
  return Promise.reject(new Error('QZ Tray não carregado'));
}

function escolherImpressora(){
  return ensureQz().then(()=>{
    const last = localStorage.getItem('printerComprovanteLast') || '';
    if (last) {
      return last; // usa a impressora salva
    }

    // se não houver salva, pergunta ao usuário
    return qz.printers.find().then(list=>{
      if (!list || !list.length) throw new Error('Nenhuma impressora encontrada pelo QZ Tray');

      const entrada = prompt(
        'Escolha a impressora (digite número ou nome):\n' +
        list.map((n,i)=>`${i+1}. ${n}`).join('\n')
      );

      if (!entrada) throw new Error('Impressora não selecionada');

      const idx  = parseInt(entrada,10);
      const nome = Number.isInteger(idx) && idx>=1 && idx<=list.length
        ? list[idx-1]
        : entrada.trim();

      if (!nome) throw new Error('Seleção inválida');

      // salva para uso futuro
      localStorage.setItem('printerComprovanteLast', nome);

      return nome;
    });
  });
}

/* ===== Preferências de impressão (persistentes) ===== */
function getPrintPrefs(){
  return {
    // Escala global (fallback). Aceita "1x1", "1.5x1.5", "1,5x1,5"
    scale: localStorage.getItem('qz_scale_preset') || '1x1',
    // Escalas por seção (opcionais). Se não setar, usa "scale" global.
    scales: {
      header: localStorage.getItem('qz_scale_header') || '',
      body:   localStorage.getItem('qz_scale_body')   || '',
      totals: localStorage.getItem('qz_scale_totals') || '',
      footer: localStorage.getItem('qz_scale_footer') || '',
    },
    // Estilo
    bold:  (localStorage.getItem('qz_bold')  ?? '1') !== '0', // negrito no corpo
    ds:    (localStorage.getItem('qz_ds')    ?? '1') !== '0', // double-strike
    fontA: (localStorage.getItem('qz_fonta') ?? '1') !== '0', // Fonte A (maior)
    // Larguras de colunas (override)
    widths: {
      qtd : +(localStorage.getItem('qz_qtd_w')  || 3),
      money: +(localStorage.getItem('qz_money_w')|| 8),
      desc: +(localStorage.getItem('qz_desc_w') || 0), // 0=auto
    }
  };
}
function setScalePreset(preset){ localStorage.setItem('qz_scale_preset', String(preset)); }
function setSectionScale(section, preset){
  const key = {header:'qz_scale_header', body:'qz_scale_body', totals:'qz_scale_totals', footer:'qz_scale_footer'}[section];
  if (key) localStorage.setItem(key, String(preset||''));
}
function setWidths({qtd, money, desc}={}){
  if (qtd   != null) localStorage.setItem('qz_qtd_w', String(qtd));
  if (money != null) localStorage.setItem('qz_money_w', String(money));
  if (desc  != null) localStorage.setItem('qz_desc_w', String(desc));
}

/* ============= Textos (títulos, rótulos, rodapé) ============= */
function getPrintTexts(){
  // headerLines: array de linhas do cabeçalho (centralizado)
  let headerLines = [];
  try { headerLines = JSON.parse(localStorage.getItem('qz_header_lines')||'[]')||[]; } catch(e){}
  if (!headerLines.length){
    headerLines = [
      'F/B LEAO DE JUDA X',
      'Torres e Lacet - Navegacao da Amazonia',
      'CNPJ 84.110.649/0001-34',
      '(92) 99977-4021',
      'Manaus-AM'
    ];
  }
  // labels dos cabeçalhos de coluna
  let labels = { qtd:'Qtd', item:'Item', unit:'Un', total:'Tot' };
  try { labels = Object.assign(labels, JSON.parse(localStorage.getItem('qz_labels')||'{}')||{}); } catch(e){}

  const totalsTitle = localStorage.getItem('qz_totals_title') || 'TOTAL';
  const dueLabel    = localStorage.getItem('qz_due_label')    || 'Devido';
  const paidLabel   = localStorage.getItem('qz_paid_label')   || 'Pago';
  const volumesLabel= localStorage.getItem('qz_vol_label')    || 'Volumes';

  let footerLines = [];
  try { footerLines = JSON.parse(localStorage.getItem('qz_footer_lines')||'[]')||[]; } catch(e){}
  return { headerLines, labels, totalsTitle, dueLabel, paidLabel, volumesLabel, footerLines };
}
function setPrintText(key, value){
  // key: 'headerLines' (array), 'labels'(obj), 'totalsTitle','dueLabel','paidLabel','volumesLabel','footerLines'(array)
  const map = {
    headerLines:     'qz_header_lines',
    labels:          'qz_labels',
    totalsTitle:     'qz_totals_title',
    dueLabel:        'qz_due_label',
    paidLabel:       'qz_paid_label',
    volumesLabel:    'qz_vol_label',
    footerLines:     'qz_footer_lines'
  };
  const storageKey = map[key];
  if (!storageKey) return;

  if (Array.isArray(value) || typeof value === 'object'){
    localStorage.setItem(storageKey, JSON.stringify(value));
  } else {
    localStorage.setItem(storageKey, String(value));
  }
}

/* ================== AJUSTE FINO DE ESCALA (decimais) ================== */
function clamp(n, a, b){ return Math.max(a, Math.min(b, n)); }
/* Aceita "1x1", "1.5x1.5", "1,5x1,5" — retorna parte inteira (iw/ih) e fracionária (fw/fh) */
function parsePresetFloat(preset){
  const s = String(preset||'1x1').replace(',', '.');
  const m = s.match(/^(\d+(?:\.\d+)?)x(\d+(?:\.\d+)?)$/);
  let w = m ? parseFloat(m[1]) : 1;
  let h = m ? parseFloat(m[2]) : 1;
  w = clamp(w, 1, 8);  h = clamp(h, 1, 8);
  const iw = Math.floor(w), ih = Math.floor(h);
  return { w, h, iw, ih, fw: w - iw, fh: h - ih };
}
/* Comando nativo (inteiro) GS '!' n — aplica 1..8x em largura/altura */
function escposSizeFromPresetFloat(preset){
  const { iw, ih } = parsePresetFloat(preset);
  const GS = '\x1D';
  const n = ((iw - 1) << 4) | (ih - 1);
  return GS + '!' + String.fromCharCode(n);
}
/* Métricas base por fonte (podem ser calibradas via localStorage) */
function getFontMetrics(useFontA){
  const def = useFontA
    ? { charW:12, charH:24, leading:8, cols:42 }   // Font A típico (~42 colunas)
    : { charW: 9, charH:17, leading:8, cols:56 };  // Font B típico (~56 colunas)
  return {
    charW:  +(localStorage.getItem('qz_charw')   || def.charW),
    charH:  +(localStorage.getItem('qz_charh')   || def.charH),
    leading:+(localStorage.getItem('qz_leading') || def.leading),
    cols: def.cols
  };
}
/* Parte fracionária:
   - largura: ESC ' ' n  (espaço entre caracteres)
   - altura : ESC  '3' n (espaçamento de linha) */
function escposFineScale(preset, useFontA){
  const { fw, fh } = parsePresetFloat(preset);
  const { charW, charH, leading } = getFontMetrics(useFontA);
  const ESC = '\x1B';
  let s = '';
  const extraSpace = clamp(Math.round(fw * charW), 0, 255); // 0..255
  s += ESC + ' ' + String.fromCharCode(extraSpace);
  const baseLine  = charH + leading;
  const newLine   = clamp(Math.round(baseLine * (1 + fh)), 0, 255);
  s += ESC + '3' + String.fromCharCode(newLine);
  return s;
}
function escposFineScaleReset(){
  const ESC = '\x1B';
  return ESC + ' ' + '\x00'  /* char spacing = 0 */
       +  ESC + '2';         /* line spacing default */
}
/* Aplica escala (inteira+fracionária) da seção escolhida ou global */
function applyScaleFor(section, prefs, useFontA){
  const preset = (prefs.scales[section] || prefs.scale);
  return escposSizeFromPresetFloat(preset) + escposFineScale(preset, useFontA);
}

/* ====== FALLBACKS (caso não existam no seu projeto) ====== */
if (typeof ensureQz !== 'function'){
  window.ensureQz = function(){
    if (qz.websocket.isActive()) return Promise.resolve();
    return qz.websocket.connect();
  };
}
if (typeof escolherImpressora !== 'function'){
  // Simples: pega a default. Ajuste se quiser mostrar modal.
  window.escolherImpressora = function(){
    return qz.printers.getDefault();
  };
}
/* ============================ Função principal ============================ */
function printComprovantePorDestinatario(idsOpt){
  const prefs = getPrintPrefs();
  const texts = getPrintTexts();

  const ESC='\x1B', GS='\x1D';
  const init=ESC+'@', align=n=>ESC+'a'+String.fromCharCode(n);
  const boldOn=ESC+'E'+'\x01', boldOff=ESC+'E'+'\x00';
  const dsOn = ESC+'G'+'\x01', dsOff = ESC+'G'+'\x00';
  const fontA = ESC+'M'+'\x00';
  const fontB = ESC+'M'+'\x01';
  const codepagePT = ESC+'t'+'\x03'; // CP860

  const useFontA = !!prefs.fontA;
  const METRICS  = getFontMetrics(useFontA);

  // ===== Helper: espaçamento de linha (n em dots, padrão 24) =====
  const setLineSpacing = (n) => ESC + '3' + String.fromCharCode(n);

  // ===== Helpers de layout =====
  const parseW = (section) => {
    const preset = (prefs.scales?.[section] || prefs.scale || '1x1');
    const pf = parsePresetFloat(preset);
    return Math.max(1, pf.w || 1);
  };
  const colsFor = (section) => Math.max(20, Math.floor(METRICS.cols / parseW(section)));
  const lineFor = (section, ch='-') => ch.repeat(colsFor(section));
  const fitFor  = (section, str) => {
    const width = colsFor(section);
    str = String(str || '');
    return (str.length > width) ? str.substring(0, width) : str;
  };

  // ===== DataTables: seleciona linhas =====
  const idsSet = idsOpt && idsOpt.length ? new Set(idsOpt.map(String)) : null;
  const api = $('#example').DataTable();
  const COL = window.COL || {
    CHECK:0, ID:1, EMISSAO:2, OPER:3, REM:4, DEST:5, VOL:6, STATUSPG:7, NF:8,
    TELDEST:9, CPFDEST:10, ORIGEM:11, DESTINO:12, DIN:13, PIX:14, DEB:15, CRED:16,
    ENTREGUE:17, FATURADO:18, PAGO:19, DEVEDOR:20, DESC:21, TELREM:22, PROD:23,
    TRANSP:24, OBS:25, SETOR:26, ACOES:27
  };
  const rows = [];
  api.rows({search:'applied'}).every(function(){
    const d = this.data();
    if (!idsSet || idsSet.has(String(d[COL.ID]))) rows.push(d);
  });
  if (!rows.length){ alert('Nada para imprimir.'); return; }

  // ===== Agrupa por destinatário =====
  const grupos = {};
  rows.forEach(r=>{
    const dest = $('<div>').html(r[COL.DEST]).text().trim();
    (grupos[dest] ||= []).push(r);
  });

  // ===== Larguras =====
  const wBody = parseW('body');
  const BASE_COLS = METRICS.cols;
  const COLS_BODY = Math.max(20, Math.floor(BASE_COLS / wBody));
  const LINE = {
    header: lineFor('header', '-'),
    body:   lineFor('body',   '-'),
    totals: lineFor('totals', '-'),
    footer: lineFor('footer', '-'),
  };
  const QTD_W   = Math.max(1,  (prefs.widths?.qtd   | 0) || 3);
  const MONEY_W = Math.max(6,  (prefs.widths?.money | 0) || 8);
  const calcDescW = () => {
    const reservado = (QTD_W + 1 + 1 + 2 + MONEY_W + 1 + 2 + MONEY_W);
    const auto = Math.max(10, COLS_BODY - reservado);
    const cfg  = (prefs.widths?.desc | 0);
    return Math.max(8, cfg || Math.min(30, auto));
  };
  const DESC_W = calcDescW();

  // ===== Helpers de número e data =====
  const brToFloat = s => parseFloat(String(s||'').replace(/\./g,'').replace(',','.')) || 0;
  const formatBR  = n => Number(n||0).toLocaleString('pt-BR',{minimumFractionDigits:2,maximumFractionDigits:2});
  const hoje      = new Date().toLocaleDateString('pt-BR');

  const parseBRDate = (txt) => {
    // aceita dd/mm/aaaa
    const m = String(txt||'').trim().match(/^(\d{2})\/(\d{2})\/(\d{4})$/);
    if (!m) return null;
    const [_, d, mo, y] = m;
    const dt = new Date(Number(y), Number(mo)-1, Number(d));
    return isNaN(dt) ? null : dt;
  };
  const fmtBRDate = (dt) => {
    if (!(dt instanceof Date) || isNaN(dt)) return '';
    return dt.toLocaleDateString('pt-BR');
  };

  // ===== Monta slips (um por destinatário) =====
  const slips = Object.entries(grupos).map(([dest, fretes])=>{
    let totalDevido=0, totalPago=0, volumesCli=0;
    let s = '';

    // --- Coleta datas de emissão do grupo (min/max ou única)
    const datas = fretes
      .map(r => $('<div>').html(r[COL.EMISSAO]).text().trim())
      .filter(Boolean);
    const datesParsed = datas.map(parseBRDate).filter(Boolean);
    let dataEmissaoOut = '';
    if (datesParsed.length) {
      const minDt = new Date(Math.min.apply(null, datesParsed));
      const maxDt = new Date(Math.max.apply(null, datesParsed));
      dataEmissaoOut = (minDt.getTime() === maxDt.getTime())
        ? fmtBRDate(minDt)
        : `${fmtBRDate(minDt)} a ${fmtBRDate(maxDt)}`;
    } else {
      // fallback para hoje se não houver data na tabela
      dataEmissaoOut = hoje;
    }

    // ===== Reset inicial + fonte =====
    s += init + codepagePT + (useFontA ? fontA : fontB);
    if (prefs.ds) s += dsOn;

    // ===== Cabeçalho =====
    s += applyScaleFor('header', prefs, useFontA);
    s += setLineSpacing(75); // espaçamento maior no cabeçalho
    s += align(1) + boldOn;
    (texts.headerLines||[]).forEach(lineHdr => { s += fitFor('header', lineHdr) + '\n'; });
    s += boldOff + fitFor('header', LINE.header) + '\n' + align(0);
    s += fitFor('header', `DEST: ${dest}`) + '\n';
    s += fitFor('header', `Data: ${dataEmissaoOut}`) + '\n';
    //s += fitFor('header', `Impresso em: ${hoje}`) + '\n';
    s += fitFor('header', LINE.header) + '\n';

    // ===== Corpo =====
    s += applyScaleFor('body', prefs, useFontA);
    s += setLineSpacing(75); // ajuste fino para itens

    fretes.forEach(r=>{
      const freteId = r[COL.ID] || '------';
      const itensH  = String(r[COL.PROD] || '');
      const linhas  = itensH.split(/<br\s*\/?>/i).filter(t=>t.trim());
      const remet   = $('<div>').html(r[COL.REM]).text().trim();
      const devido  = brToFloat( ($('<div>').html(r[COL.DEVEDOR]).text().match(/([\d\.,]+)/) || [0,'0,00'])[1] );
      const pago    = brToFloat( ($('<div>').html(r[COL.PAGO]).text().match(/([\d\.,]+)\b/)    || [0,'0,00'])[1] );

      s += boldOn + fitFor('header', `Rem: ${remet}`) + '\n' + boldOff;
      if (prefs.bold) s += boldOn;
      s += fitFor('body', `Frete: ${freteId}`) + '\n';
      if (prefs.bold) s += boldOff;

      // Cabeçalho dos itens
      const L = texts.labels || {};
      const hdr =
        (L.qtd||'Qtd').padEnd(QTD_W,' ') + ' ' +
        (L.item||'Item').padEnd(DESC_W,' ') + ' ' +
        (L.unit||'Unidade').padStart(2+MONEY_W,' ') + ' ' +
        (L.total||'Total').padStart(2+MONEY_W,' ');
      s += fitFor('body', hdr) + '\n' + fitFor('body', LINE.body) + '\n';

      linhas.forEach(l=>{
        const m = l.match(/(\d+(?:[\.,]\d+)?)\s*x\s+(.+?)\s+\(R\$\s?([\d\.,]+)\)/i);
        if (!m) return;
        const [, qtdStr, desc, valStr] = m;
        const qtd   = brToFloat(qtdStr);
        const unit  = brToFloat(valStr);
        const tot   = qtd * unit;

        // formatação com largura fixa
        const qtdOut  = qtdStr.toString().padStart(QTD_W);
        const descOut = (desc + ' '.repeat(DESC_W)).substring(0, DESC_W);
        const unitOut = formatBR(unit).padStart(MONEY_W);
        const totOut  = formatBR(tot).padStart(MONEY_W);

        const row =
          `${qtdOut} ` +
          `${descOut} ` +
          `R$${unitOut} ` +
          `R$${totOut}`;

        s += fitFor('body', row) + '\n';
        volumesCli += qtd;
      });

      s += fitFor('body', LINE.body) + '\n';
      totalDevido += devido;
      totalPago   += pago;
    });

    // ===== Totais =====
    s += applyScaleFor('totals', prefs, useFontA);
    s += setLineSpacing(75); // totals um pouco mais solto
    const saldo = totalDevido - totalPago;
    s += boldOn + fitFor('totals', (texts.totalsTitle||'TOTAL')) + '\n' + boldOff;
    s += fitFor('totals', `${texts.dueLabel||'Devido'}:  R$ ${formatBR(totalDevido)}`) + '\n';
    s += fitFor('totals', `${texts.paidLabel||'Pago'}: R$ ${formatBR(totalPago)}`) + '\n';
    s += fitFor('totals', `${texts.balanceLabel||'Saldo'}: R$ ${formatBR(saldo)}`) + '\n';
    s += fitFor('totals', `${texts.volumesLabel||'Volumes'}: ${volumesCli}`) + '\n';
    s += fitFor('totals', LINE.totals) + '\n';

    // ===== Rodapé =====
    s += applyScaleFor('footer', prefs, useFontA);
    s += setLineSpacing(40); // volta pro normal
    if (texts.footerLines && texts.footerLines.length){
      s += align(1);
      texts.footerLines.forEach(fl => { s += fitFor('footer', fl) + '\n'; });
      s += align(0);
    }

    // ===== Final =====
    if (prefs.ds) s += dsOff;
    s += escposFineScaleReset();
    s += ESC+'d'+'\x04' + GS+'V'+'\x00';
    return s;
  });

  // ===== Envia pro QZ Tray =====
  ensureQz()
    .then(escolherImpressora)
    .then(nome => qz.configs.create(nome, { encoding:'CP860' }))
    .then(cfg => qz.print(cfg, [{ type:'raw', format:'plain', data: slips.join('') }]))
    .catch(err => alert('QZ Tray: ' + err));
}


/* ======================= EXEMPLOS DE USO ======================= */
// Escala global (fallback). Para 1.5x1.5 no recibo inteiro:
setScalePreset("1x1");

// Escalas por seção (opcionais)
setSectionScale('header', '2x1.8');
setSectionScale('body',   '1x1');
setSectionScale('totals', '2x1.8');
setSectionScale('footer', '1x1');

// Textos
setPrintText('headerLines', [
  'F/B LEAO DE JUDA X',
  '84.110.649/0001-34',
  '(92) 99977-4021'
]);
setPrintText('labels', {qtd:'Qtd', item:'Item', unit:'Unidade', total:'Total'});
setPrintText('totalsTitle','TOTAL');
setPrintText('dueLabel','Devido');
setPrintText('paidLabel','Pago');
setPrintText('balanceLabel','Saldo');
setPrintText('volumesLabel','Volumes');
setPrintText('footerLines',['Obrigado pela preferência!']);

// Larguras (pode ajustar). Se aumentar escala do "body", reduza desc:
setWidths({qtd:3, money:6, desc:18});







  // Disponibiliza no escopo
  window.printComprovantePorDestinatario = printComprovantePorDestinatario;

  /* ====== DataTable ====== */
  const table = $('#example').DataTable({
    order: [[COL.OPER, "asc"]],
    dom: 'Bfrtip',
    responsive: true,
    select: true,
    buttons: [
      {
        text: '<i class="fas fa-credit-card"></i>',
        className: '',
        init: (api,node)=>$(node).attr('id','pay-button').css({background:'#2196F3',color:'#fff'})
      },

      /* ---------- Protocolo de Frete ---------- */
      {
        extend: 'print',
        text: '<i class="fas fa-print"></i> Protocolo',
        exportOptions: { modifier:{ page:'all' } },
        customize: function (win) {
          const api = $('#example').DataTable();
          $(win.document.body).find('h1, footer, .footer-text, table').remove();
          $(win.document.body).css({ fontSize:'13px', margin:'20px' });

          $(win.document.head).append(`
            <style>
              .protocolo-bloco { page-break-inside: avoid; break-inside: avoid; }
              .circulos-bloco { display:inline-flex; gap:12px; margin-bottom:10px; align-items:center; }
              .circulo-id,.circulo-setor{
                display:inline-block; min-width:40px; height:40px; line-height:38px;
                border:2px solid #000; border-radius:50%; text-align:center;
                font-weight:bold; font-size:14px; padding:0 10px; transform:rotate(-2deg);
              }
              .circulo-id{ background:#f2f2f2; }
              .circulo-setor{ background:#d1ecf1; border-color:#17a2b8; color:#0c5460; }
            </style>
          `);

 /* -- CAPTURA FILTROS DO FORM E PARÂMETROS GET -- */
const url = new URLSearchParams(window.location.search);

const dataInicial2 = url.get('data_inicial_br') || $('#filter-data-inicial').val() || 'Início';
const dataFinal2   = url.get('data_final_br')   || $('#filter-data-final').val()   || 'Hoje';
const origem       = $('#filter-status-pg').val()    || 'Todos';
const destino      = $('#filter-viagem').val()       || 'Todos';
const transporte   = $('#filter-cidade').val()       || 'Todos';
const periodo      = $('#filter-data2').val()        || 'Selecionado';

/* -- CABEÇALHO IMPRESSO -- */
const header = `
  <div style="text-align:center; margin-bottom:15px;">
    <h1 style="font-size:20pt;">PROTOCOLO DE FRETE</h1>
    <p style="font-size:14pt;">Exibindo registros de: ${dataInicial2} até ${dataFinal2}</p>
    <p style="font-size:12pt;">
      <strong>Origem:</strong> ${origem} &nbsp;|&nbsp;
      <strong>Destino:</strong> ${destino} &nbsp;|&nbsp;
      <strong>Transporte:</strong> ${transporte}
    </p>
    <hr style="margin-top:10px;">
  </div>
`;


          const dadosOrdenados = api.rows({ search:'applied' }).data().toArray()
            .sort((a,b)=> (parseInt((a[COL.ID]||'').toString().replace(/\D/g,''))||0) -
                          (parseInt((b[COL.ID]||'').toString().replace(/\D/g,''))||0));

          let html = '';
          dadosOrdenados.forEach(d=>{
            const numero    = d[COL.ID] || '';
            const remetente = $('<div>').html(d[COL.REM]).text().trim();
            const destinat  = $('<div>').html(d[COL.DEST]).text().trim();
            const local     = $('<div>').html(d[COL.DESTINO]).text().trim();
            const situacao  = $('<div>').html(d[COL.STATUSPG]).text().trim();
            const produtosH = d[COL.PROD] || '';
            const faturado  = $('<div>').html(d[COL.FATURADO]).text().trim();
            const pago      = $('<div>').html(d[COL.PAGO]).text().trim();
            const desconto  = $('<div>').html(d[COL.DESC]).text().trim();
            const devedor   = $('<div>').html(d[COL.DEVEDOR]).text().trim();
            const setor     = $('<div>').html(d[COL.SETOR]).text().trim();

            let produtosTabela = '';
            (produtosH ? produtosH.split(/<br\s*\/?>/i).filter(x=>x.trim()) : []).forEach(p=>{
              const m = p.match(/(\d+(?:[\.,]\d+)?)\s+x\s+(.+?)\s+\(R\$\s?([\d,\.]+)\)/);
              if (!m) return;
              const qtd   = parseFloat(m[1].replace(',', '.')).toFixed(3);
              const desc  = m[2];
              const unit  = parseFloat(m[3].replace(/\./g,'').replace(',', '.')).toFixed(2);
              const tot   = (parseFloat(qtd)*parseFloat(unit)).toFixed(2);
              produtosTabela += `
                <tr>
                  <td>${desc}</td><td>${qtd}</td><td>R$ ${unit}</td>
                  <td>R$ ${tot}</td><td>${desconto}</td><td>${pago}</td>
                  <td>${faturado}</td><td>${devedor}</td><td>${local}</td>
                </tr>`;
            });
            if (!produtosTabela) return;

            html += `
              <div class="protocolo-bloco" style="border:1px solid #000; padding:15px; margin-bottom:30px;">
                <div style="margin-bottom:10px;">
                  <div class="circulos-bloco">
                    <span class="circulo-id">${numero}</span>
                    <span class="circulo-setor">${setor}</span>
                  </div>
                  <strong>Rem.:</strong> ${remetente}
                  <strong>Dest.:</strong> ${destinat} &nbsp;&nbsp;
                  <strong>Local:</strong> <span style="background:orange; padding:2px 8px;">${local}</span> &nbsp;&nbsp;
                  <strong>Situação:</strong> ${situacao}
                </div>

                <table border="1" style="width:100%; border-collapse:collapse; font-size:12px;">
                  <thead>
                    <tr style="background:#eee;">
                      <th>Descrição</th><th>Qtd</th><th>Valor</th><th>Total</th>
                      <th>Desconto</th><th>Pago</th><th>Nominal</th><th>Devedor</th><th>Local</th>
                    </tr>
                  </thead>
                  <tbody>${produtosTabela}</tbody>
                </table>

                <div style="margin-top:30px;">
                  <strong>RG:</strong> ______________________ &nbsp;&nbsp;
                  <strong>DATA:</strong> ______________________
                  <strong>RECEBIDO:</strong> ________________________________________________________________________________________
                </div>
              </div>`;
          });

          $(win.document.body).html(header + html);
        }
      },

      /* ---------- Listagem de Frete (agrupado por destinatário) ---------- */
      {
        extend: 'print',
        text: '<i class="fas fa-print"></i> Listagem de Frete',
        exportOptions: { modifier:{ page:'all' } },
        customize: function (win) {
          const api = $('#example').DataTable();
          $(win.document.body).find('h1, footer, .footer-text, table').remove().end().css({ fontSize:'20pt', margin:0 });

          const origem     = $('#filter-status-pg').val()    || 'Todos';
          const destino    = $('#filter-viagem').val()       || 'Todos';
          const transporte = $('#filter-cidade').val()       || 'Todos';

          const destMap = new Map();
          api.rows({ search:'applied' }).every(function(){
            const d = this.data();
            const nome = $('<div>').html(d[COL.DEST]).text().trim();
            const vol  = parseInt(d[COL.VOL], 10) || 0;
            destMap.set(nome, (destMap.get(nome)||0) + vol);
          });

          let totalVolumes = 0; destMap.forEach(v=>totalVolumes+=v);

          const header = `
            <div style="text-align:center;margin-bottom:15px;">
              <h1 style="font-size:25pt;margin:0;">Listagem de Fretes (Tabela)</h1>
              <p style="font-size:25pt;margin:4px 0;">Exibindo registros agrupados por destinatário</p>
              <p style="font-size:18pt;margin:2px 0;">
                <strong>Origem:</strong> ${origem} &nbsp;|&nbsp;
                <strong>Destino:</strong> ${destino} &nbsp;|&nbsp;
                <strong>Transporte:</strong> ${transporte} &nbsp;|&nbsp;
                <strong>Total de Volumes:</strong> ${totalVolumes}
              </p>
            </div>`;

          let tbl = `
            <table style="width:100%;border-collapse:collapse;font-size:27pt;table-layout:fixed;">
              <colgroup><col style="width:10%"><col style="width:70%"><col style="width:20%"></colgroup>
              <thead>
                <tr>
                  <th style="border:1px solid #000;padding:4px;text-align:center;">Nº</th>
                  <th style="border:1px solid #000;padding:4px;">Destinatário</th>
                  <th style="border:1px solid #000;padding:4px;text-align:center;">Volumes</th>
                </tr>
              </thead>
              <tbody>`;

          const ordenado = Array.from(destMap.entries())
            .sort((a,b)=> a[0].normalize('NFD').replace(/[\u0300-\u036f]/g,'').toLowerCase()
                       .localeCompare( b[0].normalize('NFD').replace(/[\u0300-\u036f]/g,'').toLowerCase(), 'pt-BR', {sensitivity:'base'} ));

          let i=1;
          ordenado.forEach(([n,v])=>{
            tbl += `
              <tr>
                <td style="border:1px solid #000;padding:4px;text-align:center;">${i++}</td>
                <td style="border:1px solid #000;padding:4px 6px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;">${n}</td>
                <td style="border:1px solid #000;padding:4px;text-align:center;">${v}</td>
              </tr>`;
          });
          tbl += `</tbody></table>`;

          $(win.document.body).prepend(header + tbl);
        }
      },

      /* ---------- Relatório Cobrança ---------- */
      {
        extend : 'print',
        text   : '<i class="fas fa-print"></i> Relatório (COB)',
        title  : '',
        exportOptions : { columns : [COL.ID, COL.DEST, COL.DEVEDOR] },
        customize : function (win) {
          const body  = $(win.document.body);
          body.find('h1.dt-print-title').remove();

          const api   = $('#example').DataTable();
          const dados = api.rows({ search:'applied' }).data().toArray();

          const toFloat = v => parseFloat(String(v||'0').replace(/[^\d,-]/g,'').replace(/\./g,'').replace(',','.'))||0;

        const grupos = {};
dados.forEach(r => {
  const dest = $('<div>').html(r[COL.DEST]).text().trim();
  const dev  = toFloat(r[COL.DEVEDOR]);
  if (!dev) return;

  let idStr = $('<div>').html(r[COL.ID]).text().trim();
  const idNum = parseInt((idStr || '').toString().replace(/\D/g, ''), 10);
  const idVal = Number.isFinite(idNum) ? idNum : idStr || '';

  if (!grupos[dest]) grupos[dest] = { dev: 0, ids: [] };
  grupos[dest].dev += dev;
  if (idVal !== '') grupos[dest].ids.push(idVal);
});

/* remove tabela antiga */
body.find('table').remove();

/* captura parâmetros e filtros */
const url = new URLSearchParams(window.location.search);
const dataInicial = url.get('data_inicial_br') || $('#filter-data-inicial').val() || 'Início';
const dataFinal   = url.get('data_final_br')   || $('#filter-data-final').val()   || 'Hoje';
const origem      = $('#filter-status-pg').val() || 'Todos';
const destino     = $('#filter-viagem').val()    || 'Todos';
const transporte  = $('#filter-cidade').val()    || 'Todos';
const periodo     = `${dataInicial} até ${dataFinal}`;

/* adiciona cabeçalho */
body.prepend(`
  <div style="text-align:center;margin-bottom:6px;">
    <h1 style="margin:0;font-size:22pt;">Relatório P/ Cobrança – FRETE</h1>
    <small style="font-size:12pt;">
      Período: ${periodo} |
      Origem: ${origem} |
      Destino: ${destino} |
      Transporte: ${transporte}
    </small>
  </div>
`);


          let totalDev = 0;

          let html = `
            <table style="width:100%;border-collapse:collapse;font-size:14pt;table-layout:fixed;">
              <colgroup>
                <col style="width:18%">
                <col style="width:32%">
                <col style="width:15%">
                <col style="width:11%">
                <col style="width:11%">
                <col style="width:13%">
              </colgroup>
              <thead>
                <tr>
                  <th>Nº(Fretes)</th>
                  <th>Destinatário</th>
                  <th>Saldo Devedor</th>
                  <th>Desc.</th>
                  <th>Pago</th>
                  <th>Observ.</th>
                </tr>
              </thead>
              <tbody>`;

          Object.entries(grupos)
            .sort(([a],[b]) => a.localeCompare(b, 'pt-BR', { sensitivity:'base' }))
            .forEach(([dest,g])=>{
              totalDev += g.dev;

              const idsOrdenados = g.ids.slice().sort((x,y)=> (parseInt(x,10)||0) - (parseInt(y,10)||0)).join(', ');

              html += `
                <tr>
                  <td style="border:1px solid #000;padding:3px;text-align:center;">${idsOrdenados}</td>
                  <td style="border:1px solid #000;padding:3px;">${dest}</td>
                  <td style="border:1px solid #000;padding:3px;text-align:center;">${fmtBR(g.dev)}</td>
                  <td style="border:1px solid #000;padding:3px;">&nbsp;</td>
                  <td style="border:1px solid #000;padding:3px;">&nbsp;</td>
                  <td style="border:1px solid #000;padding:3px;">&nbsp;</td>
                </tr>`;
            });

          html += `
              <tr style="font-weight:bold;background:#f0f0f0;">
                <td colspan="2" style="border:1px solid #000;padding:3px;text-align:right;">TOTAL GERAL</td>
                <td style="border:1px solid #000;padding:3px;text-align:center;">${fmtBR(totalDev)}</td>
                <td style="border:1px solid #000;padding:3px;">&nbsp;</td>
                <td style="border:1px solid #000;padding:3px;">&nbsp;</td>
                <td style="border:1px solid #000;padding:3px;">&nbsp;</td>
              </tr>
              </tbody>
            </table>`;

          body.append(html);

          $(win.document.head).append(`
            <style>
              @page { size:A4; margin:12mm; }
              body { font-family:Arial,Helvetica,sans-serif; font-size:10pt; }
              table, th, td { border:1px solid #000; }
              th, td { text-align:center; vertical-align:middle; word-wrap:break-word; }
              th:nth-child(2), td:nth-child(2) { text-align:left; }
              h1 { font-size:20pt; margin-bottom:3mm; }
            </style>
          `);
        }
      },

      /* ---------- Comprovante por destinatário (QZ Tray) ---------- */
      {
        text : '<i class="fas fa-print"></i> Comprovante (por Destinatário)',
        action : function () {
          printComprovantePorDestinatario(); // usa a função reutilizável
        }
      }
    ],
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      sInfoEmpty: "Mostrando 0 até 0 de 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sLengthMenu: "_MENU_ resultados por página",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: { sNext: "Próximo", sPrevious: "Anterior", sFirst: "Primeiro", sLast: "Último" },
      oAria: { sSortAscending: ": Ordenar colunas de forma ascendente", sSortDescending: ": Ordenar colunas de forma descendente" },
      buttons: { copyTitle: 'Copiar linhas', copySuccess: { "_":"%d linhas copiadas", "1":"1 linha copiada" } }
    },
    drawCallback: function(){
      const api = this.api();

      // Totais
      const totalReg = api.rows({ search:'applied' }).data().length;
      const totalVolumes = api.column(COL.VOL, { search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);
      const totalFretes  = [COL.PAGO, COL.DEVEDOR].reduce((t,c)=> t + api.column(c,{search:'applied'}).data().reduce((a,b)=>intVal(a)+intVal(b),0), 0);
      const totalReceb   = api.column(COL.PAGO,   { search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);
      const totalArec    = api.column(COL.DEVEDOR,{ search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);
      const totalDesc    = api.column(COL.DESC,   { search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);
      const tDin = api.column(COL.DIN,  { search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);
      const tPix = api.column(COL.PIX,  { search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);
      const tDeb = api.column(COL.DEB,  { search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);
      const tCre = api.column(COL.CRED, { search:'applied' }).data().reduce((a,b)=> intVal(a)+intVal(b), 0);

      $('#total-lancados').text(totalReg);
      $('#total-volumes').text(totalVolumes);
      $('#total-fretes').text(fmtBR(totalFretes));
      $('#total-recebido').text(fmtBR(totalReceb));
      $('#total-receber').text(fmtBR(totalArec));
      $('#total-desconto').text(fmtBR(totalDesc));
      $('#total-dinheiro').text(fmtBR(tDin));
      $('#total-pix').text(fmtBR(tPix));
      $('#total-debito').text(fmtBR(tDeb));
      $('#total-credito').text(fmtBR(tCre));
    }
  });

  /* ====== Escopo de busca + Loader de histórico ====== */
  $('#example_filter').prepend(`
    <div id="search-scope" class="me-2 d-inline-block">
      <label class="me-2"><input type="radio" name="scope" value="all" checked> Tudo</label>
      <label class="me-2"><input type="radio" name="scope" value="dest"> Dest.</label>
      <label class="me-2"><input type="radio" name="scope" value="rem"> Remet.</label>
    </div>
  `);
  $('#example_filter').append(`
    <span id="hist-status" class="ms-2 d-none">
      <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
      <span class="ms-1">Buscando no ano todo…</span>
    </span>
  `);

  const $search = $('#example_filter input[type="search"]');
  function aplicarBusca(txt, scope){
    table.search(''); table.columns().search('');
    if (scope === 'dest') table.column(COL.DEST).search(txt, true, false).draw();
    else if (scope === 'rem') table.column(COL.REM).search(txt, true, false).draw();
    else table.search(txt, true, false).draw();
  }
  function filtrar(){ aplicarBusca($search.val(), $('input[name="scope"]:checked').val()); }

  $search.off('keyup.DT').on('keyup', filtrar);
  $(document).on('change','input[name="scope"]', ()=>{ filtrar(); $search.trigger('focus'); });

  /* ====== Filtros (com persistência) ====== */
  function addColumnFilter(columnIndex, selectId){
    const column = table.column(columnIndex);
    const $sel = $(selectId);
    column.data().unique().sort().each(function(d){
      const txt = $('<div>').html(d).text().trim();
      if (txt) $sel.append(`<option value="${txt}">${txt}</option>`);
    });
    const saved = localStorage.getItem($sel.attr('id'));
    if (saved){ $sel.val(saved); column.search(saved ? '^'+saved+'$' : '', true, false).draw(); }
    $sel.on('change', function(){
      const v = $(this).val();
      localStorage.setItem($sel.attr('id'), v);
      column.search(v ? '^'+v+'$' : '', true, false).draw();
    });
  }
  addColumnFilter(COL.STATUSPG, '#filter-status');
  addColumnFilter(COL.ORIGEM,   '#filter-status-pg');
  addColumnFilter(COL.DESTINO,  '#filter-viagem');
  addColumnFilter(COL.ENTREGUE, '#filter-destinatario');
  addColumnFilter(COL.TRANSP,   '#filter-cidade');

  /* ====== Pagamento (modal) ====== */
  function formatInputMoney(el){
    let v = el.value.replace(/\D/g,'');
    if (!v){ el.value=''; return; }
    v = (parseFloat(v)/100).toFixed(2).replace('.',',').replace(/(\d)(?=(\d{3})+,)/g,'$1.');
    el.value = v;
  }
  function getMoney(str) {
    return parseFloat(String(str || '').replace(/[^\d,-]/g, '').replace(/\./g, '').replace(',', '.')) || 0;
  }

  let selecaoAtual = [];
  function atualizarTotalSelecionado () {
    selecaoAtual = [];
    let totalDevidoSel = 0;

    table.rows({ search: 'applied' }).every(function () {
      const $row = $(this.node());
      const cb   = $row.find('.select-row');
      if (!cb.is(':checked')) return;

      const id = cb.data('id');
      let devido = getMoney($row.find('td').eq(COL.DEVEDOR).text());
      if (devido <= 0) {
        const fat  = getMoney($row.find('td').eq(COL.FATURADO).text());
        const pago = getMoney($row.find('td').eq(COL.PAGO).text());
        devido = Math.max(0, fat - pago);
      }
      selecaoAtual.push({ id, devido });
      totalDevidoSel += devido;
    });

    $('#total-amount').text((Number(totalDevidoSel) || 0).toFixed(2).replace('.', ','));
    $('#selected-ids').val(selecaoAtual.map(x => x.id).join(','));
    atualizarDiferenca();
  }

  function atualizarDiferenca(){
    let pagos = 0;
    $('.payment-input').each(function(){ if (this.name!=='valor_desconto') pagos += getMoney(this.value); });
    const desc  = getMoney($('#discount-amount').val());
    const total = getMoney($('#total-amount').text());
    const diff  = total - pagos - desc;
    const $miss = $('#missing-total');
    $('#input-total').text( (Number(pagos)||0).toFixed(2).replace('.',',') );
    $miss.text( (Number(diff)||0).toFixed(2).replace('.',',') )
         .toggleClass('text-danger', Math.abs(diff)>0.01)
         .toggleClass('text-success', Math.abs(diff)<=0.01);
  }

  $('#select-all').on('click', function(){
    const checked = $(this).prop('checked');
    $('.select-row').prop('checked', checked);
    atualizarTotalSelecionado();
  });
  $(document).on('change','.select-row', atualizarTotalSelecionado);
  $(document).on('input','.payment-input', function(){ formatInputMoney(this); atualizarDiferenca(); });

  $('#pay-button').on('click', function(){
    atualizarTotalSelecionado();
    if (getMoney($('#total-amount').text()) > 0) $('#paymentModal').modal('show');
    else alert('Nenhuma linha válida selecionada.');
  });

  // helper pra pegar número em BR de uma célula (com HTML)
  function moneyFromCell(val){
    const text = $('<div>').html(val).text().trim();
    return parseFloat(text.replace(/[^\d,-]/g,'').replace(/\./g,'').replace(',','.')) || 0;
  }

  // Botão "Pagamento" por linha
  $(document).on('click', '.pay-button', function () {
    const id = String($(this).data('id'));
    let rowData = null;

    table.rows({ search: 'applied' }).every(function () {
      const d = this.data();
      if (String(d[COL.ID]) === id) { rowData = d; return false; }
    });

    if (!rowData) { alert('Linha não encontrada.'); return; }

    const faturado = moneyFromCell(rowData[COL.FATURADO]);
    const pago     = moneyFromCell(rowData[COL.PAGO]);
    let   devido   = moneyFromCell(rowData[COL.DEVEDOR]);
    if (devido <= 0) devido = Math.max(0, faturado - pago);

    $('#selected-ids').val(id);
    $('.payment-input').val('');
    $('#discount-amount').val('');

    const br = v => (v).toFixed(2).replace('.', ',');
    $('#total-amount').text(br(devido));
    $('#input-total').text('0,00');
    $('#missing-total')
      .text(br(devido))
      .removeClass('text-success').addClass('text-danger');

    $('#error-message').addClass('d-none');
    $('#paymentModal').modal('show');
  });

  // ====== CONFIRMAR PAGAMENTO (com impressão automática após reload) ======
  $('#confirm-payment').on('click', function(){
    const ids = $('#selected-ids').val().split(',').filter(Boolean);
    if (!ids.length) return;

    const valores = {
      dinheiro: getMoney($('[name="valor_dinheiro"]').val()),
      pix:      getMoney($('[name="valor_pix"]').val()),
      debito:   getMoney($('[name="valor_debito"]').val()),
      credito:  getMoney($('[name="valor_credito"]').val()),
      desconto: getMoney($('#discount-amount').val())
    };
    const totalPagos = valores.dinheiro + valores.pix + valores.debito + valores.credito;
    const totalSel   = getMoney($('#total-amount').text());

    if (Math.abs((totalPagos + valores.desconto) - totalSel) > 0.01){
      $('#error-message').removeClass('d-none').text('Pagamentos + desconto não conferem com o total selecionado.');
      return;
    }
    $('#error-message').addClass('d-none');

    const partes = ids.length;
    const div = n => (n/partes).toFixed(2);

    const agora = ()=>{
      const d=new Date();
      const dd=String(d.getDate()).padStart(2,'0'), mm=String(d.getMonth()+1).padStart(2,'0'), yy=d.getFullYear();
      const hh=String(d.getHours()).padStart(2,'0'), mi=String(d.getMinutes()).padStart(2,'0');
      return `${dd}-${mm}-${yy} ${hh}:${mi}`;
    };

    // monta as requisições
    const reqs = ids.map(id => $.post(ajaxurl, {
      action: 'atualizar_pagamento_encomenda',
      nonce: ajax_nonce,
      post_ids: id,
      valor_dinheiro: div(valores.dinheiro),
      valor_pix:      div(valores.pix),
      valor_debito:   div(valores.debito),
      valor_credito:  div(valores.credito),
      valor_desconto: div(valores.desconto),
      valor_total_pago: div(totalPagos),
      valor_total_devido: div(totalSel - totalPagos - valores.desconto),
      data_pagamento: agora()
    }));

    // fecha modal para não ficar na frente
    $('#paymentModal').modal('hide');

    Promise.all(reqs)
      .then(resps=>{
        const falha = resps.find(r => !r || r.success === false);
        if (falha) {
          alert('Alguns pagamentos não foram atualizados. Tente novamente.');
          return;
        }
        // guarda IDs para impressão e recarrega a página
        sessionStorage.setItem('printAfterPaymentIds', JSON.stringify(ids));
        location.reload();
      })
      .catch(()=> alert('Falha na requisição AJAX.'));
  });

  /* ====== Editor (iframe) ====== */
  $(document).on('click','.btn-edit-encomenda', function(){
    const id = $(this).data('id');
    $('#eem-id').text('#'+id);
    $('#eem-feedback').text('Carregando editor...');
    const url = "<?php echo esc_url(admin_url('post.php')); ?>" + "?post="+id+"&action=edit";
    $('#eem-iframe').attr('src', url);
    $('#editEncomendaModal').modal('show');
  });
  $('#eem-save-proxy').on('click', function(){
    const win = document.getElementById('eem-iframe').contentWindow;
    if (!win) return;
    const classicPublish = win.document.querySelector('#publish');
    if (classicPublish){ classicPublish.click(); return; }
    const gBtn = win.document.querySelector('.editor-post-publish-button,.editor-post-publish-panel__toggle,button[aria-label="Atualizar"],button[aria-label="Publicar"]');
    if (gBtn){ gBtn.click(); setTimeout(()=>{
      const confirmBtn = win.document.querySelector('.editor-post-publish-button,.editor-post-publish-panel__button,button[aria-label="Atualizar"],button[aria-label="Publicar"]');
      if (confirmBtn) confirmBtn.click();
    }, 350); return; }
    alert('Não encontrei o botão de salvar no editor.');
  });
  $('#eem-refresh').on('click', function(){ location.reload(); });
  $('#eem-fullscreen').on('click', function(){ $('#editEncomendaModal .modal-dialog').toggleClass('modal-fullscreen'); });
  $('#eem-iframe').on('load', function(){
    const win = this.contentWindow, doc = win.document;
    try{
      ['#adminmenumain','#adminmenuwrap','#wpadminbar','#screen-meta-links','#wpfooter','.notice','.update-nag'].forEach(sel=>{
        doc.querySelectorAll(sel).forEach(el=> el.style.display='none');
      });
      const wpcontent = doc.querySelector('#wpcontent'); if (wpcontent) wpcontent.style.marginLeft='0';
      const body = doc.body; if (body){ body.style.paddingTop='0'; body.style.background='#fff'; }
      const classicPublish = doc.querySelector('#publish');
      if (classicPublish){
        const submitDiv = doc.querySelector('#submitdiv');
        if (submitDiv) submitDiv.style.display='';
        classicPublish.style.position='sticky';
        classicPublish.style.top='10px';
        classicPublish.style.zIndex='1000';
        classicPublish.style.boxShadow='0 0 0 3px rgba(13,110,253,.25)';
      }
      const gHeader = doc.querySelector('.edit-post-header,.interface-interface-skeleton__header');
      if (gHeader){
        gHeader.style.position='sticky'; gHeader.style.top='0'; gHeader.style.zIndex='1000';
        gHeader.style.background='#fff'; gHeader.style.borderBottom='1px solid #eee';
      }
      const gBtn = doc.querySelector('.editor-post-publish-button,.editor-post-publish-panel__toggle,button[aria-label="Atualizar"],button[aria-label="Publicar"]');
      if (gBtn) gBtn.style.boxShadow='0 0 0 3px rgba(13,110,253,.25)';

      $('#eem-feedback').text('Editor carregado. Edite e clique em Atualizar.');
      const mo = new win.MutationObserver(()=>{
        const ok = doc.querySelector('.components-snackbar__content,.notice-success,.updated');
        if (ok && /Atualiz|updated|publicad/i.test(ok.textContent||'')) {
          $('#eem-feedback').text('Alterações salvas. Feche o modal e clique em "Atualizar lista".');
        }
      });
      mo.observe(doc.documentElement,{childList:true,subtree:true});
    }catch(e){ console.warn(e); $('#eem-feedback').text(''); }
  });

  /* ====== Enter = BUSCAR NO ANO TODO ====== */
  const adminFiltroURL = "<?php echo esc_url(site_url('filtronovofrete')); ?>";

  // Preenche escopo e termo iniciais vindos da URL
  const initialScope = "<?php echo esc_js($scope); ?>";
  $(`input[name="scope"][value="${initialScope}"]`).prop('checked', true);

  const initialQ = "<?php echo esc_js($qParam); ?>";
  if (initialQ) {
    $search.val(initialQ);
    aplicarBusca(initialQ, initialScope);
  }

  // Ao pressionar Enter na busca, vai para ?hist=1&q=... (ano inteiro) e mostra loader
  $search.on('keydown', function(e){
    if (e.key === 'Enter') {
      e.preventDefault();
      const term  = $search.val().trim();
      if (!term) return;
      const scope = $('input[name="scope"]:checked').val() || 'all';

      $('#hist-status').removeClass('d-none');

      const url = new URL(adminFiltroURL);
      url.searchParams.set('hist', '1');
      url.searchParams.set('q', term);
      url.searchParams.set('scope', scope);
      window.location.href = url.toString();
    }
  });

  /* ====== Auto-impressão após baixa de pagamento ====== */
  try {
    const raw = sessionStorage.getItem('printAfterPaymentIds');
    if (raw) {
      sessionStorage.removeItem('printAfterPaymentIds');
      const ids = JSON.parse(raw);
      // aguarda DataTable terminar o layout
      setTimeout(()=> printComprovantePorDestinatario(ids), 500);
    }
  } catch(_) {}

}); // fim jQuery
</script>

</body>
</html>

<?php
get_footer(); // Chama o footer.php do tema
