<html>
 
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BARCO TV</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="shortcut icon" type="image/x-icon" href="https://i.ibb.co/37fVLxB/f4027915ec9335046755d489a14472f2.png">
    <link rel="stylesheet" href="data/css/darkmode.min.css">
    <script src="https://cdn.jsdelivr.net/npm/lazysizes@5.3.2/lazysizes.min.js"></script>
</head>


<?php




date_default_timezone_set('America/Manaus');



include 'top.php';




ini_set('memory_limit', '512M');  
 


$filePath = 'data/lista.m3u';  

 
if (!file_exists($filePath)) {
    die("O arquivo $filePath não foi encontrado.");
}

 
$m3u8Content = file_get_contents($filePath);
$lines = explode("\n", $m3u8Content);

 
$liveChannels = [];
$movies = [];

$currentEntry = [];

 
$filtros = [''];

foreach ($lines as $line) {
 
    if (strpos($line, '#EXTINF:') === 0) {
        // Extração de metadados da entrada atual
        preg_match('/tvg-name="([^"]+)"[^,]*,(.*)/', $line, $nameMatches);
        preg_match('/tvg-logo="([^"]+)"/', $line, $logoMatches);
        preg_match('/group-title="([^"]*)"/', $line, $groupMatches);
        
 
        $currentEntry = [
            'name' => $nameMatches[1] ?? '',
            'title' => $nameMatches[2] ?? '',
            'logo' => $logoMatches[1] ?? '',
            'group' => $groupMatches[1] ?? '',
            'url' => ''  
        ];
    } elseif (filter_var(trim($line), FILTER_VALIDATE_URL)) {
 
        $currentEntry['url'] = trim($line);

 
        if (substr($currentEntry['url'], -4) === '.mp4') {
            $movies[] = $currentEntry;
        } else {
 
            $includeChannel = false;
            if (in_array('', $filtros)) {
                $includeChannel = true;
            } else {
                foreach ($filtros as $filtro) {
                    if (stripos($currentEntry['name'], $filtro) !== false) {
                        $includeChannel = true;
                        break;
                    }
                }
            }
            if ($includeChannel) {
                $liveChannels[] = $currentEntry;
            }
        }

 
        $currentEntry = [];
    }
}

 
function printEntries($entries) {
    foreach ($entries as $entry) {
        echo "Nome: " . $entry['name'] . "<br>";
        echo "Título: " . $entry['title'] . "<br>";
        echo "Logo: " . $entry['logo'] . "<br>";
        echo "Grupo: " . $entry['group'] . "<br>";
        echo "URL: " . $entry['url'] . "<br><br>";
    }
}


// Exemplo de como chamar a funo para exibir filmes
// Limitar a quantidade de filmes exibidos a 100
$limitedMovies = array_slice($movies, 0, 100);
 
$limitedTv = array_slice($liveChannels, 0, 500);



?>



<body style="
    background-color: #000;
">










  <br>

<!-- Conteúdo principal -->
<div id="content" class="container">
    
    <!-- Seção CANAIS AO VIVO -->
    <h3 class="section-title">CANAIS AO VIVO </h3> 
    <hr>
    <div id="live-channels" class="row">
        <!-- PHP para listar os canais ao vivo -->
        <?php foreach ($limitedTv as $channel): ?>
        <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-4">
            <a href="play.php?c=<?= htmlspecialchars($channel['url']) ?>&p=<?= htmlspecialchars($channel['logo']) ?>" class="card">
                <img class="lazyload card-img-top" data-src="<?= htmlspecialchars($channel['logo']) ?>" alt="Logo">
                <div class="card-body">
                    <p class="card-text"><?= htmlspecialchars(mb_substr($channel['name'], 0, 23)) ?></p>
                </div>
            </a>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- Seção FILMES -->
    <h3 class="section-title mt-5">FILMES</h3> <hr>
    <div id="movies" class="row">
        <!-- PHP para listar os filmes -->
		<?php foreach ($limitedMovies as $movie): ?>
        <div class="col-6 col-sm-4 col-md-3 col-lg-2 mb-4">
            <a href="play.php?c=<?= htmlspecialchars($movie['url']) ?>&p=<?= htmlspecialchars($movie['logo']) ?>" class="card">
                <img class="lazyload card-img-top" data-src="<?= htmlspecialchars($movie['logo']) ?>" alt="Logo">
                <div class="card-body">
                    <p class="card-text"><?= htmlspecialchars(mb_substr($movie['name'], 0, 23)) ?></p>
                </div>
            </a>
        </div>
        <?php endforeach; ?>
    </div>

</div>
 
 




	<!-- Bootstrap JS, Popper.js, e jQuery -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.6/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<style>
 


/* Estilo para a linha horizontal */
hr {
    border: none;
    height: 2px;
    background-color: #eee; /* ou outra cor que combine com seu esquema */
    margin-top: 2rem;
}

.card-img, .card-img-top {
    border-top-left-radius: d;
    border-top-right-radius: dd;
    padding: 14px;
}


.card-body {
 
    height: 60px;
}






.focused {
    outline: 2px solid #ffffff ; /* Exemplo simples para destacar o elemento em foco */

border: 3px solid #ffffff !important;
    margin: 5px 5px 3px 5px;
    -webkit-box-shadow: #ffffff 0px 0px 18px 6px;

}

 

.card-img, .card-img-top, .card-img-bottom {
    -ms-flex-negative: 0;
    flex-shrink: 0;
    width: 100%;
 
}



</style>





 

<script>
document.addEventListener('DOMContentLoaded', (event) => {
    let elementosFocaveis = document.querySelectorAll('.card');
    let focoAtual = 0;

    function atualizarFoco(novoFoco) {
        if (elementosFocaveis[focoAtual]) {
            elementosFocaveis[focoAtual].classList.remove('focused');
            elementosFocaveis[focoAtual].setAttribute('tabindex', '-1');
        }
        focoAtual = novoFoco;
        if (elementosFocaveis[focoAtual]) {
            elementosFocaveis[focoAtual].classList.add('focused');
            elementosFocaveis[focoAtual].setAttribute('tabindex', '0');
            elementosFocaveis[focoAtual].focus();
            elementosFocaveis[focoAtual].scrollIntoView({
                behavior: 'smooth',
                block: 'nearest',
            });
        }
    }

    if (elementosFocaveis.length > 0) {
        atualizarFoco(0); // Inicializa o foco no primeiro elemento
    }

    document.addEventListener('keydown', (e) => {
        let novoFoco = focoAtual;
        const focoAtualRect = elementosFocaveis[focoAtual].getBoundingClientRect();

        if (e.key === 'ArrowDown' || e.key === 'ArrowUp') {
            let candidato = null;
            let distanciaMinima = Infinity;
            
            elementosFocaveis.forEach((elemento, index) => {
                if (index !== focoAtual) {
                    const rect = elemento.getBoundingClientRect();
                    const estaNaMesmaColuna = rect.left === focoAtualRect.left;

                    if (estaNaMesmaColuna) {
                        let adequado = (e.key === 'ArrowDown' && rect.top > focoAtualRect.top) ||
                                       (e.key === 'ArrowUp' && rect.top < focoAtualRect.top);

                        if (adequado) {
                            const distanciaVertical = Math.abs(rect.top - focoAtualRect.top);
                            if (distanciaVertical < distanciaMinima) {
                                distanciaMinima = distanciaVertical;
                                candidato = index;
                            }
                        }
                    }
                }
            });

            if (candidato !== null) {
                novoFoco = candidato;
            }
        } else if (e.key === 'ArrowLeft' && focoAtual > 0) {
            novoFoco = focoAtual - 1;
        } else if (e.key === 'ArrowRight' && focoAtual < elementosFocaveis.length - 1) {
            novoFoco = focoAtual + 1;
        }

        if (novoFoco !== focoAtual) {
            atualizarFoco(novoFoco);
            e.preventDefault();
        }
    });
});




</script>


 


</body>



<?php include 'fundo.php'; ?>

 

</html>